/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common.item.armor;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2ca.common.item.armor.ArmorUtils;
import ic2ca.common.item.armor.ItemArmorElectricUtility;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemBootsStaticQuantum
extends ItemArmorElectricUtility
implements IMetalArmor {
    public static Map<EntityPlayer, Boolean> onGroundMap = new HashMap<EntityPlayer, Boolean>();
    private float jumpCharge;

    public ItemBootsStaticQuantum(String name, int renderIndex) {
        super(name, renderIndex, 3, 10000000, 12000, 4, false);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean doJump(EntityPlayer player, ItemStack itemStack) {
        boolean flag = false;
        if (IC2.platform.isSimulating()) {
            boolean wasOnGround;
            boolean bl = wasOnGround = onGroundMap.containsKey(player) ? onGroundMap.get(player) : true;
            if (wasOnGround && !player.field_70122_E && IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                ElectricItem.manager.use(itemStack, 4000.0, null);
                flag = true;
            }
            onGroundMap.put(player, player.field_70122_E);
        } else {
            if (ElectricItem.manager.canUse(itemStack, 4000.0) && player.field_70122_E) {
                this.jumpCharge = 1.0f;
            }
            if (player.field_70181_x >= 0.0 && this.jumpCharge > 0.0f && !player.func_70090_H()) {
                if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                    if (this.jumpCharge == 1.0f) {
                        player.field_70159_w *= 3.5;
                        player.field_70179_y *= 3.5;
                    }
                    player.field_70181_x += (double)(this.jumpCharge * 0.3f);
                    this.jumpCharge = (float)((double)this.jumpCharge * 0.75);
                } else if (this.jumpCharge < 1.0f) {
                    this.jumpCharge = 0.0f;
                }
            }
        }
        return flag;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "ic2ca:textures/armor/quantumstatic_1.png";
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 1.0;
    }

    @Override
    public int getEnergyPerDamage() {
        return 20000;
    }

    @Override
    public int getItemTier() {
        return 4;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = Integer.MAX_VALUE;
            if (energyPerDamage > 0) {
                damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        return super.getProperties(entity, armor, source, damage, slot);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.rare;
    }

    public boolean isMetalArmor(ItemStack var1, EntityPlayer var2) {
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemstack) {
        boolean didSomething = false;
        if (ArmorUtils.doStatic(player, itemstack)) {
            didSomething = true;
        }
        if (this.doJump(player, itemstack)) {
            didSomething = true;
        }
        if (didSomething) {
            player.field_71069_bz.func_75142_b();
        }
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        EntityLivingBase entity;
        ItemStack armor;
        if (IC2.platform.isSimulating() && event.entity instanceof EntityLivingBase && (armor = (entity = (EntityLivingBase)event.entity).func_71124_b(1)) != null && armor.func_77973_b() == this) {
            int fallDamage = Math.max((int)event.distance - 10, 0);
            int energyCost = this.getEnergyPerDamage() * fallDamage;
            if ((double)energyCost <= ElectricItem.manager.getCharge(armor)) {
                ElectricItem.manager.discharge(armor, (double)energyCost, Integer.MAX_VALUE, true, false, false);
                event.setCanceled(true);
            }
        }
    }
}

