/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common.item.armor;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.util.StackUtil;
import ic2ca.common.IC2CA;
import ic2ca.common.Util;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public abstract class ItemArmorTankUtility
extends ItemArmor
implements ISpecialArmor,
IFluidContainerItem {
    public int capacity;
    protected final Fluid allowfluid;

    public ItemArmorTankUtility(String name, int renderIndex, int piece, Fluid allowfluid, int capacity) {
        super(ItemArmor.ArmorMaterial.DIAMOND, renderIndex, piece);
        this.capacity = capacity;
        this.allowfluid = allowfluid;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.func_77655_b(name);
        this.func_77637_a(IC2CA.tabIC2CA);
        GameRegistry.registerItem((Item)this, (String)name);
    }

    public void filltank(ItemStack stack) {
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData((ItemStack)stack);
        NBTTagCompound fluidTag = nbtTagCompound.func_74775_l("Fluid");
        FluidStack fs = new FluidStack(this.allowfluid, this.getCapacity(stack));
        fs.writeToNBT(fluidTag);
        nbtTagCompound.func_74782_a("Fluid", (NBTBase)fluidTag);
    }

    public double getCharge(ItemStack itemStack) {
        if (this.getFluid(itemStack) == null) {
            return 0.0;
        }
        double ret = this.getFluid((ItemStack)itemStack).amount;
        return ret > 0.0 ? ret : 0.0;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.getCapacity(itemStack);
    }

    public void Updatedamage(ItemStack itemStack) {
        itemStack.func_77964_b(itemStack.func_77958_k() - 1 - (int)ic2.core.util.Util.map((double)this.getCharge(itemStack), (double)this.getMaxCharge(itemStack), (double)(itemStack.func_77958_k() - 2)));
    }

    public FluidStack getFluid(ItemStack stack) {
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData((ItemStack)stack);
        NBTTagCompound fluidTag = nbtTagCompound.func_74775_l("Fluid");
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
    }

    public boolean isEmpty(ItemStack stack) {
        return this.getFluid(stack) == null;
    }

    public int getCapacity(ItemStack container) {
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData((ItemStack)container);
        if (nbtTagCompound.func_74764_b("addCapacity")) {
            return this.capacity + nbtTagCompound.func_74762_e("addCapacity");
        }
        nbtTagCompound.func_74768_a("addCapacity", 0);
        return this.capacity;
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain) {
        if (stack.field_77994_a != 1) {
            return null;
        }
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData((ItemStack)stack);
        NBTTagCompound fluidTag = nbtTagCompound.func_74775_l("Fluid");
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (fs == null) {
            return null;
        }
        maxDrain = Math.min(fs.amount, maxDrain);
        if (doDrain) {
            fs.amount -= maxDrain;
            if (fs.amount <= 0) {
                nbtTagCompound.func_82580_o("Fluid");
            } else {
                fs.writeToNBT(fluidTag);
                nbtTagCompound.func_74782_a("Fluid", (NBTBase)fluidTag);
            }
        }
        this.Updatedamage(stack);
        return new FluidStack(fs, maxDrain);
    }

    public int fill(ItemStack stack, FluidStack resource, boolean doFill) {
        if (stack.field_77994_a != 1) {
            return 0;
        }
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() != this.allowfluid) {
            return 0;
        }
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData((ItemStack)stack);
        NBTTagCompound fluidTag = nbtTagCompound.func_74775_l("Fluid");
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (fs == null) {
            fs = new FluidStack(resource, 0);
        }
        if (!fs.isFluidEqual(resource)) {
            return 0;
        }
        int amount = Math.min(this.getCapacity(stack) - fs.amount, resource.amount);
        if (doFill && amount > 0) {
            fs.amount += amount;
            fs.writeToNBT(fluidTag);
            nbtTagCompound.func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        this.Updatedamage(stack);
        return amount;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        super.func_77624_a(itemStack, player, info, b);
        FluidStack fs = this.getFluid(itemStack);
        if (fs != null) {
            info.add("< " + FluidRegistry.getFluidName((FluidStack)fs) + ", " + fs.amount + "/" + this.getCapacity(itemStack) + " mB >");
        } else {
            info.add("< 0/" + this.getCapacity(itemStack) + " mB >");
        }
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = Util.register(ir, (Item)this);
    }

    public abstract String getArmorTexture(ItemStack var1, Entity var2, int var3, String var4);
}

