/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common.item.armor;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.IC2Potion;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.init.MainConfig;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import ic2.core.util.StackUtil;
import ic2ca.common.IC2CA;
import ic2ca.common.Ic2caItems;
import ic2ca.common.item.armor.ArmorUtils;
import ic2ca.common.item.armor.IJetpack;
import ic2ca.common.item.armor.ItemArmorElectricUtility;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemArmorExoQuantum
extends ItemArmorElectricUtility
implements IMetalArmor,
IJetpack {
    public static Map<EntityPlayer, Integer> speedTickerMap = new HashMap<EntityPlayer, Integer>();
    public static Map<EntityPlayer, Boolean> onGroundMap = new HashMap<EntityPlayer, Boolean>();
    public static Map<EntityPlayer, Boolean> enableQuantumSpeedOnSprintMap = new HashMap<EntityPlayer, Boolean>();
    private float jumpCharge;
    public static AudioSource audioSource;
    private static boolean lastJetpackUsed;
    private static final Map<Integer, Integer> potionRemovalCost;

    public ItemArmorExoQuantum(String name, int renderIndex, int piece) {
        super(name, renderIndex, piece, 10000000, 12000, 4, false);
        if (piece == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        potionRemovalCost.put(Potion.field_76436_u.field_76415_H, 10000);
        potionRemovalCost.put(IC2Potion.radiation.field_76415_H, 10000);
        potionRemovalCost.put(Potion.field_82731_v.field_76415_H, 25000);
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (Item.func_150891_b((Item)stack.func_77973_b()) == Item.func_150891_b((Item)Ic2caItems.exoQuantumHelm.func_77973_b()) || Item.func_150891_b((Item)stack.func_77973_b()) == Item.func_150891_b((Item)Ic2caItems.exoQuantumChest.func_77973_b()) || Item.func_150891_b((Item)stack.func_77973_b()) == Item.func_150891_b((Item)Ic2caItems.exoQuantumBoots.func_77973_b())) {
            return "ic2ca:textures/armor/exoquantum_1.png";
        }
        return "ic2ca:textures/armor/exoquantum_2.png";
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return this.field_77881_a == 1 ? 1.1 : 1.0;
    }

    @Override
    public int getEnergyPerDamage() {
        return 20000;
    }

    @Override
    public int getItemTier() {
        return 4;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == 3) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = Integer.MAX_VALUE;
            if (energyPerDamage > 0) {
                damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        return super.getProperties(entity, armor, source, damage, slot);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.rare;
    }

    public boolean isMetalArmor(ItemStack var1, EntityPlayer var2) {
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        if (!nbtData.func_74764_b("jetpack")) {
            nbtData.func_74757_a("jetpack", true);
        }
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean ret = false;
        switch (this.field_77881_a) {
            case 0: {
                if (ArmorUtils.setNightvision(player, itemStack)) {
                    ret = true;
                }
                if (!ArmorUtils.setAirFood(player, itemStack)) break;
                ret = true;
                break;
            }
            case 1: {
                boolean jetpack = nbtData.func_74767_n("jetpack");
                boolean hoverMode = nbtData.func_74767_n("hoverMode");
                boolean jetpackUsed = false;
                if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = hoverMode = !hoverMode;
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74757_a("hoverMode", hoverMode);
                        if (hoverMode) {
                            IC2.platform.messagePlayer(player, "Quantum Hover Mode enabled.", new Object[0]);
                        } else {
                            IC2.platform.messagePlayer(player, "Quantum Hover Mode disabled.", new Object[0]);
                        }
                    }
                }
                if (IC2.keyboard.isBoostKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = jetpack = !jetpack;
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74757_a("jetpack", jetpack);
                        if (jetpack) {
                            IC2.platform.messagePlayer(player, "Quantum Jetpack enabled.", new Object[0]);
                        } else {
                            IC2.platform.messagePlayer(player, "Quantum Jetpack disabled.", new Object[0]);
                        }
                    }
                }
                if (jetpack && (IC2.keyboard.isJumpKeyDown(player) || hoverMode && player.field_70181_x < -0.02999999932944775)) {
                    jetpackUsed = this.useJetpack(player, hoverMode, nbtData.func_74767_n("isFlyActive"));
                }
                if (IC2.platform.isSimulating() && toggleTimer > 0) {
                    toggleTimer = (byte)(toggleTimer - 1);
                    nbtData.func_74774_a("toggleTimer", toggleTimer);
                }
                if (IC2.platform.isRendering() && player == IC2.platform.getPlayerInstance()) {
                    if (lastJetpackUsed != jetpackUsed) {
                        if (jetpackUsed) {
                            if (audioSource == null) {
                                audioSource = IC2.audioManager.createSource((Object)player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                            }
                            if (audioSource != null) {
                                audioSource.play();
                            }
                        } else if (audioSource != null) {
                            audioSource.remove();
                            audioSource = null;
                        }
                        lastJetpackUsed = jetpackUsed;
                    }
                    if (audioSource != null) {
                        audioSource.updatePosition();
                    }
                }
                ret = jetpackUsed;
                player.func_70066_B();
                break;
            }
            case 2: {
                int speedTicker;
                boolean enableQuantumSpeedOnSprint = true;
                if (IC2.platform.isRendering()) {
                    enableQuantumSpeedOnSprint = ConfigUtil.getBool((Config)MainConfig.get(), (String)"misc/quantumSpeedOnSprint");
                } else if (enableQuantumSpeedOnSprintMap.containsKey(player)) {
                    enableQuantumSpeedOnSprint = enableQuantumSpeedOnSprintMap.get(player);
                }
                if (!ElectricItem.manager.canUse(itemStack, 1000.0) || !player.field_70122_E && !player.func_70090_H() || !IC2.keyboard.isForwardKeyDown(player) || (!enableQuantumSpeedOnSprint || !player.func_70051_ag()) && (enableQuantumSpeedOnSprint || !IC2.keyboard.isBoostKeyDown(player))) break;
                int n = speedTicker = speedTickerMap.containsKey(player) ? speedTickerMap.get(player) : 0;
                if (++speedTicker >= 10) {
                    speedTicker = 0;
                    ElectricItem.manager.use(itemStack, 1000.0, null);
                    ret = true;
                }
                speedTickerMap.put(player, speedTicker);
                float speed = 0.22f;
                if (player.func_70090_H()) {
                    speed = 0.1f;
                    if (IC2.keyboard.isJumpKeyDown(player)) {
                        player.field_70181_x += (double)0.1f;
                    }
                }
                if (!(speed > 0.0f)) break;
                player.func_70060_a(0.0f, 1.0f, speed);
                break;
            }
            case 3: {
                if (IC2.platform.isSimulating()) {
                    boolean wasOnGround;
                    boolean bl = wasOnGround = onGroundMap.containsKey(player) ? onGroundMap.get(player) : true;
                    if (wasOnGround && !player.field_70122_E && IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                        ElectricItem.manager.use(itemStack, 4000.0, null);
                        ret = true;
                    }
                    onGroundMap.put(player, player.field_70122_E);
                    break;
                }
                if (ElectricItem.manager.canUse(itemStack, 4000.0) && player.field_70122_E) {
                    this.jumpCharge = 1.0f;
                }
                if (!(player.field_70181_x >= 0.0) || !(this.jumpCharge > 0.0f) || player.func_70090_H()) break;
                if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                    if (this.jumpCharge == 1.0f) {
                        player.field_70159_w *= 3.5;
                        player.field_70179_y *= 3.5;
                    }
                    player.field_70181_x += (double)(this.jumpCharge * 0.3f);
                    this.jumpCharge = (float)((double)this.jumpCharge * 0.75);
                    break;
                }
                if (!(this.jumpCharge < 1.0f)) break;
                this.jumpCharge = 0.0f;
            }
        }
        if (ret) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public boolean useJetpack(EntityPlayer player, boolean hoverMode, boolean boost) {
        int worldHeight;
        double y;
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if (ElectricItem.manager.getCharge(jetpack) == 0.0) {
            return false;
        }
        float power = 1.0f;
        float dropPercentage = 0.05f;
        if ((double)((float)ElectricItem.manager.getCharge(jetpack)) / this.getMaxCharge(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (ElectricItem.manager.getCharge(jetpack) / (this.getMaxCharge(jetpack) * (double)dropPercentage)));
        }
        if (IC2.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster = 3.5f;
            if (hoverMode) {
                retruster = 0.5f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                if (boost) {
                    player.func_70060_a(0.0f, 0.4f * forwardpower, 0.1f);
                } else {
                    player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
                }
            }
        }
        if ((y = player.field_70163_u) > (double)((worldHeight = IC2.getWorldHeight((World)player.field_70170_p)) - 25)) {
            if (y > (double)worldHeight) {
                y = worldHeight;
            }
            power = (float)((double)power * (((double)worldHeight - y) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = -0.025f;
            if (IC2.keyboard.isSneakKeyDown(player)) {
                maxHoverY = -0.1f;
            }
            if (IC2.keyboard.isJumpKeyDown(player)) {
                maxHoverY = 0.1f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        double consume = 8.0;
        if (hoverMode) {
            consume = 10.0;
        }
        if (boost) {
            consume += (double)IC2CA.turbineEUAmount;
        }
        ElectricItem.manager.discharge(jetpack, consume, Integer.MAX_VALUE, true, false, false);
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        EntityLivingBase entity;
        ItemStack armor;
        if (IC2.platform.isSimulating() && event.entity instanceof EntityLivingBase && (armor = (entity = (EntityLivingBase)event.entity).func_71124_b(1)) != null && armor.func_77973_b() == this) {
            int fallDamage = Math.max((int)event.distance - 10, 0);
            double energyCost = this.getEnergyPerDamage() * fallDamage;
            if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false, false);
                event.setCanceled(true);
            }
        }
    }

    public static void removePlayerReferences(EntityPlayer player) {
        speedTickerMap.remove(player);
        onGroundMap.remove(player);
        enableQuantumSpeedOnSprintMap.remove(player);
    }

    static {
        lastJetpackUsed = false;
        potionRemovalCost = new HashMap<Integer, Integer>();
    }
}

