/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common.item.armor;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2ca.common.Ic2caItems;
import ic2ca.common.item.armor.ArmorUtils;
import ic2ca.common.item.armor.ItemArmorElectricUtility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemArmorExoNano
extends ItemArmorElectricUtility
implements IMetalArmor {
    public ItemArmorExoNano(String name, int renderIndex, int piece) {
        super(name, renderIndex, piece, 1000000, 1600, 3, false);
        if (piece == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (Item.func_150891_b((Item)stack.func_77973_b()) == Item.func_150891_b((Item)Ic2caItems.exoNanoHelm.func_77973_b()) || Item.func_150891_b((Item)stack.func_77973_b()) == Item.func_150891_b((Item)Ic2caItems.exoNanoChest.func_77973_b()) || Item.func_150891_b((Item)stack.func_77973_b()) == Item.func_150891_b((Item)Ic2caItems.exoNanoBoots.func_77973_b())) {
            return "ic2ca:textures/armor/exonano_1.png";
        }
        return "ic2ca:textures/armor/exonano_2.png";
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.9;
    }

    @Override
    public int getEnergyPerDamage() {
        return 5000;
    }

    @Override
    public int getItemTier() {
        return 3;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == 3) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = Integer.MAX_VALUE;
            if (energyPerDamage > 0) {
                damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
            }
            return new ISpecialArmor.ArmorProperties(10, damage < 8.0 ? 1.0 : 0.875, damageLimit);
        }
        return super.getProperties(entity, armor, source, damage, slot);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.uncommon;
    }

    public boolean isMetalArmor(ItemStack var1, EntityPlayer var2) {
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (this.field_77881_a == 0 && ArmorUtils.setNightvision(player, itemStack)) {
            player.field_71069_bz.func_75142_b();
        }
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        EntityLivingBase entity;
        ItemStack armor;
        if (IC2.platform.isSimulating() && event.entity instanceof EntityLivingBase && (armor = (entity = (EntityLivingBase)event.entity).func_71124_b(1)) != null && armor.func_77973_b() == this) {
            int fallDamage = (int)event.distance - 3;
            if (fallDamage >= 8) {
                return;
            }
            double energyCost = this.getEnergyPerDamage() * fallDamage;
            if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false, false);
                event.setCanceled(true);
            }
        }
    }
}

