/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import ic2.core.util.StackUtil;
import ic2ca.common.Ic2caItems;
import ic2ca.common.item.armor.IJetpack;
import ic2ca.common.item.armor.ItemArmorTankUtility;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemArmorExoJet
extends ItemArmorTankUtility
implements IJetpack {
    public static AudioSource audioSource;
    private static boolean lastJetpackUsed;

    public ItemArmorExoJet(String name, int renderIndex) {
        super(name, renderIndex, 1, BlocksItems.getFluid((InternalName)InternalName.fluidBiogas), 30000);
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "ic2ca:textures/armor/exojet_1.png";
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean par4) {
        info.add(StatCollector.func_74838_a((String)"info.upgrademoduleinstalled"));
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (nbt.func_74767_n("flight")) {
            info.add(StatCollector.func_74838_a((String)"info.flightturbineinstalled"));
        }
        super.func_77624_a(stack, player, info, par4);
    }

    public boolean useJetpack(EntityPlayer player, boolean hoverMode, boolean boost) {
        int worldHeight;
        double y;
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if (this.getCharge(jetpack) <= 0.0) {
            return false;
        }
        float power = 1.0f;
        float dropPercentage = 0.2f;
        if (this.getCharge(jetpack) / this.getMaxCharge(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (this.getCharge(jetpack) / (this.getMaxCharge(jetpack) * (double)dropPercentage)));
        }
        if (IC2.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster = 0.15f;
            if (hoverMode) {
                retruster = 0.5f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                if (boost) {
                    player.func_70060_a(0.0f, 0.4f * forwardpower, 0.1f);
                } else {
                    player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
                }
            }
        }
        if ((y = player.field_70163_u) > (double)((worldHeight = IC2.getWorldHeight((World)player.field_70170_p)) - 25)) {
            if (y > (double)worldHeight) {
                y = worldHeight;
            }
            power = (float)((double)power * (((double)worldHeight - y) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = 0.0f;
            if (IC2.keyboard.isJumpKeyDown(player)) {
                maxHoverY = 0.2f;
            }
            if (IC2.keyboard.isSneakKeyDown(player)) {
                maxHoverY = -0.2f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        int consume = 2;
        if (hoverMode) {
            consume = 1;
        }
        this.drainfromJetpack(jetpack, consume);
        this.Updatedamage(jetpack);
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    public boolean drainfromJetpack(ItemStack pack, int amount) {
        if (this.isEmpty(pack)) {
            return false;
        }
        if (this.drain((ItemStack)pack, (int)amount, (boolean)false).amount < amount) {
            return false;
        }
        this.drain(pack, amount, true);
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (player.field_71071_by.field_70460_b[2] != itemStack) {
            return;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        boolean hoverMode = nbtData.func_74767_n("hoverMode");
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean jetpackUsed = false;
        if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = hoverMode = !hoverMode;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("hoverMode", hoverMode);
                if (hoverMode) {
                    IC2.platform.messagePlayer(player, "Hover Mode enabled.", new Object[0]);
                } else {
                    IC2.platform.messagePlayer(player, "Hover Mode disabled.", new Object[0]);
                }
            }
        }
        if (IC2.keyboard.isJumpKeyDown(player) || hoverMode) {
            jetpackUsed = this.useJetpack(player, hoverMode, nbtData.func_74767_n("isFlyActive"));
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        if (IC2.platform.isRendering() && player == IC2.platform.getPlayerInstance()) {
            if (lastJetpackUsed != jetpackUsed) {
                if (jetpackUsed) {
                    if (audioSource == null) {
                        audioSource = IC2.audioManager.createSource((Object)player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (audioSource != null) {
                        audioSource.play();
                    }
                } else if (audioSource != null) {
                    audioSource.remove();
                    audioSource = null;
                }
                lastJetpackUsed = jetpackUsed;
            }
            if (audioSource != null) {
                audioSource.updatePosition();
            }
        }
        if (jetpackUsed) {
            player.field_71069_bz.func_75142_b();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack itemStack = new ItemStack(Ic2caItems.exoJet.func_77973_b(), 1);
        this.filltank(itemStack);
        itemStack.func_77964_b(1);
        itemList.add(itemStack);
        itemStack = new ItemStack(Ic2caItems.exoJet.func_77973_b(), 1);
        itemStack.func_77964_b(this.func_77612_l());
        itemList.add(itemStack);
    }

    static {
        lastJetpackUsed = false;
    }
}

