/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common.item.armor;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.util.StackUtil;
import ic2ca.common.IC2CA;
import ic2ca.common.IItemUpgradeable;
import ic2ca.common.Util;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ISpecialArmor;

public abstract class ItemArmorElectricUtility
extends ItemArmor
implements ISpecialArmor,
IElectricItem,
IItemUpgradeable {
    public int defaultMaxCharge;
    public int transferLimit;
    public int tier;
    public boolean share;

    public ItemArmorElectricUtility(String name, int renderIndex, int piece, int maxCharge, int transferLimit, int tier, boolean share) {
        super(ItemArmor.ArmorMaterial.DIAMOND, renderIndex, piece);
        this.tier = tier;
        this.defaultMaxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.share = share;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.func_77655_b(name);
        this.func_77637_a(IC2CA.tabIC2CA);
        GameRegistry.registerItem((Item)this, (String)name);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List info, boolean par4) {
        int i;
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)par1ItemStack);
        if (!nbt.func_74767_n("loaded")) {
            if (nbt.func_74762_e("tier") == 0) {
                nbt.func_74768_a("tier", this.getDefaultTier());
            }
            if (nbt.func_74762_e("transferLimit") == 0) {
                nbt.func_74768_a("transferLimit", this.getDefaultTransferLimit());
            }
            if (nbt.func_74762_e("maxCharge") == 0) {
                nbt.func_74768_a("maxCharge", this.getDefaultMaxCharge());
            }
            nbt.func_74757_a("loaded", true);
        }
        info.add(StatCollector.func_74838_a((String)"info.upgrademoduleinstalled"));
        if (nbt.func_74767_n("flight")) {
            info.add(StatCollector.func_74838_a((String)"info.flightturbineinstalled"));
        }
        if (nbt.func_74767_n("cloaking")) {
            info.add(StatCollector.func_74838_a((String)"info.cloakingmoduleinstalled"));
        }
        if (nbt.func_74767_n("overcharge")) {
            info.add(StatCollector.func_74838_a((String)"info.dischargemoduleinstalled"));
        }
        if (nbt.func_74762_e("solarProd") > 0) {
            i = nbt.func_74762_e("solarProd") + 1;
            info.add(String.format(StatCollector.func_74838_a((String)"info.solarproduces"), i));
        }
        if (nbt.func_74762_e("staticProd") > 0) {
            i = nbt.func_74762_e("staticProd") + 1;
            info.add(String.format(StatCollector.func_74838_a((String)"info.staticproduces"), i));
        }
        if (nbt.func_74762_e("transferLimit") != this.getDefaultTransferLimit()) {
            info.add(String.format(StatCollector.func_74838_a((String)"info.transferspeed"), nbt.func_74762_e("transferLimit")));
        }
        info.add(String.format(StatCollector.func_74838_a((String)"info.powertier"), nbt.func_74762_e("tier")));
    }

    public boolean canProvideEnergy(ItemStack itemstack) {
        return this.share;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage()) {
            return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
        }
        return 0;
    }

    public abstract String getArmorTexture(ItemStack var1, Entity var2, int var3, String var4);

    private double getBaseAbsorptionRatio() {
        switch (this.field_77881_a) {
            case 0: {
                return 0.15;
            }
            case 1: {
                return 0.4;
            }
            case 2: {
                return 0.3;
            }
            case 3: {
                return 0.15;
            }
        }
        return 0.0;
    }

    public Item getChargedItem(ItemStack itemstack) {
        return this;
    }

    public abstract double getDamageAbsorptionRatio();

    @Override
    public int getDefaultMaxCharge() {
        return this.defaultMaxCharge;
    }

    @Override
    public int getDefaultTier() {
        return this.tier;
    }

    @Override
    public int getDefaultTransferLimit() {
        return this.transferLimit;
    }

    public Item getEmptyItem(ItemStack itemstack) {
        return this;
    }

    public abstract int getEnergyPerDamage();

    public boolean func_82789_a(ItemStack var1, ItemStack var2) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @Override
    public abstract int getItemTier();

    public double getMaxCharge(ItemStack itemstack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        if (nbt.func_74762_e("maxCharge") == 0) {
            nbt.func_74768_a("maxCharge", this.getDefaultMaxCharge());
        }
        return nbt.func_74762_e("maxCharge");
    }

    @Override
    public int getMaxUpgradeableCharge() {
        return IC2CA.maxEnergyUpgrades - this.getDefaultMaxCharge();
    }

    @Override
    public int getMaxUpgradeableTransfer() {
        return IC2CA.maxTransferUpgrades - this.getDefaultTransferLimit();
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = Integer.MAX_VALUE;
        if (energyPerDamage > 0) {
            damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
        }
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public void func_150895_a(Item id, CreativeTabs var2, List itemList) {
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
        itemList.add(charged);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public int getTier(ItemStack itemstack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        if (nbt.func_74762_e("tier") == 0) {
            nbt.func_74768_a("tier", this.getDefaultTier());
        }
        return nbt.func_74762_e("tier");
    }

    public double getTransferLimit(ItemStack itemstack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        if (nbt.func_74762_e("transferLimit") == 0) {
            nbt.func_74768_a("transferLimit", this.getDefaultTransferLimit());
        }
        return nbt.func_74762_e("transferLimit");
    }

    public boolean isRepairable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = Util.register(ir, (Item)this);
    }
}

