/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.util.StackUtil;
import ic2ca.common.IC2CA;
import ic2ca.common.item.armor.IJetpack;
import ic2ca.common.item.armor.ItemArmorElectricUtility;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class ItemArmorBaseQuantum
extends ItemArmorElectricUtility
implements IJetpack,
IMetalArmor {
    public static boolean lastJetpackUsed = false;
    public static AudioSource audioSource;

    public ItemArmorBaseQuantum(String name, int renderIndex, int piece, int maxCharge, int transferLimit, int tier, boolean share) {
        super(name, renderIndex, piece, maxCharge, transferLimit, tier, share);
    }

    @Override
    public abstract String getArmorTexture(ItemStack var1, Entity var2, int var3, String var4);

    public double getCharge(ItemStack itemStack) {
        return ElectricItem.manager.getCharge(itemStack);
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 1.1;
    }

    @Override
    public int getEnergyPerDamage() {
        return 20000;
    }

    @Override
    public abstract int getItemTier();

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.rare;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack itemStack = new ItemStack((Item)this, 1);
        if (Item.func_150891_b((Item)this.getChargedItem(itemStack)) == Item.func_150891_b((Item)this)) {
            ItemStack charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (Item.func_150891_b((Item)this.getEmptyItem(itemStack)) == Item.func_150891_b((Item)this)) {
            itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (player.field_71071_by.field_70460_b[2] != itemStack) {
            return;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        if (!nbtData.func_74764_b("jetpack")) {
            nbtData.func_74757_a("jetpack", true);
        }
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean jetpack = nbtData.func_74767_n("jetpack");
        boolean hoverMode = nbtData.func_74767_n("hoverMode");
        boolean jetpackUsed = false;
        if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = hoverMode = !hoverMode;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("hoverMode", hoverMode);
                if (hoverMode) {
                    IC2.platform.messagePlayer(player, "Quantum Hover Mode enabled.", new Object[0]);
                } else {
                    IC2.platform.messagePlayer(player, "Quantum Hover Mode disabled.", new Object[0]);
                }
            }
        }
        if (IC2.keyboard.isBoostKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = jetpack = !jetpack;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("jetpack", jetpack);
                if (jetpack) {
                    IC2.platform.messagePlayer(player, "Quantum Jetpack enabled.", new Object[0]);
                } else {
                    IC2.platform.messagePlayer(player, "Quantum Jetpack disabled.", new Object[0]);
                }
            }
        }
        if (jetpack && (IC2.keyboard.isJumpKeyDown(player) || hoverMode && player.field_70181_x < -0.02999999932944775)) {
            jetpackUsed = this.useJetpack(player, hoverMode, nbtData.func_74767_n("isFlyActive"));
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        if (IC2.platform.isRendering() && player == IC2.platform.getPlayerInstance()) {
            if (lastJetpackUsed != jetpackUsed) {
                if (jetpackUsed) {
                    if (audioSource == null) {
                        audioSource = IC2.audioManager.createSource((Object)player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (audioSource != null) {
                        audioSource.play();
                    }
                } else if (audioSource != null) {
                    audioSource.remove();
                    audioSource = null;
                }
                lastJetpackUsed = jetpackUsed;
            }
            if (audioSource != null) {
                audioSource.updatePosition();
            }
        }
        player.func_70066_B();
        if (jetpackUsed) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public void use(ItemStack itemStack, double amount) {
        ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, false);
    }

    public boolean useJetpack(EntityPlayer player, boolean hoverMode, boolean boost) {
        int worldHeight;
        double y;
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if (this.getCharge(jetpack) == 0.0) {
            return false;
        }
        float power = 1.0f;
        float dropPercentage = 0.05f;
        if ((float)this.getCharge(jetpack) / (float)this.getDefaultMaxCharge() <= dropPercentage) {
            power *= (float)this.getCharge(jetpack) / ((float)this.getDefaultMaxCharge() * dropPercentage);
        }
        if (IC2.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster = 3.5f;
            if (hoverMode) {
                retruster = 0.5f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                if (boost) {
                    player.func_70060_a(0.0f, 0.4f * forwardpower, 0.1f);
                } else {
                    player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
                }
            }
        }
        if ((y = player.field_70163_u) > (double)((worldHeight = IC2.getWorldHeight((World)player.field_70170_p)) - 25)) {
            if (y > (double)worldHeight) {
                y = worldHeight;
            }
            power = (float)((double)power * (((double)worldHeight - y) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = -0.025f;
            if (IC2.keyboard.isSneakKeyDown(player)) {
                maxHoverY = -0.1f;
            }
            if (IC2.keyboard.isJumpKeyDown(player)) {
                maxHoverY = 0.1f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        double consume = 8.0;
        if (hoverMode) {
            consume = 10.0;
        }
        if (boost) {
            consume += (double)IC2CA.turbineEUAmount;
        }
        this.use(jetpack, consume);
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    public boolean isMetalArmor(ItemStack var1, EntityPlayer var2) {
        return true;
    }
}

