/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common.item.armor;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.IC2Potion;
import ic2.core.Ic2Items;
import ic2.core.block.generator.tileentity.TileEntitySolarGenerator;
import ic2.core.item.ItemTinCan;
import ic2.core.util.StackUtil;
import ic2ca.common.IC2CA;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ArmorUtils {
    private static final Map<Integer, Integer> potionRemovalCost = new HashMap<Integer, Integer>();

    public ArmorUtils() {
        potionRemovalCost.put(Potion.field_76436_u.field_76415_H, 10000);
        potionRemovalCost.put(IC2Potion.radiation.field_76415_H, 10000);
        potionRemovalCost.put(Potion.field_82731_v.field_76415_H, 25000);
    }

    public static boolean setAirFood(EntityPlayer player, ItemStack itemStack) {
        boolean ret = false;
        int air = player.func_70086_ai();
        if (ElectricItem.manager.canUse(itemStack, 1000.0) && air < 100) {
            player.func_70050_g(air + 200);
            ElectricItem.manager.use(itemStack, 1000.0, null);
            ret = true;
        } else if (air <= 0) {
            IC2.achievements.issueAchievement(player, "starveWithQHelmet");
        }
        if (ElectricItem.manager.canUse(itemStack, 1000.0) && player.func_71024_bL().func_75121_c()) {
            int slot = -1;
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].func_77973_b() != Ic2Items.filledTinCan.func_77973_b()) continue;
                slot = i;
                break;
            }
            if (slot > -1) {
                ItemStack stack = player.field_71071_by.field_70462_a[slot];
                ItemTinCan can = (ItemTinCan)stack.func_77973_b();
                stack = can.onEaten(player, stack);
                if (stack.field_77994_a <= 0) {
                    player.field_71071_by.field_70462_a[slot] = null;
                }
                ElectricItem.manager.use(itemStack, 1000.0, null);
                ret = true;
            }
        } else if (player.func_71024_bL().func_75116_a() <= 0) {
            IC2.achievements.issueAchievement(player, "starveWithQHelmet");
        }
        for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
            int id = effect.func_76456_a();
            Integer cost = potionRemovalCost.get(id);
            if (cost == null || !ElectricItem.manager.canUse(itemStack, (double)(cost = Integer.valueOf(cost * (effect.func_76458_c() + 1))).intValue())) continue;
            ElectricItem.manager.use(itemStack, (double)cost.intValue(), null);
            IC2.platform.removePotion((EntityLivingBase)player, id);
        }
        return ret;
    }

    public static boolean setNightvision(EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean ret = false;
        boolean Nightvision = nbtData.func_74767_n("Nightvision");
        short hubmode = nbtData.func_74765_d("HudMode");
        if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = Nightvision = !Nightvision;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("Nightvision", Nightvision);
                if (Nightvision) {
                    IC2.platform.messagePlayer(player, "Nightvision enabled.", new Object[0]);
                } else {
                    IC2.platform.messagePlayer(player, "Nightvision disabled.", new Object[0]);
                }
            }
        }
        if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isHudModeKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            hubmode = hubmode == 2 ? (short)0 : (short)(hubmode + 1);
            if (IC2.platform.isSimulating()) {
                nbtData.func_74777_a("HudMode", hubmode);
                switch (hubmode) {
                    case 0: {
                        IC2.platform.messagePlayer(player, "HUD disabled.", new Object[0]);
                        break;
                    }
                    case 1: {
                        IC2.platform.messagePlayer(player, "HUD (basic) enabled.", new Object[0]);
                        break;
                    }
                    case 2: {
                        IC2.platform.messagePlayer(player, "HUD (extended) enabled", new Object[0]);
                    }
                }
            }
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        if (Nightvision && IC2.platform.isSimulating() && ElectricItem.manager.use(itemStack, 1.0, (EntityLivingBase)player)) {
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            int y = MathHelper.func_76128_c((double)player.field_70163_u);
            int skylight = player.field_70170_p.func_72957_l(x, y, z);
            if (skylight > 8) {
                IC2.platform.removePotion((EntityLivingBase)player, Potion.field_76439_r.field_76415_H);
                player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 0, true));
            } else {
                IC2.platform.removePotion((EntityLivingBase)player, Potion.field_76440_q.field_76415_H);
                player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, 0, true));
            }
            ret = true;
        }
        return ret;
    }

    public static boolean solarPanel(EntityPlayer player, ItemStack itemstack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        boolean ret = false;
        int prod = nbt.func_74762_e("solarProd") > 0 ? nbt.func_74762_e("solarProd") + 1 : 1;
        if (!player.field_70170_p.field_72995_K && TileEntitySolarGenerator.isSunVisible((World)player.field_70170_p, (int)((int)player.field_70165_t), (int)((int)player.field_70163_u + 1), (int)((int)player.field_70161_v))) {
            if (player.field_71071_by.field_70460_b[IC2CA.soPriority1] != null && player.field_71071_by.field_70460_b[IC2CA.soPriority1].func_77973_b() instanceof IElectricItem && IC2CA.tryChargeSolar(player, IC2CA.soPriority1, prod)) {
                ret = true;
            } else if (player.field_71071_by.field_70460_b[IC2CA.soPriority2] != null && player.field_71071_by.field_70460_b[IC2CA.soPriority2].func_77973_b() instanceof IElectricItem && IC2CA.tryChargeSolar(player, IC2CA.soPriority2, prod)) {
                ret = true;
            } else if (player.field_71071_by.field_70460_b[IC2CA.soPriority3] != null && player.field_71071_by.field_70460_b[IC2CA.soPriority3].func_77973_b() instanceof IElectricItem && IC2CA.tryChargeSolar(player, IC2CA.soPriority3, prod)) {
                ret = true;
            } else if (player.field_71071_by.field_70460_b[IC2CA.soPriority4] != null && player.field_71071_by.field_70460_b[IC2CA.soPriority4].func_77973_b() instanceof IElectricItem && IC2CA.tryChargeSolar(player, IC2CA.soPriority4, prod)) {
                ret = true;
            }
        }
        return ret;
    }

    public static boolean doStatic(EntityPlayer player, ItemStack itemStack) {
        double distance;
        boolean isNotWalking;
        boolean stuff = false;
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        int prod = 0;
        if (nbt.func_74762_e("staticProd") > 0) {
            prod = nbt.func_74762_e("staticProd");
        }
        boolean bl = isNotWalking = player.field_70154_o != null || player.func_70090_H();
        if (!nbt.func_74764_b("x") || isNotWalking) {
            nbt.func_74768_a("x", (int)player.field_70165_t);
        }
        if (!nbt.func_74764_b("z") || isNotWalking) {
            nbt.func_74768_a("z", (int)player.field_70161_v);
        }
        if ((distance = Math.sqrt((nbt.func_74762_e("x") - (int)player.field_70165_t) * (nbt.func_74762_e("x") - (int)player.field_70165_t) + (nbt.func_74762_e("z") - (int)player.field_70161_v) * (nbt.func_74762_e("z") - (int)player.field_70161_v))) >= 5.0) {
            nbt.func_74768_a("x", (int)player.field_70165_t);
            nbt.func_74768_a("z", (int)player.field_70161_v);
            if (player.field_71071_by.field_70460_b[IC2CA.stPriority1] != null && player.field_71071_by.field_70460_b[IC2CA.stPriority1].func_77973_b() instanceof IElectricItem && IC2CA.tryChargeStatic(player, IC2CA.stPriority1, distance, prod)) {
                stuff = true;
            } else if (player.field_71071_by.field_70460_b[IC2CA.stPriority2] != null && player.field_71071_by.field_70460_b[IC2CA.stPriority2].func_77973_b() instanceof IElectricItem && IC2CA.tryChargeStatic(player, IC2CA.stPriority2, distance, prod)) {
                stuff = true;
            } else if (player.field_71071_by.field_70460_b[IC2CA.stPriority3] != null && player.field_71071_by.field_70460_b[IC2CA.stPriority3].func_77973_b() instanceof IElectricItem && IC2CA.tryChargeStatic(player, IC2CA.stPriority3, distance, prod)) {
                stuff = true;
            } else if (player.field_71071_by.field_70460_b[IC2CA.stPriority4] != null && player.field_71071_by.field_70460_b[IC2CA.stPriority4].func_77973_b() instanceof IElectricItem && IC2CA.tryChargeStatic(player, IC2CA.stPriority4, distance, prod)) {
                stuff = true;
            }
        }
        return stuff;
    }
}

