/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common.item;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.util.StackUtil;
import ic2ca.common.IC2CA;
import ic2ca.common.IItemUpgradeable;
import ic2ca.common.Ic2caItems;
import ic2ca.common.Util;
import ic2ca.common.entity.EntityTechArrow;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class ItemNanoBow
extends Item
implements IElectricItem,
IItemUpgradeable {
    public IIcon[] icons;

    public ItemNanoBow(String name) {
        this.field_77777_bU = 1;
        this.func_77656_e(27);
        this.func_77664_n();
        this.func_77655_b(name);
        this.func_77637_a(IC2CA.tabIC2CA);
        GameRegistry.registerItem((Item)this, (String)name);
        this.icons = new IIcon[4];
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List info, boolean par4) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)par1ItemStack);
        IElectricItem elec = (IElectricItem)par1ItemStack.func_77973_b();
        if (!nbt.func_74767_n("loaded")) {
            if (nbt.func_74762_e("tier") == 0) {
                nbt.func_74768_a("tier", elec.getTier(par1ItemStack));
            }
            if (nbt.func_74769_h("transferLimit") == 0.0) {
                nbt.func_74780_a("transferLimit", elec.getTransferLimit(par1ItemStack));
            }
            if (nbt.func_74769_h("maxCharge") == 0.0) {
                nbt.func_74780_a("maxCharge", elec.getMaxCharge(par1ItemStack));
            }
            nbt.func_74757_a("loaded", true);
        }
        if (nbt.func_74769_h("transferLimit") != elec.getTransferLimit(par1ItemStack)) {
            info.add(String.format(StatCollector.func_74838_a((String)"info.transferspeed"), nbt.func_74769_h("transferLimit")));
        }
        if (nbt.func_74762_e("tier") != elec.getTier(par1ItemStack)) {
            info.add(String.format(StatCollector.func_74838_a((String)"info.chargingtier"), nbt.func_74762_e("tier")));
        }
    }

    public boolean canProvideEnergy(ItemStack is) {
        return false;
    }

    public Item getChargedItem(ItemStack is) {
        return this;
    }

    @Override
    public int getDefaultMaxCharge() {
        return 40000;
    }

    @Override
    public int getDefaultTier() {
        return 2;
    }

    @Override
    public int getDefaultTransferLimit() {
        return 128;
    }

    public Item getEmptyItem(ItemStack is) {
        return this;
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (usingItem != null && Item.func_150891_b((Item)usingItem.func_77973_b()) == Item.func_150891_b((Item)Ic2caItems.nanoBow.func_77973_b())) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            int mode = nbt.func_74762_e("bowMode");
            int i1 = 18;
            int i2 = 13;
            if (mode == 4 || mode == 6) {
                i1 = 36;
                i2 = 26;
            } else if (mode == 2) {
                i1 = 5;
                i2 = 3;
            }
            int k = usingItem.func_77988_m() - useRemaining;
            if (k >= i1) {
                return this.icons[3];
            }
            if (k > i2) {
                return this.icons[2];
            }
            if (k > 0) {
                return this.icons[1];
            }
        }
        return this.icons[0];
    }

    public boolean func_82789_a(ItemStack var1, ItemStack var2) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @Override
    public int getItemTier() {
        return 3;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public double getMaxCharge(ItemStack itemstack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        if (nbt.func_74769_h("maxCharge") == 0.0) {
            nbt.func_74780_a("maxCharge", (double)this.getDefaultMaxCharge());
        }
        return nbt.func_74769_h("maxCharge");
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)par1ItemStack);
        int mode = nbt.func_74762_e("bowMode");
        if (mode == 4 || mode == 6) {
            return 144000;
        }
        if (mode == 2) {
            return 18000;
        }
        return 72000;
    }

    @Override
    public int getMaxUpgradeableCharge() {
        return IC2CA.maxEnergyUpgrades - this.getDefaultMaxCharge();
    }

    @Override
    public int getMaxUpgradeableTransfer() {
        return IC2CA.maxTransferUpgrades - this.getDefaultTransferLimit();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.uncommon;
    }

    public void func_150895_a(Item var1, CreativeTabs var2, List itemList) {
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
        itemList.add(charged);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public int getTier(ItemStack itemstack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        if (nbt.func_74762_e("tier") == 0) {
            nbt.func_74768_a("tier", this.getDefaultTier());
        }
        return nbt.func_74762_e("tier");
    }

    public double getTransferLimit(ItemStack itemstack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        if (nbt.func_74769_h("transferLimit") == 0.0) {
            nbt.func_74780_a("transferLimit", (double)this.getDefaultTransferLimit());
        }
        return nbt.func_74769_h("transferLimit");
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLiving, EntityLivingBase par3EntityLiving) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_150894_a(ItemStack par1ItemStack, World world, Block block, int par4, int par5, int par6, EntityLivingBase par7EntityLiving) {
        return true;
    }

    public ItemStack onFoodEaten(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        ArrowNockEvent event = new ArrowNockEvent(par3EntityPlayer, par1ItemStack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)par1ItemStack);
        if (IC2.keyboard.isModeSwitchKeyDown(par3EntityPlayer) && nbt.func_74771_c("toggleTimer") == 0) {
            if (IC2.platform.isSimulating()) {
                byte toggle = 10;
                nbt.func_74774_a("toggleTimer", toggle);
                int mode = nbt.func_74762_e("bowMode");
                if (++mode == 2 && !IC2CA.rapidFireMode) {
                    ++mode;
                }
                if (mode == 3 && !IC2CA.spreadMode) {
                    ++mode;
                }
                if (mode == 4 && !IC2CA.sniperMode) {
                    ++mode;
                }
                if (mode == 5 && !IC2CA.flameMode) {
                    ++mode;
                }
                if (mode == 6 && !IC2CA.explosiveMode) {
                    ++mode;
                }
                if (mode > 6) {
                    mode -= 6;
                }
                nbt.func_74768_a("bowMode", mode);
                String[] name = new String[]{StatCollector.func_74838_a((String)"info.normal"), StatCollector.func_74838_a((String)"info.rapidfire"), StatCollector.func_74838_a((String)"info.spread"), StatCollector.func_74838_a((String)"info.sniper"), StatCollector.func_74838_a((String)"info.flame"), StatCollector.func_74838_a((String)"info.explosive")};
                IC2.platform.messagePlayer(par3EntityPlayer, String.format(StatCollector.func_74838_a((String)"info.modeenabled"), name[mode - 1]), new Object[0]);
            }
        } else if (par3EntityPlayer.field_71075_bZ.field_75098_d || ElectricItem.manager.canUse(par1ItemStack, 100.0)) {
            par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        }
        return par1ItemStack;
    }

    public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer player, int par4) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)par1ItemStack);
        int mode = nbt.func_74762_e("bowMode");
        int var6 = this.func_77626_a(par1ItemStack) - par4;
        ArrowLooseEvent event = new ArrowLooseEvent(player, par1ItemStack, var6);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        var6 = event.charge;
        if (mode == 4 || mode == 6) {
            var6 /= 2;
        }
        if (mode == 2) {
            var6 *= 4;
        }
        float var7 = (float)var6 / 20.0f;
        if ((double)(var7 = (var7 * var7 + var7 * 2.0f) / 3.0f) < 0.1) {
            return;
        }
        if (var7 > 1.0f) {
            var7 = 1.0f;
        }
        EntityTechArrow var8 = new EntityTechArrow(par2World, (EntityLivingBase)player, var7 * 2.0f);
        EntityTechArrow arrow2 = new EntityTechArrow(par2World, (EntityLivingBase)player, var7 * 2.0f);
        arrow2.func_70107_b(arrow2.field_70165_t, arrow2.field_70163_u + 0.5, arrow2.field_70161_v);
        arrow2.field_70251_a = 2;
        EntityTechArrow arrow3 = new EntityTechArrow(par2World, (EntityLivingBase)player, var7 * 2.0f);
        arrow3.func_70107_b(arrow3.field_70165_t, arrow3.field_70163_u + 0.25, arrow3.field_70161_v);
        arrow3.field_70251_a = 2;
        EntityTechArrow arrow4 = new EntityTechArrow(par2World, (EntityLivingBase)player, var7 * 2.0f);
        arrow4.func_70107_b(arrow4.field_70165_t, arrow4.field_70163_u - 0.25, arrow4.field_70161_v);
        arrow4.field_70251_a = 2;
        EntityTechArrow arrow5 = new EntityTechArrow(par2World, (EntityLivingBase)player, var7 * 2.0f);
        arrow5.func_70107_b(arrow5.field_70165_t, arrow5.field_70163_u - 0.5, arrow5.field_70161_v);
        arrow5.field_70251_a = 2;
        if (var7 == 1.0f) {
            var8.func_70243_d(true);
        }
        int var9 = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)par1ItemStack);
        if (mode == 1 && var8.func_70241_g()) {
            var9 += 3;
        } else if (mode == 4 && var8.func_70241_g()) {
            var9 += 10;
        }
        if (var9 > 0) {
            var8.func_70239_b(var8.func_70242_d() + (double)var9 * 0.5 + 0.5);
        }
        if (IC2CA.nanoBowBoost > 0) {
            var8.func_70239_b(var8.func_70242_d() + (double)IC2CA.nanoBowBoost * 0.5 + 0.5);
        }
        int var10 = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)par1ItemStack);
        if (mode == 1 && var8.func_70241_g()) {
            ++var10;
        } else if (mode == 4 && var8.func_70241_g()) {
            var10 += 5;
        }
        if (var10 > 0) {
            var8.func_70240_a(var10);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)par1ItemStack) > 0) {
            var8.func_70015_d(100);
        }
        if (mode == 5 && var8.func_70241_g()) {
            var8.func_70015_d(2000);
        }
        if (mode == 6 && var8.func_70241_g()) {
            var8.setExplosive(true);
        }
        par2World.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + var7 * 0.5f);
        var8.field_70251_a = 2;
        if (!par2World.field_72995_K) {
            if (mode == 1) {
                ElectricItem.manager.use(par1ItemStack, 100.0, (EntityLivingBase)player);
                par2World.func_72838_d((Entity)var8);
            } else if (mode == 2) {
                ElectricItem.manager.use(par1ItemStack, 50.0, (EntityLivingBase)player);
                par2World.func_72838_d((Entity)var8);
            } else if (mode == 3) {
                ElectricItem.manager.use(par1ItemStack, 250.0, (EntityLivingBase)player);
                par2World.func_72838_d((Entity)var8);
                if (var8.func_70241_g()) {
                    par2World.func_72838_d((Entity)arrow2);
                    par2World.func_72838_d((Entity)arrow3);
                    par2World.func_72838_d((Entity)arrow4);
                    par2World.func_72838_d((Entity)arrow5);
                }
            } else if (mode == 4) {
                ElectricItem.manager.use(par1ItemStack, 250.0, (EntityLivingBase)player);
                par2World.func_72838_d((Entity)var8);
            } else if (mode == 5) {
                ElectricItem.manager.use(par1ItemStack, 100.0, (EntityLivingBase)player);
                par2World.func_72838_d((Entity)var8);
            } else if (mode == 6) {
                ElectricItem.manager.use(par1ItemStack, 250.0, (EntityLivingBase)player);
                par2World.func_72838_d((Entity)var8);
            }
        }
    }

    public void func_77663_a(ItemStack par1ItemStack, World world, Entity entity, int par4, boolean par5) {
        int mode;
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)par1ItemStack);
        byte toggle = nbt.func_74771_c("toggleTimer");
        if (toggle > 0) {
            toggle = (byte)(toggle - 1);
            nbt.func_74774_a("toggleTimer", toggle);
        }
        if ((mode = nbt.func_74762_e("bowMode")) == 0) {
            nbt.func_74768_a("bowMode", 1);
        }
    }

    public void onUsingTick(ItemStack itemstack, EntityPlayer player, int i) {
        int j;
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        int mode = nbt.func_74762_e("bowMode");
        if (mode == 2 && (j = this.func_77626_a(itemstack) - i) >= 5 && ElectricItem.manager.canUse(itemstack, 50.0)) {
            player.func_71034_by();
        }
    }

    public void func_94581_a(IIconRegister ir) {
        this.icons[0] = Util.register(ir, this);
        this.icons[1] = Util.register(ir, Util.getFileName(this) + "_1");
        this.icons[2] = Util.register(ir, Util.getFileName(this) + "_2");
        this.icons[3] = Util.register(ir, Util.getFileName(this) + "_3");
        this.field_77791_bV = this.icons[0];
    }
}

