/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.tile.IWrenchable;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityBlock;
import ic2ca.common.IC2CA;
import ic2ca.common.Util;
import ic2ca.common.tileentity.TileEntityArmorAssembler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockArmorAssembler
extends BlockContainer {
    private IIcon top;
    private IIcon bottom;
    private IIcon side;
    private IIcon front;
    public boolean isActive;

    public BlockArmorAssembler(boolean active) {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(IC2CA.tabIC2CA);
        this.func_149663_c("armorAssembler");
        this.isActive = active;
        GameRegistry.registerBlock((Block)this, (String)"ArmorAssemblerBlock");
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockId, int meta) {
        this.dropItems(world, x, y, z);
        super.func_149749_a(world, x, y, z, blockId, meta);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityArmorAssembler();
    }

    public int func_149692_a(int i) {
        return Ic2Items.advancedMachine.func_77960_j();
    }

    private void dropItems(World world, int x, int y, int z) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess iBlockAccess, int x, int y, int z, int side) {
        if (side == 1) {
            return this.top;
        }
        if (side == 0) {
            return this.bottom;
        }
        int facing = this.getFacing(iBlockAccess, x, y, z);
        if (side != facing) {
            return this.side;
        }
        return this.front;
    }

    public int getFacing(IBlockAccess iBlockAccess, int x, int y, int z) {
        TileEntity te = iBlockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getFacing();
        }
        return 0;
    }

    public IIcon func_149691_a(int i, int meta) {
        if (i == 0) {
            return this.bottom;
        }
        if (i == 1) {
            return this.top;
        }
        if (i == 3) {
            return this.front;
        }
        return this.side;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int idk, float what, float these, float are) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        ItemStack item = player.field_71071_by.func_70448_g();
        if (tileEntity == null || player.func_70093_af()) {
            return false;
        }
        if (item != null && (Item.func_150891_b((Item)item.func_77973_b()) == Item.func_150891_b((Item)Ic2Items.wrench.func_77973_b()) || Item.func_150891_b((Item)item.func_77973_b()) == Item.func_150891_b((Item)Ic2Items.electricWrench.func_77973_b()))) {
            return false;
        }
        player.openGui((Object)IC2CA.instance, 0, world, x, y, z);
        return true;
    }

    public void func_149726_b(World par1World, int x, int y, int z) {
        super.func_149726_b(par1World, x, y, z);
        this.setDefaultDirection(par1World, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack is) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IWrenchable) {
            IWrenchable te = (IWrenchable)tileEntity;
            if (entityliving == null) {
                te.setFacing((short)2);
            } else {
                int l = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                switch (l) {
                    case 0: {
                        te.setFacing((short)2);
                        break;
                    }
                    case 1: {
                        te.setFacing((short)5);
                        break;
                    }
                    case 2: {
                        te.setFacing((short)3);
                        break;
                    }
                    case 3: {
                        te.setFacing((short)4);
                    }
                }
            }
        }
    }

    public void func_149651_a(IIconRegister ir) {
        IIcon[] icons = Util.registerSides(ir, (Block)this);
        this.top = icons[0];
        this.bottom = icons[1];
        this.side = icons[2];
        this.front = icons[3];
    }

    private void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            world.func_72921_c(x, y, z, 3, 2);
        }
    }
}

