/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.server.FMLServerHandler;
import ic2.api.recipe.Recipes;
import ic2.core.Ic2Items;
import ic2.core.util.StackUtil;
import ic2ca.common.ArmorAssemblerRecipes;
import ic2ca.common.IC2CA;
import ic2ca.common.Ic2caItems;
import ic2ca.common.RecipeHandler;
import ic2ca.common.item.EnumUpgradeType;
import ic2ca.common.item.ItemUpgrade;
import java.io.File;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;

public class ModIntegrationHandler {
    public static final int COMPACT_SOLARS = 0;
    public static final int ADVANCED_SOLAR_PANELS = 1;
    public static final int GRAVISUITE = 2;
    public static final int GREGTECH = 3;
    private static final String[] modids = new String[]{"CompactSolars", "AdvancedSolarPanel"};
    private static boolean[] loaded = new boolean[]{false, false, false, false};
    private static boolean[] integrateEnabled = new boolean[]{true, true, true, true};

    public static Configuration getConfig(String dir) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return new Configuration(new File(Loader.instance().getConfigDir() + "/config/" + dir));
        }
        return new Configuration(FMLServerHandler.instance().getServer().func_71209_f("/config/" + dir));
    }

    private static void integrateAdvancedSolars() {
        Ic2caItems.asp = new ItemStack(GameRegistry.findBlock((String)modids[1], (String)"BlockAdvSolarPanel"), 1, 0);
        Ic2caItems.hybridsp = new ItemStack(GameRegistry.findBlock((String)modids[1], (String)"BlockAdvSolarPanel"), 1, 1);
        Ic2caItems.ulthybsp = new ItemStack(GameRegistry.findBlock((String)modids[1], (String)"BlockAdvSolarPanel"), 1, 2);
        Ic2caItems.ash = new ItemStack(GameRegistry.findItem((String)modids[1], (String)"advanced_solar_helmet"));
        Ic2caItems.hsh = new ItemStack(GameRegistry.findItem((String)modids[1], (String)"hybrid_solar_helmet"));
        Ic2caItems.uhsh = new ItemStack(GameRegistry.findItem((String)modids[1], (String)"ultimate_solar_helmet"));
        if (!loaded[0]) {
            Ic2caItems.lvSolarModule = new ItemStack((Item)new ItemUpgrade("lvSolarModule", 64, 1, EnumUpgradeType.SOLARS));
            Ic2caItems.mvSolarModule = new ItemStack((Item)new ItemUpgrade("mvSolarModule", 64, 1, EnumUpgradeType.SOLARS));
            Ic2caItems.hvSolarModule = new ItemStack((Item)new ItemUpgrade("hvSolarModule", 64, 1, EnumUpgradeType.SOLARS));
            RecipeHandler.instance().addSolarRecipes(Ic2caItems.lvSolarModule);
            RecipeHandler.instance().addSolarRecipes(Ic2caItems.mvSolarModule);
            RecipeHandler.instance().addSolarRecipes(Ic2caItems.hvSolarModule);
        }
        ItemStack advanced = new ItemStack(Ic2caItems.solarNanoHelm.func_77973_b(), 1);
        NBTTagCompound nbtadv = StackUtil.getOrCreateNbtData((ItemStack)advanced);
        nbtadv.func_74768_a("solarProd", 7);
        ItemStack hybrid = new ItemStack(Ic2caItems.solarQuantumHelm.func_77973_b(), 1);
        NBTTagCompound nbthyb = StackUtil.getOrCreateNbtData((ItemStack)hybrid);
        nbthyb.func_74768_a("solarProd", 63);
        nbthyb.func_74768_a("upgradedTransfer", 4000);
        nbthyb.func_74768_a("transferLimit", 5000);
        ItemStack ultimate = new ItemStack(Ic2caItems.solarQuantumHelm.func_77973_b(), 1);
        NBTTagCompound nbtult = StackUtil.getOrCreateNbtData((ItemStack)ultimate);
        nbtult.func_74768_a("solarProd", 511);
        nbtult.func_74768_a("upgradedTransfer", 4000);
        nbtult.func_74768_a("transferLimit", 5000);
        ArmorAssemblerRecipes.addAssemblyRecipe(advanced, Ic2caItems.ash, Ic2caItems.exoModule);
        ArmorAssemblerRecipes.addAssemblyRecipe(hybrid, Ic2caItems.hsh, Ic2caItems.exoModule);
        ArmorAssemblerRecipes.addAssemblyRecipe(ultimate, Ic2caItems.uhsh, Ic2caItems.exoModule);
        Recipes.advRecipes.addRecipe(Ic2caItems.lvSolarModule, new Object[]{"RRR", "CSC", "RRR", Character.valueOf('R'), "plateIron", Character.valueOf('C'), Ic2Items.insulatedCopperCableItem, Character.valueOf('S'), Ic2caItems.asp});
        Recipes.advRecipes.addRecipe(Ic2caItems.mvSolarModule, new Object[]{"RRR", "CSC", "RRR", Character.valueOf('R'), "plateIron", Character.valueOf('C'), Ic2Items.insulatedGoldCableItem, Character.valueOf('S'), Ic2caItems.hybridsp});
        Recipes.advRecipes.addRecipe(Ic2caItems.hvSolarModule, new Object[]{"RRR", "CSC", "RRR", Character.valueOf('R'), "plateIron", Character.valueOf('C'), Ic2Items.glassFiberCableItem, Character.valueOf('S'), Ic2caItems.ulthybsp});
    }

    private static void integrateCompactSolars() {
        Ic2caItems.lvHat = new ItemStack(GameRegistry.findItem((String)modids[0], (String)"solarHatLV"));
        Ic2caItems.mvHat = new ItemStack(GameRegistry.findItem((String)modids[0], (String)"solarHatMV"));
        Ic2caItems.hvHat = new ItemStack(GameRegistry.findItem((String)modids[0], (String)"solarHatHV"));
        IC2CA.solars.add(Ic2caItems.lvHat.func_77977_a());
        IC2CA.solars.add(Ic2caItems.mvHat.func_77977_a());
        IC2CA.solars.add(Ic2caItems.hvHat.func_77977_a());
        Ic2caItems.lvArray = new ItemStack(GameRegistry.findBlock((String)modids[0], (String)"CompactSolarBlock"), 1, 0);
        Ic2caItems.mvArray = new ItemStack(GameRegistry.findBlock((String)modids[0], (String)"CompactSolarBlock"), 1, 1);
        Ic2caItems.hvArray = new ItemStack(GameRegistry.findBlock((String)modids[0], (String)"CompactSolarBlock"), 1, 2);
        ArmorAssemblerRecipes.addAssemblyRecipe(Ic2caItems.solarNanoHelm, Ic2caItems.exoNanoHelm, Ic2caItems.lvHat);
        ArmorAssemblerRecipes.addAssemblyRecipe(Ic2caItems.solarNanoHelm, Ic2caItems.exoNanoHelm, Ic2caItems.mvHat);
        ArmorAssemblerRecipes.addAssemblyRecipe(Ic2caItems.solarNanoHelm, Ic2caItems.exoNanoHelm, Ic2caItems.hvHat);
        ArmorAssemblerRecipes.addAssemblyRecipe(Ic2caItems.solarQuantumHelm, Ic2caItems.exoQuantumHelm, Ic2caItems.lvHat);
        ArmorAssemblerRecipes.addAssemblyRecipe(Ic2caItems.solarQuantumHelm, Ic2caItems.exoQuantumHelm, Ic2caItems.mvHat);
        ArmorAssemblerRecipes.addAssemblyRecipe(Ic2caItems.solarQuantumHelm, Ic2caItems.exoQuantumHelm, Ic2caItems.hvHat);
        Ic2caItems.lvSolarModule = new ItemStack((Item)new ItemUpgrade("lvSolarModule", 64, 1, EnumUpgradeType.SOLARS));
        Ic2caItems.mvSolarModule = new ItemStack((Item)new ItemUpgrade("mvSolarModule", 64, 1, EnumUpgradeType.SOLARS));
        Ic2caItems.hvSolarModule = new ItemStack((Item)new ItemUpgrade("hvSolarModule", 64, 1, EnumUpgradeType.SOLARS));
        RecipeHandler.instance().addSolarRecipes(Ic2caItems.lvSolarModule);
        RecipeHandler.instance().addSolarRecipes(Ic2caItems.mvSolarModule);
        RecipeHandler.instance().addSolarRecipes(Ic2caItems.hvSolarModule);
        Recipes.advRecipes.addRecipe(Ic2caItems.lvSolarModule, new Object[]{"RRR", "CSC", "RRR", Character.valueOf('R'), "plateIron", Character.valueOf('C'), Ic2Items.insulatedCopperCableItem, Character.valueOf('S'), Ic2caItems.lvArray});
        Recipes.advRecipes.addRecipe(Ic2caItems.mvSolarModule, new Object[]{"RRR", "CSC", "RRR", Character.valueOf('R'), "plateIron", Character.valueOf('C'), Ic2Items.insulatedGoldCableItem, Character.valueOf('S'), Ic2caItems.mvArray});
        Recipes.advRecipes.addRecipe(Ic2caItems.hvSolarModule, new Object[]{"RRR", "CSC", "RRR", Character.valueOf('R'), "plateIron", Character.valueOf('C'), Ic2Items.glassFiberCableItem, Character.valueOf('S'), Ic2caItems.hvArray});
    }

    public static void integrateMod(int i) {
        switch (i) {
            case 0: {
                ModIntegrationHandler.integrateCompactSolars();
                break;
            }
            case 1: {
                ModIntegrationHandler.integrateAdvancedSolars();
            }
        }
    }

    public static boolean isModLoaded(int i) {
        return loaded[i];
    }

    public static void loadIntegrationModules() {
        IC2CA.ic2caLog.info("Loading Cross-Mod Integration Modules");
        int l = modids.length;
        for (int i = 0; i < l; ++i) {
            String modid = modids[i];
            if (!integrateEnabled[i]) {
                IC2CA.ic2caLog.info("Integration of " + modid + " has been disabled in the configs. Skipping.");
                continue;
            }
            if (Loader.isModLoaded((String)modid)) {
                ModIntegrationHandler.integrateMod(i);
                ModIntegrationHandler.loaded[i] = true;
                IC2CA.ic2caLog.info("Successfully loaded integration for " + modid + ".");
                continue;
            }
            IC2CA.ic2caLog.info("Failed to load integration for " + modid + ".");
        }
    }

    public static void setIntegrationEnabled(int i, boolean b) {
        ModIntegrationHandler.integrateEnabled[i] = b;
    }
}

