/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import ic2.core.IC2;
import ic2.core.util.StackUtil;
import ic2ca.common.IC2CA;
import ic2ca.common.UpgradesCommonProxy;
import ic2ca.common.item.armor.ItemArmorExoQuantum;
import ic2ca.common.network.IC2CAChannelHandler;
import ic2ca.common.network.message.PacketSwitchCloakMode;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.world.WorldEvent;

public class IC2CAServerTickHandler {
    public static final IC2CAServerTickHandler instance = new IC2CAServerTickHandler();
    public static Map isFlyActiveByMod = new HashMap();
    public static Map<EntityPlayer, Boolean> isCloakActiveByMod = new HashMap<EntityPlayer, Boolean>();
    public static Map lastFlyUndressed = new HashMap();
    public static Map lastCloakUndressed = new HashMap();
    public static Map isLastCreativeState = new HashMap();
    public static Map helmetStored = new HashMap();
    public static Map pantsStored = new HashMap();
    public static Map bootsStored = new HashMap();
    public static Map chestStored = new HashMap();

    public static boolean checkCloakActiveByMode(EntityPlayer player) {
        return isCloakActiveByMod.containsKey(player) ? isCloakActiveByMod.get(player) : false;
    }

    public static boolean checkFlyActiveByMode(EntityPlayer player) {
        return isFlyActiveByMod.containsKey(player) ? (Boolean)isFlyActiveByMod.get(player) : false;
    }

    public static boolean checkLastCloakUndressed(EntityPlayer player) {
        return lastCloakUndressed.containsKey(player) ? (Boolean)lastCloakUndressed.get(player) : false;
    }

    public static boolean checkLastCreativeState(EntityPlayer player) {
        return isLastCreativeState.containsKey(player) ? (Boolean)isLastCreativeState.get(player) : false;
    }

    public static boolean checkLastFlyUndressed(EntityPlayer player) {
        return lastFlyUndressed.containsKey(player) ? (Boolean)lastFlyUndressed.get(player) : false;
    }

    public static NBTTagCompound getBootsStored(EntityPlayer player) {
        return bootsStored.containsKey(player) ? (NBTTagCompound)bootsStored.get(player) : null;
    }

    public static NBTTagCompound getChestStored(EntityPlayer player) {
        return chestStored.containsKey(player) ? (NBTTagCompound)chestStored.get(player) : null;
    }

    public static NBTTagCompound getHelmetStored(EntityPlayer player) {
        return helmetStored.containsKey(player) ? (NBTTagCompound)helmetStored.get(player) : null;
    }

    public static NBTTagCompound getPantsStored(EntityPlayer player) {
        return pantsStored.containsKey(player) ? (NBTTagCompound)pantsStored.get(player) : null;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Side cfr_ignored_0 = event.side;
            if (event.side == Side.SERVER && event.player instanceof EntityPlayer) {
                EntityPlayer player = event.player;
                ItemStack armor = player.field_71071_by.field_70460_b[2];
                NBTTagCompound chestnbt = IC2CAServerTickHandler.getChestStored(player);
                if (armor != null && IC2CA.chests.contains(armor.func_77977_a())) {
                    NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)armor);
                    if (nbt.func_74767_n("cloaking")) {
                        UpgradesCommonProxy.onCloakTickServer(player, armor, 0.0f, 0.0f);
                    }
                } else if (chestnbt != null && chestnbt.func_74767_n("has")) {
                    NBTTagCompound nbt;
                    int id = chestnbt.func_74762_e("id");
                    int damage = chestnbt.func_74762_e("damage");
                    int size = chestnbt.func_74762_e("size");
                    ItemStack is = new ItemStack(Item.func_150899_d((int)id), size, damage);
                    if (chestnbt.func_74775_l("nbt") != null) {
                        nbt = chestnbt.func_74775_l("nbt");
                        is.func_77982_d(nbt);
                    }
                    if (is != null && IC2CA.chests.contains(is.func_77977_a())) {
                        nbt = StackUtil.getOrCreateNbtData((ItemStack)is);
                        if (nbt.func_74767_n("cloaking")) {
                            UpgradesCommonProxy.onCloakTickServer(player, is, 0.0f, 0.0f);
                        }
                    } else if (IC2CAServerTickHandler.checkCloakActiveByMode(player)) {
                        player.func_82142_c(false);
                        isCloakActiveByMod.put(player, false);
                        lastCloakUndressed.put(player, true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (IC2.platform.isSimulating()) {
            ItemArmorExoQuantum.removePlayerReferences(event.player);
            this.DisableCloak((EntityPlayerMP)event.player);
        }
    }

    public void DisableCloak(EntityPlayerMP entityPlayer) {
        NBTTagCompound chestnbt = IC2CAServerTickHandler.getChestStored((EntityPlayer)entityPlayer);
        if (chestnbt != null && chestnbt.func_74767_n("has")) {
            NBTTagCompound nbt;
            int id = chestnbt.func_74762_e("id");
            int damage = chestnbt.func_74762_e("damage");
            int size = chestnbt.func_74762_e("size");
            ItemStack is = new ItemStack(Item.func_150899_d((int)id), size, damage);
            if (chestnbt.func_74775_l("nbt") != null) {
                nbt = chestnbt.func_74775_l("nbt");
                is.func_77982_d(nbt);
            }
            if (is != null && IC2CA.chests.contains(is.func_77977_a()) && (nbt = StackUtil.getOrCreateNbtData((ItemStack)is)).func_74767_n("cloaking")) {
                IC2CAChannelHandler.network.sendTo((IMessage)new PacketSwitchCloakMode(UpgradesCommonProxy.switchCloakModeServer((EntityPlayer)entityPlayer, is)), entityPlayer);
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        for (Map.Entry<EntityPlayer, Boolean> entry : isCloakActiveByMod.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            this.DisableCloak((EntityPlayerMP)entry.getKey());
        }
    }
}

