/*
 * Decompiled with CFR 0.152.
 */
package ic2ca.common;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeOutput;
import ic2ca.api.IArmorAssemblerRecipeManager;
import ic2ca.common.IC2CA;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ArmorAssemblerRecipes
implements IArmorAssemblerRecipeManager {
    private static final ArmorAssemblerRecipes assemblyCore = new ArmorAssemblerRecipes();
    private final Map<IArmorAssemblerRecipeManager.Input, RecipeOutput> recipes = new HashMap<IArmorAssemblerRecipeManager.Input, RecipeOutput>();
    private static List<Item> items = new ArrayList<Item>();

    public static void addAssemblyRecipe(ItemStack result, ItemStack i1, ItemStack i2) {
        assemblyCore.addRecipe(result, (IRecipeInput)new RecipeInputItemStack(i1, 1), (IRecipeInput)new RecipeInputItemStack(i2, 1));
        items.add(i1.func_77973_b());
        items.add(i2.func_77973_b());
    }

    @Override
    public void addRecipe(ItemStack result, IRecipeInput i1, IRecipeInput i2) {
        if (result == null) {
            throw new NullPointerException("The recipe output is null");
        }
        if (i1 == null) {
            throw new NullPointerException("The I1 recipe input is null");
        }
        if (i2 == null) {
            throw new NullPointerException("The I2 recipe input is null");
        }
        InventoryBasic inv = new InventoryBasic(null, false, 2);
        ItemStack output = result.func_77946_l();
        inv.func_70299_a(0, (ItemStack)i1.getInputs().get(0));
        inv.func_70299_a(1, (ItemStack)i2.getInputs().get(0));
        IC2CA.instance.onCrafting(null, output, (IInventory)inv);
        this.recipes.put(new IArmorAssemblerRecipeManager.Input(i1, i2), new RecipeOutput(null, new ItemStack[]{output}));
        this.recipes.put(new IArmorAssemblerRecipeManager.Input(i2, i1), new RecipeOutput(null, new ItemStack[]{output}));
    }

    public static final ArmorAssemblerRecipes assembly() {
        return assemblyCore;
    }

    public static Item[] getItemList() {
        return items.toArray(new Item[items.size()]);
    }

    @Override
    public RecipeOutput getAssemblyResult(ItemStack item1, ItemStack item2) {
        if (item1 == null || item2 == null) {
            return null;
        }
        for (Map.Entry<IArmorAssemblerRecipeManager.Input, RecipeOutput> entry : this.recipes.entrySet()) {
            IArmorAssemblerRecipeManager.Input recipeInput = entry.getKey();
            if (!recipeInput.matches(item1, item2)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Map<IArmorAssemblerRecipeManager.Input, RecipeOutput> getRecipes() {
        return this.recipes;
    }
}

