/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import buildcraft.api.transport.PipeWire;
import buildcraft.transport.utils.BitSetCodec;
import buildcraft.transport.utils.ConnectionMatrix;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import net.minecraftforge.common.util.ForgeDirection;

public class WireMatrix {
    private final BitSet hasWire = new BitSet(PipeWire.values().length);
    private final BitSetCodec bitSetCodec = new BitSetCodec();
    private final ConnectionMatrix[] wires = new ConnectionMatrix[PipeWire.values().length];
    private final int[] wireIconIndex = new int[PipeWire.values().length];
    private boolean dirty = false;

    public WireMatrix() {
        for (int i = 0; i < PipeWire.values().length; ++i) {
            this.wires[i] = new ConnectionMatrix();
        }
    }

    public boolean hasWire(PipeWire color) {
        return this.hasWire.get(color.ordinal());
    }

    public void setWire(PipeWire color, boolean value) {
        if (this.hasWire.get(color.ordinal()) != value) {
            this.hasWire.set(color.ordinal(), value);
            this.dirty = true;
        }
    }

    public boolean isWireConnected(PipeWire color, ForgeDirection direction) {
        return this.wires[color.ordinal()].isConnected(direction);
    }

    public void setWireConnected(PipeWire color, ForgeDirection direction, boolean value) {
        this.wires[color.ordinal()].setConnected(direction, value);
    }

    public int getWireIconIndex(PipeWire color) {
        return this.wireIconIndex[color.ordinal()];
    }

    public void setWireIndex(PipeWire color, int value) {
        if (this.wireIconIndex[color.ordinal()] != value) {
            this.wireIconIndex[color.ordinal()] = value;
            this.dirty = true;
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < PipeWire.values().length; ++i) {
            if (!this.wires[i].isDirty()) continue;
            return true;
        }
        return this.dirty;
    }

    public void clean() {
        for (int i = 0; i < PipeWire.values().length; ++i) {
            this.wires[i].clean();
        }
        this.dirty = false;
    }

    public void writeData(ByteBuf data) {
        data.writeByte((int)this.bitSetCodec.encode(this.hasWire));
        for (int i = 0; i < PipeWire.values().length; ++i) {
            this.wires[i].writeData(data);
            data.writeByte(this.wireIconIndex[i]);
        }
    }

    public void readData(ByteBuf data) {
        this.bitSetCodec.decode(data.readByte(), this.hasWire);
        for (int i = 0; i < PipeWire.values().length; ++i) {
            this.wires[i].readData(data);
            this.wireIconIndex[i] = data.readUnsignedByte();
        }
    }
}

