/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.events.BQLivingUpdateEvent;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.events.QuestEvent;
import betterquesting.api.placeholders.FluidPlaceholder;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.GuiScreenTest;
import betterquesting.api2.client.gui.themes.gui_args.GArgsNone;
import betterquesting.api2.client.gui.themes.presets.PresetGUIs;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.BQ_Keybindings;
import betterquesting.client.gui2.GuiHome;
import betterquesting.client.themes.ThemeRegistry;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.ConfigHandler;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.handlers.NetBulkSync;
import betterquesting.network.handlers.NetNameSync;
import betterquesting.network.handlers.NetNotices;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.party.PartyInvitations;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.UserListBansEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang3.Validate;

public class EventHandler {
    public static final EventHandler INSTANCE = new EventHandler();
    private final ArrayDeque<EntityPlayerMP> opQueue = new ArrayDeque();
    private boolean openToLAN = false;
    private static final ArrayDeque<FutureTask> serverTasks = new ArrayDeque();
    private static Thread serverThread = null;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKey(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (BQ_Keybindings.openQuests.func_151468_f()) {
            if (mc.field_71439_g.func_70093_af() && mc.field_71439_g.func_70005_c_().equalsIgnoreCase("Funwayguy")) {
                mc.func_147108_a((GuiScreen)new GuiScreenTest(mc.field_71462_r));
            } else if (BQ_Settings.useBookmark && GuiHome.bookmark != null) {
                mc.func_147108_a(GuiHome.bookmark);
            } else {
                mc.func_147108_a(ThemeRegistry.INSTANCE.getGui(PresetGUIs.HOME, GArgsNone.NONE));
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer && event.entity.getExtendedProperties(QuestCache.LOC_QUEST_CACHE.toString()) == null) {
            event.entity.registerExtendedProperties(QuestCache.LOC_QUEST_CACHE.toString(), (IExtendedEntityProperties)new QuestCache());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        QuestCache oCache = (QuestCache)event.original.getExtendedProperties(QuestCache.LOC_QUEST_CACHE.toString());
        QuestCache nCache = (QuestCache)event.entityPlayer.getExtendedProperties(QuestCache.LOC_QUEST_CACHE.toString());
        if (oCache != null && nCache != null) {
            NBTTagCompound tmp = new NBTTagCompound();
            oCache.saveNBTData(tmp);
            nCache.loadNBTData(tmp);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(BQLivingUpdateEvent event) {
        if (event.entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.entityLiving instanceof EntityPlayerMP)) {
            return;
        }
        if (event.entityLiving.field_70173_aa % 20 != 0) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.entityLiving;
        QuestCache qc = (QuestCache)player.getExtendedProperties(QuestCache.LOC_QUEST_CACHE.toString());
        boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
        if (qc == null) {
            return;
        }
        List activeQuests = QuestDatabase.INSTANCE.bulkLookup(qc.getActiveQuests());
        List pendingAutoClaims = QuestDatabase.INSTANCE.bulkLookup(qc.getPendingAutoClaims());
        QuestCache.QResetTime[] pendingResets = qc.getScheduledResets();
        UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        boolean refreshCache = false;
        if (!editMode && player.field_70173_aa % 60 == 0) {
            ArrayList<Integer> com = new ArrayList<Integer>();
            for (DBEntry quest : activeQuests) {
                if (!((IQuest)quest.getValue()).isUnlocked(uuid)) continue;
                if (((IQuest)quest.getValue()).canSubmit((EntityPlayer)player)) {
                    ((IQuest)quest.getValue()).update((EntityPlayer)player);
                }
                if (!((IQuest)quest.getValue()).isComplete(uuid) || ((IQuest)quest.getValue()).canSubmit((EntityPlayer)player)) continue;
                refreshCache = true;
                qc.markQuestDirty(quest.getID());
                com.add(quest.getID());
                if (((IQuest)quest.getValue()).getProperty(NativeProps.SILENT).booleanValue()) continue;
                EventHandler.postPresetNotice((IQuest)quest.getValue(), (EntityPlayer)player, 2);
            }
            MinecraftForge.EVENT_BUS.post((Event)new QuestEvent(QuestEvent.Type.COMPLETED, uuid, com));
        }
        if (!editMode && MinecraftServer.func_71276_C() != null) {
            ArrayList<Integer> res = new ArrayList<Integer>();
            long totalTime = System.currentTimeMillis();
            for (QuestCache.QResetTime rTime : pendingResets) {
                IQuest entry = (IQuest)QuestDatabase.INSTANCE.getValue(rTime.questID);
                if (totalTime < rTime.time || entry.canSubmit((EntityPlayer)player)) break;
                if (entry.getProperty(NativeProps.GLOBAL).booleanValue()) {
                    entry.resetUser(null, false);
                } else {
                    entry.resetUser(uuid, false);
                }
                refreshCache = true;
                qc.markQuestDirty(rTime.questID);
                res.add(rTime.questID);
                if (entry.getProperty(NativeProps.SILENT).booleanValue()) continue;
                EventHandler.postPresetNotice(entry, (EntityPlayer)player, 1);
            }
            MinecraftForge.EVENT_BUS.post((Event)new QuestEvent(QuestEvent.Type.RESET, uuid, res));
        }
        if (!editMode) {
            for (DBEntry entry : pendingAutoClaims) {
                if (!((IQuest)entry.getValue()).canClaim((EntityPlayer)player)) continue;
                ((IQuest)entry.getValue()).claimReward((EntityPlayer)player);
                refreshCache = true;
                qc.markQuestDirty(entry.getID());
            }
        }
        if (refreshCache || player.field_70173_aa % 200 == 0) {
            qc.updateCache((EntityPlayer)player);
        }
        if (qc.getDirtyQuests().length > 0) {
            NetQuestSync.sendSync(player, qc.getDirtyQuests(), false, true);
        }
        qc.cleanAllQuests();
    }

    private static void postPresetNotice(IQuest quest, EntityPlayer player, int preset) {
        EntityPlayerMP[] entityPlayerMPArray;
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        ItemStack icon = quest.getProperty(NativeProps.ICON).getBaseStack();
        String mainText = "";
        String subText = quest.getProperty(NativeProps.NAME);
        String sound = "";
        switch (preset) {
            case 0: {
                mainText = "betterquesting.notice.unlock";
                sound = quest.getProperty(NativeProps.SOUND_UNLOCK);
                break;
            }
            case 1: {
                mainText = "betterquesting.notice.update";
                sound = quest.getProperty(NativeProps.SOUND_UPDATE);
                break;
            }
            case 2: {
                mainText = "betterquesting.notice.complete";
                sound = quest.getProperty(NativeProps.SOUND_COMPLETE);
            }
        }
        if (quest.getProperty(NativeProps.GLOBAL).booleanValue()) {
            entityPlayerMPArray = null;
        } else {
            EntityPlayerMP[] entityPlayerMPArray2 = new EntityPlayerMP[1];
            entityPlayerMPArray = entityPlayerMPArray2;
            entityPlayerMPArray2[0] = (EntityPlayerMP)player;
        }
        NetNotices.sendNotice(entityPlayerMPArray, icon, mainText, subText, sound);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("betterquesting")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.world.field_72995_K && BQ_Settings.curWorldDir != null && event.world.field_73011_w.field_76574_g == 0) {
            SaveLoadHandler.INSTANCE.saveDatabases();
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_70170_p.field_72995_K || MinecraftServer.func_71276_C() == null || !(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP mpPlayer = (EntityPlayerMP)event.player;
        if (BetterQuesting.proxy.isClient() && !MinecraftServer.func_71276_C().func_71262_S() && MinecraftServer.func_71276_C().func_71214_G().equals(event.player.func_146103_bH().getName())) {
            NameCache.INSTANCE.updateName(mpPlayer);
            return;
        }
        NetBulkSync.sendReset(mpPlayer, true, true);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE).booleanValue() && event.player instanceof EntityPlayerMP && !((EntityPlayerMP)event.player).field_71136_j) {
            EntityPlayerMP mpPlayer = (EntityPlayerMP)event.player;
            int lives = LifeDatabase.INSTANCE.getLives(QuestingAPI.getQuestingUUID((EntityPlayer)mpPlayer));
            if (lives <= 0) {
                MinecraftServer server = MinecraftServer.func_71276_C();
                if (server == null) {
                    return;
                }
                if (server.func_71264_H() && mpPlayer.func_70005_c_().equals(server.func_71214_G())) {
                    mpPlayer.field_71135_a.func_147360_c("You have died. Game over, man, it's game over!");
                    server.func_71272_O();
                } else {
                    UserListBansEntry userlistbansentry = new UserListBansEntry(mpPlayer.func_146103_bH(), null, "(You just lost the game)", null, "Death in Hardcore");
                    server.func_71203_ab().func_152608_h().func_152687_a((UserListEntry)userlistbansentry);
                    mpPlayer.field_71135_a.func_147360_c("You have died. Game over, man, it's game over!");
                }
            } else if (lives == 1) {
                mpPlayer.func_146105_b((IChatComponent)new ChatComponentText("This is your last life!"));
            } else {
                mpPlayer.func_146105_b((IChatComponent)new ChatComponentText(lives + " lives remaining!"));
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.entityLiving.field_70170_p.field_72995_K || !QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE).booleanValue()) {
            return;
        }
        if (event.entityLiving instanceof EntityPlayer) {
            UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)event.entityLiving);
            int lives = LifeDatabase.INSTANCE.getLives(uuid);
            LifeDatabase.INSTANCE.setLives(uuid, lives - 1);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            IIcon icon = event.map.func_94245_a("betterquesting:fluid_placeholder");
            FluidPlaceholder.fluidPlaceholder.setIcons(icon);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDataUpdated(DatabaseEvent.Update event) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof INeedsRefresh) {
            Minecraft.func_71410_x().func_152343_a(Executors.callable(((INeedsRefresh)screen)::refreshGui));
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        EntityPlayerMP playerMP;
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server != null && (event.command.func_71517_b().equalsIgnoreCase("op") || event.command.func_71517_b().equalsIgnoreCase("deop")) && (playerMP = server.func_71203_ab().func_152612_a(event.parameters[0])) != null) {
            this.opQueue.add(playerMP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ListenableFuture<T> scheduleServerTask(Callable<T> task) {
        Validate.notNull(task);
        if (Thread.currentThread() != serverThread) {
            ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(task);
            ArrayDeque<FutureTask> arrayDeque = serverTasks;
            synchronized (arrayDeque) {
                serverTasks.add((FutureTask)listenablefuturetask);
                return listenablefuturetask;
            }
        }
        try {
            return Futures.immediateFuture(task.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (serverThread == null) {
                serverThread = Thread.currentThread();
            }
            ArrayDeque<FutureTask> arrayDeque = serverTasks;
            synchronized (arrayDeque) {
                while (!serverTasks.isEmpty()) {
                    serverTasks.poll().run();
                }
            }
            return;
        }
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (!server.func_71262_S()) {
            boolean tmp = this.openToLAN;
            boolean bl = this.openToLAN = server instanceof IntegratedServer && ((IntegratedServer)server).func_71344_c();
            if (this.openToLAN && !tmp) {
                this.opQueue.addAll(server.func_71203_ab().field_72404_b);
            }
        } else if (!this.openToLAN) {
            this.openToLAN = true;
        }
        while (!this.opQueue.isEmpty()) {
            EntityPlayerMP playerMP = this.opQueue.poll();
            if (playerMP == null || !NameCache.INSTANCE.updateName(playerMP)) continue;
            DBEntry<IParty> party = PartyManager.INSTANCE.getParty(QuestingAPI.getQuestingUUID((EntityPlayer)playerMP));
            if (party != null) {
                NetNameSync.quickSync(null, party.getID());
                continue;
            }
            NetNameSync.sendNames(new EntityPlayerMP[]{playerMP}, new UUID[]{QuestingAPI.getQuestingUUID((EntityPlayer)playerMP)}, null);
        }
        if (server.func_71259_af() % 60 == 0) {
            PartyInvitations.INSTANCE.cleanExpired();
        }
        for (EntityPlayerMP player : server.func_71203_ab().field_72404_b) {
            MinecraftForge.EVENT_BUS.post((Event)new BQLivingUpdateEvent(player));
        }
    }
}

