/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.utils;

import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.core.BetterQuesting;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    public static final String REGEX_NUMBER = "[^\\.0123456789-]";
    public static final RenderItem itemRender = new RenderItem();
    private static final Stack<IGuiRect> scissorStack = new Stack();

    public static void RenderItemStack(Minecraft mc, ItemStack stack, int x, int y, String text) {
        RenderUtils.RenderItemStack(mc, stack, x, y, 16.0f, text, -1);
    }

    public static void RenderItemStack(Minecraft mc, ItemStack stack, int x, int y, String text, Color color) {
        RenderUtils.RenderItemStack(mc, stack, x, y, 16.0f, text, color.getRGB());
    }

    public static void RenderItemStack(Minecraft mc, ItemStack stack, int x, int y, String text, int color) {
        RenderUtils.RenderItemStack(mc, stack, x, y, 16.0f, text, color);
    }

    public static void RenderItemStack(Minecraft mc, ItemStack stack, int x, int y, float z, String text, int color) {
        if (stack == null) {
            return;
        }
        GL11.glPushMatrix();
        float preZ = RenderUtils.itemRender.field_77023_b;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor3f((float)r, (float)g, (float)b);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)z);
        RenderUtils.itemRender.field_77023_b = -50.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = mc.field_71466_p;
        }
        try {
            itemRender.func_82406_b(font, mc.func_110434_K(), stack, x, y);
            if (stack.field_77994_a != 1 || text != null) {
                float ty;
                float tx;
                GL11.glPushMatrix();
                int w = RenderUtils.getStringWidth(text, font);
                float s = 1.0f;
                if (w > 17) {
                    s = 17.0f / (float)w;
                    tx = 0.0f;
                    ty = 17.0f - (float)font.field_78288_b * s;
                } else {
                    tx = 17 - w;
                    ty = 18 - font.field_78288_b;
                }
                GL11.glTranslatef((float)((float)x + tx), (float)((float)y + ty), (float)0.0f);
                GL11.glScalef((float)s, (float)s, (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3042);
                font.func_85187_a(text, 0, 0, 0xFFFFFF, true);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                GL11.glEnable((int)3042);
                GL11.glPopMatrix();
            }
            itemRender.func_94148_a(font, mc.func_110434_K(), stack, x, y, "");
        }
        catch (Exception e) {
            BetterQuesting.logger.warn("Unabled to render item " + stack, (Throwable)e);
        }
        GL11.glDisable((int)2929);
        RenderHelper.func_74518_a();
        RenderUtils.itemRender.field_77023_b = preZ;
        GL11.glPopMatrix();
    }

    public static void RenderEntity(int posX, int posY, int scale, float rotation, float pitch, Entity entity) {
        RenderUtils.RenderEntity(posX, posY, 64.0f, scale, rotation, pitch, entity);
    }

    public static void RenderEntity(float posX, float posY, float posZ, int scale, float rotation, float pitch, Entity entity) {
        try {
            GL11.glEnable((int)2903);
            GL11.glPushMatrix();
            GL11.glEnable((int)2929);
            GL11.glTranslatef((float)posX, (float)posY, (float)posZ);
            GL11.glScalef((float)(-scale), (float)scale, (float)scale);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            float f3 = entity.field_70177_z;
            float f4 = entity.field_70125_A;
            RenderHelper.func_74519_b();
            RenderManager.field_78727_a.field_78735_i = 180.0f;
            RenderManager.field_78727_a.func_147940_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
            entity.field_70177_z = f3;
            entity.field_70125_A = f4;
            GL11.glDisable((int)2929);
            GL11.glPopMatrix();
            RenderHelper.func_74518_a();
            GL11.glDisable((int)32826);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
            GL11.glDisable((int)3553);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
            GL11.glEnable((int)3553);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void DrawLine(int x1, int y1, int x2, int y2, float width, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        GL11.glLineWidth((float)width);
        GL11.glBegin((int)1);
        GL11.glVertex2f((float)x1, (float)y1);
        GL11.glVertex2f((float)x2, (float)y2);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void drawSplitString(FontRenderer renderer, String string, int x, int y, int width, int color, boolean shadow) {
        RenderUtils.drawSplitString(renderer, string, x, y, width, color, shadow, 0, RenderUtils.splitString(string, width, renderer).size() - 1);
    }

    public static void drawSplitString(FontRenderer renderer, String string, int x, int y, int width, int color, boolean shadow, int start, int end) {
        RenderUtils.drawHighlightedSplitString(renderer, string, x, y, width, color, shadow, start, end, 0, 0, 0);
    }

    public static void drawHighlightedSplitString(FontRenderer renderer, String string, int x, int y, int width, int color, boolean shadow, int highlightColor, int highlightStart, int highlightEnd) {
        RenderUtils.drawHighlightedSplitString(renderer, string, x, y, width, color, shadow, 0, RenderUtils.splitString(string, width, renderer).size() - 1, highlightColor, highlightStart, highlightEnd);
    }

    public static void drawHighlightedSplitString(FontRenderer renderer, String string, int x, int y, int width, int color, boolean shadow, int start, int end, int highlightColor, int highlightStart, int highlightEnd) {
        int i;
        if (renderer == null || string == null || string.length() <= 0 || start > end) {
            return;
        }
        string = string.replaceAll("\r", "");
        List<String> list = RenderUtils.splitString(string, width, renderer);
        List<String> noFormat = RenderUtils.splitStringWithoutFormat(string, width, renderer);
        if (list.size() != noFormat.size()) {
            return;
        }
        int hlStart = Math.min(highlightStart, highlightEnd);
        int hlEnd = Math.max(highlightStart, highlightEnd);
        int idxStart = 0;
        for (i = 0; i < start && i < noFormat.size(); ++i) {
            idxStart += noFormat.get(i).length();
        }
        for (i = start; i <= end; ++i) {
            if (i < 0 || i >= list.size()) continue;
            renderer.func_85187_a(list.get(i), x, y + renderer.field_78288_b * (i - start), color, shadow);
            int lineSize = noFormat.get(i).length();
            int idxEnd = idxStart + lineSize;
            int i1 = Math.max(idxStart, hlStart) - idxStart;
            int i2 = Math.min(idxEnd, hlEnd) - idxStart;
            if (i1 != i2 && i1 >= 0 && i2 >= 0 && i1 <= lineSize && i2 <= lineSize) {
                String lastFormat = RenderUtils.getFormatFromString(list.get(i));
                int x1 = RenderUtils.getStringWidth(lastFormat + noFormat.get(i).substring(0, i1), renderer);
                int x2 = RenderUtils.getStringWidth(lastFormat + noFormat.get(i).substring(0, i2), renderer);
                RenderUtils.drawHighlightBox(x + x1, y + renderer.field_78288_b * (i - start), x + x2, y + renderer.field_78288_b * (i - start) + renderer.field_78288_b, highlightColor);
            }
            idxStart = idxEnd;
        }
    }

    public static void drawHighlightedString(FontRenderer renderer, String string, int x, int y, int color, boolean shadow, int highlightColor, int highlightStart, int highlightEnd) {
        if (renderer == null || string == null || string.length() <= 0) {
            return;
        }
        renderer.func_85187_a(string, x, y, color, shadow);
        int hlStart = Math.min(highlightStart, highlightEnd);
        int hlEnd = Math.max(highlightStart, highlightEnd);
        int size = string.length();
        int i1 = MathHelper.func_76125_a((int)hlStart, (int)0, (int)size);
        int i2 = MathHelper.func_76125_a((int)hlEnd, (int)0, (int)size);
        if (i1 != i2) {
            int x1 = RenderUtils.getStringWidth(string.substring(0, i1), renderer);
            int x2 = RenderUtils.getStringWidth(string.substring(0, i2), renderer);
            RenderUtils.drawHighlightBox(x + x1, y, x + x2, y + renderer.field_78288_b, highlightColor);
        }
    }

    public static void drawHighlightBox(IGuiRect rect, IGuiColor color) {
        RenderUtils.drawHighlightBox(rect.getX(), rect.getY(), rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight(), color.getRGB());
    }

    public static void drawHighlightBox(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)f3);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)left, (double)bottom, 0.0);
        tessellator.func_78377_a((double)right, (double)bottom, 0.0);
        tessellator.func_78377_a((double)right, (double)top, 0.0);
        tessellator.func_78377_a((double)left, (double)top, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawColoredRect(IGuiRect rect, IGuiColor color) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        color.applyGlColor();
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)rect.getX(), (double)rect.getY() + (double)rect.getHeight(), 0.0);
        tessellator.func_78377_a((double)rect.getX() + (double)rect.getWidth(), (double)rect.getY() + (double)rect.getHeight(), 0.0);
        tessellator.func_78377_a((double)rect.getX() + (double)rect.getWidth(), (double)rect.getY(), 0.0);
        tessellator.func_78377_a((double)rect.getX(), (double)rect.getY(), 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void startScissor(IGuiRect rect) {
        if (scissorStack.size() >= 255) {
            throw new IndexOutOfBoundsException("Exceeded the maximum number of nested scissor (255)");
        }
        GL11.glEnable((int)3089);
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution r = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int f = r.func_78325_e();
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)fb);
        fb.rewind();
        Matrix4f fm = new Matrix4f();
        fm.load(fb);
        GuiRectangle sRect = new GuiRectangle((int)((float)(rect.getX() * f) * fm.m00 + fm.m30 * (float)f), (r.func_78328_b() - (int)((float)(rect.getY() + rect.getHeight()) * fm.m11 + fm.m31)) * f, (int)((float)(rect.getWidth() * f) * fm.m00), (int)((float)(rect.getHeight() * f) * fm.m11));
        if (!scissorStack.empty()) {
            IGuiRect parentRect = scissorStack.peek();
            int x = Math.max(parentRect.getX(), sRect.getX());
            int y = Math.max(parentRect.getY(), sRect.getY());
            int w = Math.min(parentRect.getX() + parentRect.getWidth(), sRect.getX() + sRect.getWidth());
            int h = Math.min(parentRect.getY() + parentRect.getHeight(), sRect.getY() + sRect.getHeight());
            w = Math.max(0, w - x);
            h = Math.max(0, h - y);
            sRect = new GuiRectangle(x, y, w, h, 0);
        } else {
            sRect.w = Math.max(0, sRect.w);
            sRect.h = Math.max(0, sRect.h);
        }
        GL11.glScissor((int)sRect.getX(), (int)sRect.getY(), (int)sRect.getWidth(), (int)sRect.getHeight());
        scissorStack.add(sRect);
    }

    public static void endScissor() {
        scissorStack.pop();
        if (scissorStack.empty()) {
            GL11.glDisable((int)3089);
        } else {
            IGuiRect rect = scissorStack.peek();
            GL11.glScissor((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
        }
    }

    public static List<String> splitStringWithoutFormat(String str, int wrapWidth, FontRenderer font) {
        boolean flag;
        ArrayList<String> list = new ArrayList<String>();
        String lastFormat = "";
        String temp = str;
        do {
            int i = RenderUtils.sizeStringToWidth(lastFormat + temp, wrapWidth, font);
            if (temp.length() <= (i -= lastFormat.length())) {
                list.add(temp);
                break;
            }
            String s = temp.substring(0, i);
            char c0 = temp.charAt(i);
            flag = c0 == ' ' || c0 == '\n';
            lastFormat = RenderUtils.getFormatFromString(lastFormat + s);
            temp = temp.substring(i + (flag ? 1 : 0));
            list.add(s + (flag ? "\n" : ""));
        } while (temp.length() > 0 || flag);
        return list;
    }

    public static List<String> splitString(String str, int wrapWidth, FontRenderer font) {
        boolean flag;
        ArrayList<String> list = new ArrayList<String>();
        String temp = str;
        do {
            int i = RenderUtils.sizeStringToWidth(temp, wrapWidth, font);
            if (temp.length() <= i) {
                list.add(temp);
                break;
            }
            String s = temp.substring(0, i);
            char c0 = temp.charAt(i);
            flag = c0 == ' ' || c0 == '\n';
            temp = RenderUtils.getFormatFromString(s) + temp.substring(i + (flag ? 1 : 0));
            list.add(s);
        } while (temp.length() > 0 || flag);
        return list;
    }

    public static int getCursorPos(String text, int x, FontRenderer font) {
        int i;
        if (text.length() <= 0) {
            return 0;
        }
        for (i = 0; i < text.length() && RenderUtils.getStringWidth(text.substring(0, i + 1), font) <= x; ++i) {
        }
        if (i - 1 >= 0 && text.charAt(i - 1) == '\n') {
            return i - 1;
        }
        return i;
    }

    public static int getCursorPos(String text, int x, int y, int width, FontRenderer font) {
        List<String> tLines = RenderUtils.splitStringWithoutFormat(text, width, font);
        if (tLines.size() <= 0) {
            return 0;
        }
        int row = MathHelper.func_76125_a((int)(y / font.field_78288_b), (int)0, (int)(tLines.size() - 1));
        String lastFormat = "";
        int idx = 0;
        for (int i = 0; i < row; ++i) {
            String line = tLines.get(i);
            idx += line.length();
            lastFormat = RenderUtils.getFormatFromString(lastFormat + line);
        }
        return idx + RenderUtils.getCursorPos(lastFormat + tLines.get(row), x, font) - lastFormat.length();
    }

    public static String getFormatFromString(String p_78282_0_) {
        String s1 = "";
        int i = -1;
        int j = p_78282_0_.length();
        while ((i = p_78282_0_.indexOf(167, i + 1)) != -1) {
            if (i >= j - 1) continue;
            char c0 = p_78282_0_.charAt(i + 1);
            if (RenderUtils.isFormatColor(c0)) {
                s1 = "\u00a7" + c0;
                continue;
            }
            if (!RenderUtils.isFormatSpecial(c0)) continue;
            s1 = s1 + "\u00a7" + c0;
        }
        return s1;
    }

    private static int sizeStringToWidth(String str, int wrapWidth, FontRenderer font) {
        int k;
        int i = str.length();
        int j = 0;
        int l = -1;
        boolean flag = false;
        for (k = 0; k < i; ++k) {
            char c0 = str.charAt(k);
            switch (c0) {
                case '\n': {
                    --k;
                    break;
                }
                case ' ': {
                    l = k;
                }
                default: {
                    j += font.func_78263_a(c0);
                    if (!flag) break;
                    ++j;
                    break;
                }
                case '\u00a7': {
                    char c1;
                    if (k >= i - 1) break;
                    if ((c1 = str.charAt(++k)) != 'l' && c1 != 'L') {
                        if (c1 != 'r' && c1 != 'R' && !RenderUtils.isFormatColor(c1)) break;
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }
            if (c0 == '\n') {
                l = ++k;
                break;
            }
            if (j > wrapWidth) break;
        }
        return k != i && l != -1 && l < k ? l : k;
    }

    private static boolean isFormatColor(char colorChar) {
        return colorChar >= '0' && colorChar <= '9' || colorChar >= 'a' && colorChar <= 'f' || colorChar >= 'A' && colorChar <= 'F';
    }

    private static boolean isFormatSpecial(char p_78270_0_) {
        return p_78270_0_ >= 'k' && p_78270_0_ <= 'o' || p_78270_0_ >= 'K' && p_78270_0_ <= 'O' || p_78270_0_ == 'r' || p_78270_0_ == 'R';
    }

    public static float lerpFloat(float f1, float f2, float blend) {
        return f2 * blend + f1 * (1.0f - blend);
    }

    public static double lerpDouble(double d1, double d2, double blend) {
        return d2 * blend + d1 * (1.0 - blend);
    }

    public static int lerpRGB(int c1, int c2, float blend) {
        float a1 = c1 >> 24 & 0xFF;
        float r1 = c1 >> 16 & 0xFF;
        float g1 = c1 >> 8 & 0xFF;
        float b1 = c1 & 0xFF;
        float a2 = c2 >> 24 & 0xFF;
        float r2 = c2 >> 16 & 0xFF;
        float g2 = c2 >> 8 & 0xFF;
        float b2 = c2 & 0xFF;
        int a3 = (int)RenderUtils.lerpFloat(a1, a2, blend);
        int r3 = (int)RenderUtils.lerpFloat(r1, r2, blend);
        int g3 = (int)RenderUtils.lerpFloat(g1, g2, blend);
        int b3 = (int)RenderUtils.lerpFloat(b1, b2, blend);
        return (a3 << 24) + (r3 << 16) + (g3 << 8) + b3;
    }

    public static void drawHoveringText(List<String> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        RenderUtils.drawHoveringText(null, textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font);
    }

    public static void drawHoveringText(ItemStack stack, List<String> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        if (textLines == null || textLines.isEmpty()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int tooltipTextWidth = 0;
        for (String textLine : textLines) {
            int textLineWidth = RenderUtils.getStringWidth(textLine, font);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        int titleLinesCount = 1;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<String> wrappedTextLines = new ArrayList<String>();
            for (int i = 0; i < textLines.size(); ++i) {
                String textLine = textLines.get(i);
                List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                if (i == 0) {
                    titleLinesCount = wrappedLine.size();
                }
                for (String line : wrappedLine) {
                    int lineWidth = RenderUtils.getStringWidth(line, font);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > titleLinesCount) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        int backgroundColor = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        RenderUtils.drawGradientRect(0, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
        RenderUtils.drawGradientRect(0, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
        RenderUtils.drawGradientRect(0, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        RenderUtils.drawGradientRect(0, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        RenderUtils.drawGradientRect(0, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        RenderUtils.drawGradientRect(0, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        RenderUtils.drawGradientRect(0, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        RenderUtils.drawGradientRect(0, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
        RenderUtils.drawGradientRect(0, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
        int tooltipTop = tooltipY;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.1f);
        for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
            String line = textLines.get(lineNumber);
            font.func_78261_a(line, tooltipX, tooltipY, -1);
            if (lineNumber + 1 == titleLinesCount) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        GL11.glEnable((int)2896);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
        GL11.glPopMatrix();
    }

    public static void drawGradientRect(int zDepth, int p_drawGradientRect_1_, int p_drawGradientRect_2_, int p_drawGradientRect_3_, int p_drawGradientRect_4_, int p_drawGradientRect_5_, int p_drawGradientRect_6_) {
        float var7 = (float)(p_drawGradientRect_5_ >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(p_drawGradientRect_5_ >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(p_drawGradientRect_5_ >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(p_drawGradientRect_5_ & 0xFF) / 255.0f;
        float var11 = (float)(p_drawGradientRect_6_ >> 24 & 0xFF) / 255.0f;
        float var12 = (float)(p_drawGradientRect_6_ >> 16 & 0xFF) / 255.0f;
        float var13 = (float)(p_drawGradientRect_6_ >> 8 & 0xFF) / 255.0f;
        float var14 = (float)(p_drawGradientRect_6_ & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator var15 = Tessellator.field_78398_a;
        var15.func_78382_b();
        var15.func_78369_a(var8, var9, var10, var7);
        var15.func_78377_a((double)p_drawGradientRect_3_, (double)p_drawGradientRect_2_, (double)zDepth);
        var15.func_78377_a((double)p_drawGradientRect_1_, (double)p_drawGradientRect_2_, (double)zDepth);
        var15.func_78369_a(var12, var13, var14, var11);
        var15.func_78377_a((double)p_drawGradientRect_1_, (double)p_drawGradientRect_4_, (double)zDepth);
        var15.func_78377_a((double)p_drawGradientRect_3_, (double)p_drawGradientRect_4_, (double)zDepth);
        var15.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static int getStringWidth(String text, FontRenderer font) {
        if (text == null || text.length() == 0) {
            return 0;
        }
        int i = 0;
        boolean flag = false;
        for (int j = 0; j < text.length(); ++j) {
            char c0 = text.charAt(j);
            int k = font.func_78263_a(c0);
            if (k < 0 && j < text.length() - 1) {
                if ((c0 = text.charAt(++j)) != 'l' && c0 != 'L') {
                    int ci = "0123456789abcdefklmnor".indexOf(String.valueOf(c0).toLowerCase(Locale.ROOT).charAt(0));
                    if (ci < 16 || ci == 21) {
                        flag = false;
                    }
                } else {
                    flag = true;
                }
                k = 0;
            }
            i += k;
            if (!flag || k <= 0) continue;
            ++i;
        }
        return i;
    }
}

