/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class LiquidUtil {
    public static boolean placeFluid(FluidStack fs, World world, int x, int y, int z) {
        if (fs == null || fs.amount < 1000) {
            return false;
        }
        Fluid fluid = fs.getFluid();
        Block block = world.func_147439_a(x, y, z);
        if (!(!block.isAir((IBlockAccess)world, x, y, z) && block.func_149688_o().func_76220_a() || !fluid.canBePlacedInWorld() || block == fluid.getBlock() && LiquidUtil.isFullFluidBlock(world, x, y, z, block))) {
            if (world.field_73011_w.field_76575_d && fluid == FluidRegistry.WATER) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                for (int i = 0; i < 8; ++i) {
                    world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
                }
            } else {
                int meta;
                if (!(world.field_72995_K || block.func_149688_o().func_76220_a() || block.func_149688_o().func_76224_d())) {
                    world.func_147480_a(x, y, z, true);
                }
                if (fluid != FluidRegistry.WATER && fluid != FluidRegistry.LAVA) {
                    block = fluid.getBlock();
                }
                int n = meta = block instanceof BlockFluidBase ? ((BlockFluidBase)block).getMaxRenderHeightMeta() : 0;
                if (!world.func_147465_d(x, y, z, block, meta, 3)) {
                    return false;
                }
            }
            fs.amount -= 1000;
            return true;
        }
        return false;
    }

    private static boolean isFullFluidBlock(World world, int x, int y, int z, Block block) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fBlock = (IFluidBlock)block;
            FluidStack drained = fBlock.drain(world, x, y, z, false);
            return drained != null && drained.amount >= 1000;
        }
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return world.func_72805_g(x, y, z) == 0;
        }
        return false;
    }
}

