/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.neutroniumgenerator;

import com.denfop.Config;
import com.denfop.block.base.BlocksItems;
import com.denfop.container.ContainerNeutroniumGenerator;
import com.denfop.gui.GUINeutronGenerator;
import com.denfop.tiles.neutroniumgenerator.TileEntityLiquidTankElectricMachine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Redstone;
import ic2.core.block.comp.TileEntityComponent;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.network.NetworkManager;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileNeutronGenerator
extends TileEntityLiquidTankElectricMachine
implements IHasGui,
IUpgradableBlock {
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotOutput outputSlot;
    public final InvSlotConsumableLiquid containerslot;
    protected final Redstone redstone;
    private final double costenergy = Config.energy;
    private int state = 0;
    private int prevState = 0;
    private AudioSource audioSource;
    private AudioSource audioSourceScrap;

    public TileNeutronGenerator() {
        super(Config.energy * 128.0, 14, -1, 9);
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 1, 1);
        this.containerslot = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "containerslot", 2, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Fill, new Fluid[]{BlocksItems.getFluid("fluidNeutron")});
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 3, 4);
        this.redstone = (Redstone)this.addComponent((TileEntityComponent)new Redstone((TileEntityBlock)this));
    }

    private static int applyModifier(int extra) {
        double ret = Math.round((double)(14 + extra) * 1.0);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
    }

    public String func_145825_b() {
        return null;
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
            needsInvUpdate = true;
        }
        if (this.redstone.hasRedstoneInput() || this.energy <= 0.0) {
            this.setState();
            this.setActive(false);
        } else {
            MutableObject output;
            this.setActive(true);
            if (this.energy >= this.costenergy) {
                needsInvUpdate = this.attemptGeneration();
            }
            if (this.containerslot.transferFromTank((IFluidTank)this.fluidTank, output = new MutableObject(), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
                this.containerslot.transferFromTank((IFluidTank)this.fluidTank, output, false);
                if (output.getValue() != null) {
                    this.outputSlot.add((ItemStack)output.getValue());
                }
            }
            if (needsInvUpdate) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSource = null;
            this.audioSourceScrap = null;
        }
        super.onUnloaded();
    }

    public boolean attemptGeneration() {
        int k = (int)(this.energy / this.costenergy);
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return false;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (k > m) {
            this.fill(null, new FluidStack(BlocksItems.getFluid("fluidNeutron"), m), true);
            this.energy -= this.costenergy * (double)m;
            return true;
        }
        if (m > k) {
            this.fill(null, new FluidStack(BlocksItems.getFluid("fluidNeutron"), k), true);
            this.energy -= this.costenergy * (double)k;
            return true;
        }
        this.fill(null, new FluidStack(BlocksItems.getFluid("fluidNeutron"), k), true);
        this.energy -= this.costenergy * (double)k;
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        if (this.redstone.hasRedstoneInput()) {
            return 0.0;
        }
        return this.maxEnergy - this.energy;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= this.maxEnergy || this.redstone.hasRedstoneInput()) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    public String getProgressAsString() {
        int p = Math.min((int)(this.energy * 100.0 / this.costenergy), 100);
        return "" + p + "%";
    }

    public ContainerBase<TileNeutronGenerator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerNeutroniumGenerator(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUINeutronGenerator(new ContainerNeutroniumGenerator(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    private void setState() {
        this.state = 0;
        if (this.prevState != this.state) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "state");
        }
        this.prevState = this.state;
    }

    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("state");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("state") && this.prevState != this.state) {
            switch (this.state) {
                case 0: {
                    if (this.audioSource != null) {
                        this.audioSource.stop();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 1: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 2: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSourceScrap == null) {
                        this.audioSourceScrap = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/MassFabricator/MassFabScrapSolo.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.play();
                }
            }
            this.prevState = this.state;
        }
        super.onNetworkUpdate(field);
    }

    public float getWrenchDropRate() {
        return 0.7f;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == BlocksItems.getFluid("fluidNeutron");
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        this.upgradeSlot.onChanged();
        this.setTier(TileNeutronGenerator.applyModifier(this.upgradeSlot.extraTier));
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.RedstoneSensitive, UpgradableProperty.Transformer, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidProducing);
    }
}

