/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.container.ContainerPump;
import com.denfop.gui.GUIPump;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankElectricMachine;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityPump
extends TileEntityLiquidTankElectricMachine
implements IHasGui,
IUpgradableBlock {
    public final int defaultTier;
    public final int defaultEnergyStorage;
    public final int defaultEnergyConsume;
    public final int defaultOperationLength;
    public final InvSlotConsumableLiquid containerSlot = new InvSlotConsumableLiquid((TileEntityInventory)this, "containerSlot", 1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Fill);
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 2, 1);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 3, 4);
    private final String name;
    public int energyConsume = 1;
    public int operationsPerTick;
    public short progress = 0;
    public int operationLength;
    public float guiProgress;
    private AudioSource audioSource;

    public TileEntityPump(String name, int size, int operationLength) {
        super(operationLength, 1, 1, size);
        this.defaultEnergyConsume = 1;
        this.defaultOperationLength = this.operationLength = operationLength;
        this.defaultTier = 1;
        this.name = name;
        this.defaultEnergyStorage = this.operationLength;
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public void updateEntityServer() {
        MutableObject output;
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.energy >= (double)(this.energyConsume * this.operationLength)) {
            if (this.progress < this.operationLength) {
                this.progress = (short)(this.progress + 1);
                this.energy -= (double)this.energyConsume;
            } else if (this.canoperate()) {
                this.progress = 0;
                this.operate(false);
            }
        }
        if (this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, output = new MutableObject(), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
            needsInvUpdate = true;
        }
        this.guiProgress = (float)this.progress / (float)this.operationLength;
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    public String func_145825_b() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public boolean canoperate() {
        return this.operate(true);
    }

    public boolean operate(boolean sim) {
        ArrayList<FluidStack> liquid_list = new ArrayList<FluidStack>();
        for (int i = this.field_145851_c - 1; i < this.field_145851_c + 1; ++i) {
            for (int j = this.field_145849_e - 1; j < this.field_145849_e + 1; ++j) {
                for (int k = this.field_145848_d - 1; k < this.field_145848_d + 1; ++k) {
                    for (Direction dir : Direction.directions) {
                        FluidStack liquid = this.pump(i + dir.xOffset, k + dir.yOffset, j + dir.zOffset, sim);
                        if (liquid == null) continue;
                        liquid_list.add(liquid);
                    }
                }
            }
        }
        boolean canoperate = false;
        for (FluidStack stack : liquid_list) {
            if (!liquid_list.isEmpty()) {
                if (!sim) {
                    if (this.getFluidTank().fill(stack, false) <= 0) continue;
                    this.getFluidTank().fill(stack, true);
                    canoperate = true;
                    continue;
                }
                if (this.getFluidTank().fill(stack, false) <= 0) continue;
                return true;
            }
            return false;
        }
        return canoperate;
    }

    public FluidStack pump(int x, int y, int z, boolean sim) {
        Block block;
        FluidStack ret = null;
        int freespace = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (freespace >= 1000 && !this.field_145850_b.func_147437_c(x, y, z) && (block = this.field_145850_b.func_147439_a(x, y, z)).func_149688_o().func_76224_d()) {
            if (block instanceof IFluidBlock) {
                IFluidBlock liquid = (IFluidBlock)block;
                if (liquid.canDrain(this.field_145850_b, x, y, z)) {
                    if (!sim) {
                        ret = liquid.drain(this.field_145850_b, x, y, z, true);
                        this.field_145850_b.func_147468_f(x, y, z);
                    } else {
                        ret = new FluidStack(liquid.getFluid(), 1000);
                    }
                }
            } else {
                if (this.field_145850_b.func_72805_g(x, y, z) != 0) {
                    return null;
                }
                ret = new FluidStack(FluidRegistry.getFluid((String)block.func_149739_a().substring(5)), 1000);
                if (!sim && ret != null) {
                    this.field_145850_b.func_147468_f(x, y, z);
                }
            }
        }
        return ret;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    public void setFacing(short side) {
        super.setFacing(side);
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        this.upgradeSlot.onChanged();
        double previousProgress = (double)this.progress / (double)this.operationLength;
        double stackOpLen = ((double)this.defaultOperationLength + (double)this.upgradeSlot.extraProcessTime) * 64.0 * this.upgradeSlot.processTimeMultiplier;
        this.operationsPerTick = (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
        this.operationLength = (int)Math.round(stackOpLen * (double)this.operationsPerTick / 64.0);
        this.energyConsume = TileEntityPump.applyModifier(this.defaultEnergyConsume, this.upgradeSlot.extraEnergyDemand, 1.0);
        this.setTier(TileEntityPump.applyModifier(this.defaultTier, this.upgradeSlot.extraTier, 1.0));
        this.maxEnergy = TileEntityPump.applyModifier(this.defaultEnergyStorage, this.upgradeSlot.extraEnergyStorage + this.operationLength * this.energyConsume, this.upgradeSlot.energyStorageMultiplier);
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        this.progress = (short)Math.floor(previousProgress * (double)this.operationLength + 0.1);
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
    }

    public ContainerBase<TileEntityPump> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPump(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUIPump(new ContainerPump(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Machines/PumpOp.ogg", true, false, IC2.audioManager.getDefaultVolume());
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, new UpgradableProperty[]{UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidProducing});
    }
}

