/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.container.ContainerElectricLather;
import com.denfop.gui.GUIElectricLather;
import com.denfop.invslot.InvSlotLatheUpgrade;
import com.denfop.tiles.base.TileEntityElectricMachine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ILatheItem;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotConsumableClass;
import ic2.core.block.invslot.InvSlotOutput;
import java.util.Arrays;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityElectricLather
extends TileEntityElectricMachine
implements IHasGui,
INetworkClientTileEntityEventListener {
    public final InvSlotConsumableClass toolSlot = new InvSlotConsumableClass((TileEntityInventory)this, "slotTool", 0, 1, ILatheItem.ILatheTool.class);
    public final InvSlotConsumableClass latheSlot = new InvSlotConsumableClass((TileEntityInventory)this, "lathe", 1, 1, ILatheItem.class);
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "dusts", 2, 1);
    public final InvSlotLatheUpgrade inputslot = new InvSlotLatheUpgrade(this, 5);

    public TileEntityElectricLather() {
        super(1000.0, 14, -1);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.setActive(this.energy > 25.0);
        if (!this.inputslot.isEmpty()) {
            int[] state = this.getCurrentState(this.inputslot.get());
            if (this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L) {
                this.process(state);
            }
        }
    }

    public int[] getCurrentState(ItemStack stack) {
        if (stack == null) {
            return new int[0];
        }
        int[] ret = new int[5];
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = tag.func_74764_b("l" + i) ? tag.func_74762_e("l" + i) : 5;
            }
        } else {
            Arrays.fill(ret, 5);
        }
        return ret;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    public ContainerBase<TileEntityElectricLather> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectricLather(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUIElectricLather((ContainerElectricLather)this.getGuiContainer(entityPlayer));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public String func_145825_b() {
        return "Lathe";
    }

    public void process(int[] position1) {
        if (this.canWork(false)) {
            for (int position = 0; position < position1.length; ++position) {
                ILatheItem l = (ILatheItem)this.latheSlot.get().func_77973_b();
                ILatheItem.ILatheTool t = (ILatheItem.ILatheTool)this.toolSlot.get().func_77973_b();
                if (!this.outputSlot.canAdd(l.getOutputItem(this.latheSlot.get(), position))) {
                    return;
                }
                int[] currentState = l.getCurrentState(this.latheSlot.get());
                if (currentState[position] <= 1) {
                    return;
                }
                if (currentState[position] <= position1[position]) continue;
                l.setState(this.latheSlot.get(), position, currentState[position] - 1);
                if (this.field_145850_b.field_73012_v.nextFloat() < l.getOutputChance(this.latheSlot.get(), position)) {
                    this.outputSlot.add(l.getOutputItem(this.latheSlot.get(), position));
                }
                t.setCustomDamage(this.toolSlot.get(), t.getCustomDamage(this.toolSlot.get()) + 1);
                if (t.getCustomDamage(this.toolSlot.get()) >= t.getMaxCustomDamage(this.toolSlot.get())) {
                    this.toolSlot.put(null);
                }
                this.energy -= 25.0;
                break;
            }
        }
    }

    public boolean canWork(boolean power) {
        if (this.toolSlot.get() != null && this.toolSlot.get().func_77973_b() instanceof ILatheItem.ILatheTool) {
            if (this.latheSlot.get() != null && this.latheSlot.get().func_77973_b() instanceof ILatheItem) {
                if (this.energy < 25.0 && !power) {
                    return false;
                }
                ILatheItem l = (ILatheItem)this.latheSlot.get().func_77973_b();
                ILatheItem.ILatheTool t = (ILatheItem.ILatheTool)this.toolSlot.get().func_77973_b();
                return t.getHardness(this.toolSlot.get()) > l.getHardness(this.latheSlot.get());
            }
            return false;
        }
        return false;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return side != this.getFacing();
    }
}

