/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import cofh.api.energy.IEnergyReceiver;
import com.denfop.Config;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.inv.IInvSlotProcessableMulti;
import com.denfop.audio.AudioSource;
import com.denfop.container.ContainerMultiMachine;
import com.denfop.gui.GUIMultiMachine;
import com.denfop.gui.GUIMultiMachine1;
import com.denfop.gui.GUIMultiMachine2;
import com.denfop.gui.GUIMultiMachine3;
import com.denfop.invslot.InvSlotProcessableMultiSmelting;
import com.denfop.tiles.base.GenerationState;
import com.denfop.tiles.base.TileEntitySolarPanel;
import com.denfop.tiles.mechanism.EnumMultiMachine;
import com.denfop.tiles.overtimepanel.EnumSolarPanels;
import com.denfop.utils.ModUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.EnergyNet;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.network.NetworkManager;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityMultiMachine
extends TileEntityElectricMachine
implements IHasGui,
INetworkTileEntityEventListener,
IUpgradableBlock,
IEnergyReceiver {
    public final int min;
    public final int max;
    public final boolean random;
    public final int type;
    public final short[] progress;
    public final double maxEnergy2;
    public final int defaultTier;
    public final int defaultEnergyStorage;
    public final int defaultOperationsPerTick;
    public final int defaultEnergyConsume;
    public final int sizeWorkingSlot;
    public final InvSlotOutput outputSlots;
    public final InvSlotUpgrade upgradeSlot;
    public final int expmaxstorage;
    protected final double[] guiProgress;
    public EnumSolarPanels solartype;
    public IMachineRecipeManager recipe;
    public int module;
    public boolean quickly;
    public boolean modulesize = false;
    public double energy2;
    public int expstorage = 0;
    public int operationLength;
    public int operationsPerTick;
    public int energyConsume;
    public AudioSource audioSource;
    public IInvSlotProcessableMulti inputSlots;
    public boolean rf;

    public TileEntityMultiMachine(int energyconsume, int OperationsPerTick, IMachineRecipeManager recipe, int type) {
        this(1, energyconsume, OperationsPerTick, recipe, 0, 0, false, type);
    }

    public TileEntityMultiMachine(int energyconsume, int OperationsPerTick, IMachineRecipeManager recipe, int min, int max, boolean random, int type) {
        this(1, energyconsume, OperationsPerTick, recipe, min, max, random, type);
    }

    public TileEntityMultiMachine(int aDefaultTier, int energyconsume, int OperationsPerTick, IMachineRecipeManager recipe, int min, int max, boolean random, int type) {
        super(energyconsume * OperationsPerTick, 1, 1);
        this.sizeWorkingSlot = this.getMachine().sizeWorkingSlot;
        this.progress = new short[this.sizeWorkingSlot];
        this.guiProgress = new double[this.sizeWorkingSlot];
        if (recipe != null) {
            if (recipe.equals(Recipes.createscrap)) {
                this.energyConsume = 25;
                this.defaultEnergyConsume = 25;
            } else {
                this.defaultEnergyConsume = this.energyConsume = energyconsume;
            }
        } else {
            this.defaultEnergyConsume = this.energyConsume = energyconsume;
        }
        this.defaultOperationsPerTick = this.operationLength = OperationsPerTick;
        this.defaultTier = aDefaultTier;
        this.defaultEnergyStorage = energyconsume * OperationsPerTick;
        this.outputSlots = new InvSlotOutput((TileEntityInventory)this, "output", 1, this.sizeWorkingSlot);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 4, 4);
        this.expmaxstorage = Config.expstorage;
        this.maxEnergy2 = energyconsume * OperationsPerTick * 4;
        this.rf = false;
        this.quickly = false;
        this.module = 0;
        this.recipe = recipe;
        this.min = min;
        this.max = max;
        this.random = random;
        this.type = type;
        this.solartype = null;
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    public abstract EnumMultiMachine getMachine();

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        for (int i = 0; i < this.sizeWorkingSlot; ++i) {
            this.progress[i] = nbttagcompound.func_74765_d("progress" + i);
        }
        if (nbttagcompound.func_74762_e("expstorage") > 0) {
            this.expstorage = nbttagcompound.func_74762_e("expstorage");
        }
        this.energy2 = nbttagcompound.func_74769_h("energy2");
        this.rf = nbttagcompound.func_74767_n("rf");
        this.quickly = nbttagcompound.func_74767_n("quickly");
        this.modulesize = nbttagcompound.func_74767_n("modulesize");
        int id = nbttagcompound.func_74762_e("panelid");
        if (id != -1) {
            this.solartype = IUItem.map.get(id);
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        for (int i = 0; i < this.sizeWorkingSlot; ++i) {
            nbttagcompound.func_74777_a("progress" + i, this.progress[i]);
        }
        if (this.expstorage > 0) {
            nbttagcompound.func_74768_a("expstorage", this.expstorage);
        }
        nbttagcompound.func_74780_a("energy2", this.energy2);
        nbttagcompound.func_74757_a("rf", this.rf);
        nbttagcompound.func_74757_a("quickly", this.quickly);
        nbttagcompound.func_74757_a("modulesize", this.modulesize);
        if (this.solartype != null) {
            nbttagcompound.func_74768_a("panelid", this.solartype.meta);
        } else {
            nbttagcompound.func_74768_a("panelid", -1);
        }
    }

    public double getProgress(int slotId) {
        return this.guiProgress[slotId];
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IUCore.audioManager.removeSources(this);
            this.audioSource = null;
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection arg0) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return (int)this.energy2;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)this.maxEnergy2;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.rf) {
            return this.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int receiveEnergy(int paramInt, boolean paramBoolean) {
        int i = (int)Math.min(this.maxEnergy2 - this.energy2, Math.min(EnergyNet.instance.getPowerFromTier(this.getSinkTier()) * (double)Config.coefficientrf, (double)paramInt));
        if (!paramBoolean) {
            this.energy2 += (double)i;
        }
        return i;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        ItemStack ret = super.getWrenchDrop(entityPlayer);
        NBTTagCompound nbttagcompound = ModUtils.nbt(ret);
        nbttagcompound.func_74757_a("rf", this.rf);
        return ret;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (amount == 0.0) {
            return 0.0;
        }
        if (this.energy >= (double)this.maxEnergy) {
            return amount;
        }
        if (this.energy + amount >= (double)this.maxEnergy) {
            double p = (double)this.maxEnergy - this.energy;
            this.energy = this.maxEnergy;
            return amount - p;
        }
        this.energy += amount;
        return 0.0;
    }

    public void updateVisibility(TileEntitySolarPanel type) {
        type.rain = type.wetBiome && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I());
        type.sunIsUp = this.field_145850_b.func_72935_r();
        boolean bl = type.skyIsVisible = this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && !type.noSunWorld;
        if (!type.skyIsVisible) {
            type.active = GenerationState.NONE;
        }
        if (type.sunIsUp && type.skyIsVisible) {
            type.active = !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I() ? GenerationState.DAY : GenerationState.RAINDAY;
        }
        if (!type.sunIsUp && type.skyIsVisible) {
            type.active = !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I() ? GenerationState.NIGHT : GenerationState.RAINNIGHT;
        }
        if (this.func_145831_w().field_73011_w.field_76574_g == 1) {
            type.active = GenerationState.END;
        }
        if (this.func_145831_w().field_73011_w.field_76574_g == -1) {
            type.active = GenerationState.NETHER;
        }
    }

    public void updateEntityServer() {
        int i;
        super.updateEntityServer();
        if (this.solartype != null && (this.energy < (double)this.maxEnergy || this.energy2 < this.maxEnergy2 && this.rf)) {
            TileEntitySolarPanel panel = new TileEntitySolarPanel(this.solartype);
            if (panel.func_145831_w() != this.field_145850_b) {
                panel.func_145834_a(this.field_145850_b);
            }
            panel.skyIsVisible = this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && !panel.noSunWorld;
            panel.wetBiome = this.field_145850_b.func_72959_q().func_76935_a(this.field_145851_c, this.field_145849_e).func_76744_g() > 0;
            panel.rain = panel.wetBiome && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I());
            panel.sunIsUp = this.field_145850_b.func_72935_r();
            if (panel.active == null || this.func_145831_w().field_73011_w.getWorldTime() % 40L == 0L) {
                this.updateVisibility(panel);
            }
            panel.gainFuelMachine();
            if (this.energy < (double)this.maxEnergy) {
                this.energy += Math.min(panel.generating, this.getDemandedEnergy());
            } else if (this.energy2 < this.maxEnergy2 && this.rf) {
                this.energy2 += Math.min(panel.generating, (this.maxEnergy2 - this.energy2) / (double)Config.coefficientrf);
            }
        }
        if (this.recipe != null && this.recipe.equals(Recipes.fermer)) {
            return;
        }
        boolean needsInvUpdate = false;
        boolean isActive = false;
        int quickly = 1;
        for (i = 0; i < this.sizeWorkingSlot; ++i) {
            RecipeOutput output = this.getOutput(i);
            if (this.quickly) {
                quickly = 100;
            }
            int size = 1;
            if (this.inputSlots.get1(i) != null && this.modulesize) {
                int j = 0;
                while (true) {
                    ItemStack stack = new ItemStack(this.inputSlots.get1(i).func_77973_b(), j, this.inputSlots.get1(i).func_77960_j());
                    if (this.recipe != null) {
                        if (this.recipe.getOutputFor(stack, false) != null) {
                            size = j;
                            break;
                        }
                    } else if (this.inputSlots instanceof InvSlotProcessableMultiSmelting) {
                        size = 1;
                        break;
                    }
                    ++j;
                }
                size = (int)Math.floor((float)this.inputSlots.get1((int)i).field_77994_a / (float)size);
                int size1 = 0;
                for (int ii = 0; ii < this.sizeWorkingSlot; ++ii) {
                    if (this.outputSlots.get(ii) != null) {
                        size1 += 64 - this.outputSlots.get((int)ii).field_77994_a;
                        continue;
                    }
                    size1 += 64;
                }
                if (output != null) {
                    size1 /= ((ItemStack)output.items.get((int)0)).field_77994_a;
                }
                size = Math.min(size1, size);
            }
            if (output != null && (this.energy >= (double)Math.abs(this.energyConsume * quickly * size) || this.energy2 >= (double)Math.abs(this.energyConsume * Config.coefficientrf * quickly * size))) {
                isActive = true;
                if (this.progress[i] == 0) {
                    this.initiate(0);
                }
                int n = i;
                this.progress[n] = (short)(this.progress[n] + 1);
                this.guiProgress[i] = (double)this.progress[i] / (double)this.operationLength;
                if (this.energy >= (double)Math.abs(this.energyConsume * quickly * size)) {
                    this.energy -= (double)Math.abs(this.energyConsume * quickly * size);
                } else if (this.energy2 >= (double)Math.abs(this.energyConsume * Config.coefficientrf * quickly * size)) {
                    this.energy2 -= (double)Math.abs(this.energyConsume * Config.coefficientrf * quickly * size);
                }
                if (this.progress[i] < this.operationLength && !this.quickly) continue;
                this.guiProgress[i] = 0.0;
                this.progress[i] = 0;
                if (this.expstorage < this.expmaxstorage) {
                    Random rand = this.field_145850_b.field_73012_v;
                    int exp = rand.nextInt(3) + 1;
                    this.expstorage += exp;
                    if (this.expstorage >= this.expmaxstorage) {
                        this.expstorage = this.expmaxstorage;
                    }
                }
                this.operate(i, output, size);
                needsInvUpdate = true;
                this.initiate(2);
                continue;
            }
            if (this.progress[i] != 0 && this.getActive()) {
                this.initiate(1);
            }
            if (output != null) continue;
            this.progress[i] = 0;
        }
        if (this.getActive() != isActive) {
            this.setActive(isActive);
        }
        for (i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    protected void initiate(int soundEvent) {
        ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, soundEvent, true);
    }

    public final float getChargeLevel1() {
        return Math.min((float)this.energy2 / (float)this.maxEnergy2, 1.0f);
    }

    public final float getChargeLevel2() {
        return Math.min((float)this.energy / (float)this.maxEnergy, 1.0f);
    }

    public void setOverclockRates() {
        this.upgradeSlot.onChanged();
        double stackOpLen = (double)(this.defaultOperationsPerTick + this.upgradeSlot.extraProcessTime) * 64.0 * this.upgradeSlot.processTimeMultiplier;
        this.operationsPerTick = (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
        this.operationLength = (int)Math.round(stackOpLen * (double)this.operationsPerTick / 64.0);
        this.energyConsume = TileEntityMultiMachine.applyModifier(this.defaultEnergyConsume, this.upgradeSlot.extraEnergyDemand, this.upgradeSlot.energyDemandMultiplier);
        this.setTier(TileEntityMultiMachine.applyModifier(this.defaultTier, this.upgradeSlot.extraTier, 1.0));
        this.maxEnergy = TileEntityMultiMachine.applyModifier(this.defaultEnergyStorage, this.upgradeSlot.extraEnergyStorage + this.operationLength * this.energyConsume, this.upgradeSlot.energyStorageMultiplier);
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
    }

    public void operate(int slotId, RecipeOutput output, int size) {
        for (int i = 0; i < this.operationsPerTick; ++i) {
            this.operateOnce(slotId, output.items, size, output);
            output = this.getOutput(slotId);
            if (output == null) break;
        }
    }

    public void operateOnce(int slotId, List<ItemStack> processResult, int size, RecipeOutput output) {
        for (int i = 0; i < size; ++i) {
            if (!this.random) {
                if (this.recipe != null) {
                    if ((output.metadata == null || output.metadata.func_74767_n("consume")) && this.recipe.equals(Recipes.fermer)) {
                        this.inputSlots.consume(slotId);
                    } else {
                        this.inputSlots.consume(slotId);
                    }
                } else {
                    this.inputSlots.consume(slotId);
                }
                this.outputSlots.add(processResult);
                continue;
            }
            Random rand = this.field_145850_b.field_73012_v;
            if (rand.nextInt(this.max + 1) > this.min) continue;
            if (output.metadata == null || output.metadata.func_74767_n("consume")) {
                this.inputSlots.consume(slotId);
            }
            this.outputSlots.add(processResult);
        }
    }

    public RecipeOutput getOutput(int slotId) {
        if (this.inputSlots.isEmpty(slotId)) {
            return null;
        }
        RecipeOutput output = this.inputSlots.process(slotId);
        if (output == null) {
            return null;
        }
        if (this.outputSlots.canAdd(output.items)) {
            return output;
        }
        return null;
    }

    public abstract String func_145825_b();

    public ContainerBase<? extends TileEntityMultiMachine> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMultiMachine<TileEntityMultiMachine>(entityPlayer, this, this.sizeWorkingSlot);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        if (this.type == 0) {
            return new GUIMultiMachine(new ContainerMultiMachine<TileEntityMultiMachine>(entityPlayer, this, this.sizeWorkingSlot));
        }
        if (this.type == 1) {
            return new GUIMultiMachine1(new ContainerMultiMachine<TileEntityMultiMachine>(entityPlayer, this, this.sizeWorkingSlot));
        }
        if (this.type == 2) {
            return new GUIMultiMachine2(new ContainerMultiMachine<TileEntityMultiMachine>(entityPlayer, this, this.sizeWorkingSlot));
        }
        if (this.type == 3) {
            return new GUIMultiMachine3(new ContainerMultiMachine<TileEntityMultiMachine>(entityPlayer, this, this.sizeWorkingSlot));
        }
        return null;
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IUCore.audioManager.createSource(this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IUCore.audioManager.playOnce(this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public int getMode() {
        return 0;
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }
}

