/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.item.energy;

import buildcraft.api.tools.IToolWrench;
import com.denfop.IUCore;
import com.denfop.audio.PositionSpec;
import com.denfop.proxy.CommonProxy;
import com.denfop.tiles.base.TileEntitySolarPanel;
import com.denfop.utils.Helpers;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import com.eloraam.redpower.core.IRotatable;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.block.machine.tileentity.TileEntityTerra;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLever;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import org.lwjgl.input.Keyboard;

public class ItemGraviTool
extends ItemTool
implements IElectricItem,
IToolWrench {
    public static final IIcon[] iconsList = new IIcon[5];
    public static final int hoeTextureIndex = 0;
    public static final int treeTapTextureIndex = 1;
    public static final int wrenchTextureIndex = 2;
    public static final int screwDriverTextureIndex = 3;
    private final Set<Class<? extends Block>> shiftRotations = Sets.newHashSet((Object[])new Class[]{BlockLever.class, BlockButton.class, BlockChest.class});
    private final String name;
    private final int energyPerWrenchStandartOperation = 500;

    public ItemGraviTool(String name, Item.ToolMaterial toolMaterial) {
        super(0.0f, toolMaterial, new HashSet());
        this.func_77656_e(27);
        this.field_77864_a = 16.0f;
        this.func_77637_a(IUCore.tabssp2);
        this.func_77655_b(name);
        this.setNoRepair();
        this.name = name;
        GameRegistry.registerItem((Item)this, (String)name);
    }

    public static void setToolName(ItemStack stack) {
        Integer mode = ItemGraviTool.readToolMode(stack);
        if (mode == 1) {
            stack.func_151001_c(Helpers.formatMessage("iu.item.graviTool.name") + " (" + Helpers.formatMessage("iu.graviTool.snap.Hoe") + ")");
        }
        if (mode == 2) {
            stack.func_151001_c(Helpers.formatMessage("iu.item.graviTool.name") + " (" + Helpers.formatMessage("iu.graviTool.snap.TreeTap") + ")");
        }
        if (mode == 3) {
            stack.func_151001_c(Helpers.formatMessage("iu.item.graviTool.name") + " (" + Helpers.formatMessage("iu.graviTool.snap.Wrench") + ")");
        }
        if (mode == 4) {
            stack.func_151001_c(Helpers.formatMessage("iu.item.graviTool.name") + " (" + Helpers.formatMessage("iu.graviTool.snap.Screwdriver") + ")");
        }
        if (mode == 5) {
            stack.func_151001_c(Helpers.formatMessage("iu.item.graviTool.name") + " (" + Helpers.formatMessage("iu.graviTool.snap.Purifier") + ")");
        }
    }

    public static void dropAsEntity(World world, int x, int y, int z, ItemStack stack) {
        if (stack != null) {
            double xOffset = (double)world.field_73012_v.nextFloat() * 0.7 + 0.15000000000000002;
            double yOffset = (double)world.field_73012_v.nextFloat() * 0.7 + 0.15000000000000002;
            double zOffset = (double)world.field_73012_v.nextFloat() * 0.7 + 0.15000000000000002;
            EntityItem entity = new EntityItem(world, (double)x + xOffset, (double)y + yOffset, (double)z + zOffset, stack.func_77946_l());
            entity.field_145804_b = 10;
            world.func_72838_d((Entity)entity);
        }
    }

    public static MovingObjectPosition retraceBlock(World var0, EntityPlayer var1, int var2, int var3, int var4) {
        Vec3 var5 = Vec3.func_72443_a((double)var1.field_70165_t, (double)(var1.field_70163_u + 1.62 - (double)var1.field_70129_M), (double)var1.field_70161_v);
        Vec3 var6 = var1.func_70676_i(1.0f);
        Vec3 var7 = var5.func_72441_c(var6.field_72450_a * 5.0, var6.field_72448_b * 5.0, var6.field_72449_c * 5.0);
        Block var8 = var0.func_147439_a(var2, var3, var4);
        return var8 == null ? null : var8.func_149731_a(var0, var2, var3, var4, var5, var7);
    }

    public static Block getBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof ItemBlock ? ((ItemBlock)item).field_150939_a : null;
    }

    public static ItemStack copyWithSize(ItemStack stack, int size) {
        ItemStack ret = stack.func_77946_l();
        ret.field_77994_a = size;
        return ret;
    }

    public static Integer readToolMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = ModUtils.nbt(itemstack);
        int mode = nbttagcompound.func_74762_e("toolMode");
        if (mode <= 0 || mode > 5) {
            mode = 1;
        }
        return mode;
    }

    public static Integer readTextureIndex(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = ModUtils.nbt(itemstack);
        int textureIndex = nbttagcompound.func_74762_e("textureIndex");
        if (textureIndex <= 0) {
            textureIndex = 0;
        }
        return textureIndex;
    }

    public static void saveToolMode(ItemStack itemstack, Integer toolMode) {
        NBTTagCompound nbttagcompound = ModUtils.nbt(itemstack);
        nbttagcompound.func_74768_a("toolMode", toolMode.intValue());
        if (toolMode == 1) {
            nbttagcompound.func_74768_a("textureIndex", 0);
        }
        if (toolMode == 2) {
            nbttagcompound.func_74768_a("textureIndex", 1);
        }
        if (toolMode == 3) {
            nbttagcompound.func_74768_a("textureIndex", 2);
        }
        if (toolMode == 4) {
            nbttagcompound.func_74768_a("textureIndex", 3);
        }
        if (toolMode == 5) {
            nbttagcompound.func_74768_a("textureIndex", 4);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        if (!Keyboard.isKeyDown((int)42)) {
            par3List.add(StatCollector.func_74838_a((String)"press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            par3List.add(StatCollector.func_74838_a((String)"iu.changemode_key") + Keyboard.getKeyName((int)KeyboardClient.changemode.func_151463_i()) + StatCollector.func_74838_a((String)"iu.changemode_rcm"));
        }
    }

    public boolean canDischarge(ItemStack stack, int amount) {
        return ElectricItem.manager.discharge(stack, (double)amount, Integer.MAX_VALUE, true, false, true) == (double)amount;
    }

    public void dischargeItem(ItemStack stack, EntityPlayer player, int amount) {
        ElectricItem.manager.use(stack, (double)amount, (EntityLivingBase)player);
    }

    private boolean isShiftRotation(Class<? extends Block> clazz) {
        Class<? extends Block> shift;
        Iterator<Class<? extends Block>> iter = this.shiftRotations.iterator();
        do {
            if (iter.hasNext()) continue;
            return false;
        } while (!(shift = iter.next()).isAssignableFrom(clazz));
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (IC2.platform.isRendering() && IUCore.keyboard.isChangeKeyDown(player)) {
            IUCore.audioManager.playOnce(player, PositionSpec.Hand, "Tools/toolChange.ogg", true, IC2.audioManager.getDefaultVolume());
        }
        if (IUCore.isSimulating() && IUCore.keyboard.isChangeKeyDown(player)) {
            int mode = ItemGraviTool.readToolMode(stack);
            if (++mode > 5) {
                mode = 1;
            }
            ItemGraviTool.saveToolMode(stack, mode);
            ItemGraviTool.setToolName(stack);
            if (mode == 1) {
                CommonProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("iu.graviTool.snap.Hoe") + " " + EnumChatFormatting.GREEN + Helpers.formatMessage("iu.message.text.activated"));
            } else if (mode == 2) {
                CommonProxy.sendPlayerMessage(player, EnumChatFormatting.LIGHT_PURPLE + Helpers.formatMessage("iu.graviTool.snap.TreeTap") + " " + EnumChatFormatting.GREEN + Helpers.formatMessage("iu.message.text.activated"));
            } else if (mode == 3) {
                CommonProxy.sendPlayerMessage(player, EnumChatFormatting.AQUA + Helpers.formatMessage("iu.graviTool.snap.Wrench") + " " + EnumChatFormatting.GREEN + Helpers.formatMessage("iu.message.text.activated"));
            } else if (mode == 4) {
                CommonProxy.sendPlayerMessage(player, EnumChatFormatting.YELLOW + Helpers.formatMessage("iu.graviTool.snap.Screwdriver") + " " + EnumChatFormatting.GREEN + Helpers.formatMessage("iu.message.text.activated"));
            } else if (mode == 5) {
                CommonProxy.sendPlayerMessage(player, EnumChatFormatting.DARK_AQUA + Helpers.formatMessage("iu.graviTool.snap.Purifier") + " " + EnumChatFormatting.GREEN + Helpers.formatMessage("iu.message.text.activated"));
            }
        }
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float a, float b, float c) {
        ItemGraviTool.setToolName(stack);
        Integer mode = ItemGraviTool.readToolMode(stack);
        if (mode == 3) {
            return this.onWrenchUse(stack, player, world, x, y, z, side);
        }
        if (mode == 4) {
            return this.onScrewdriverUse(stack, player, world, x, y, z);
        }
        return false;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float a, float b, float c) {
        int mode = ItemGraviTool.readToolMode(stack);
        if (mode == 1) {
            return this.onHoeUse(stack, player, world, x, y, z, side);
        }
        if (mode == 2) {
            return this.onTreeTapUse(stack, player, world, x, y, z, side);
        }
        if (mode == 5) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (!(tile instanceof TileEntitySolarPanel)) {
                return false;
            }
            double energy = 10000.0;
            if (((TileEntitySolarPanel)tile).time > 0) {
                energy = 10000.0 / (double)(((TileEntitySolarPanel)tile).time / 20);
            }
            if (ElectricItem.manager.canUse(stack, energy)) {
                ((TileEntitySolarPanel)tile).time = 28800;
                ((TileEntitySolarPanel)tile).time1 = 14400;
                ((TileEntitySolarPanel)tile).time2 = 14400;
                ElectricItem.manager.use(stack, energy, (EntityLivingBase)player);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean onHoeUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        int energyPerHoe = 50;
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        if (!this.canDischarge(stack, energyPerHoe)) {
            CommonProxy.sendPlayerMessage(player, Helpers.formatMessage("message.text.noenergy"));
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            this.dischargeItem(stack, player, energyPerHoe);
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (side != 0 && world.func_147439_a(x, y + 1, z).isAir((IBlockAccess)world, x, y + 1, z) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
            Block farmland = Blocks.field_150458_ak;
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), farmland.field_149762_H.func_150498_e(), (farmland.field_149762_H.func_150497_c() + 1.0f) / 2.0f, farmland.field_149762_H.func_150494_d() * 0.8f);
            if (IUCore.isSimulating()) {
                this.dischargeItem(stack, player, energyPerHoe);
                world.func_147449_b(x, y, z, farmland);
            }
            return true;
        }
        return false;
    }

    public boolean onTreeTapUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y, z);
        if (Helpers.equals(block, IC2Items.getItem((String)"blockBarrel"))) {
            try {
                Method method = world.func_147438_o(x, y, z).getClass().getMethod("useTreetapOn", EntityPlayer.class, Integer.TYPE);
                return (Boolean)method.invoke(null, player, side);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (Helpers.equals(block, IC2Items.getItem((String)"rubberWood"))) {
            this.attemptExtract(stack, player, world, x, y, z, side, null);
            return true;
        }
        return false;
    }

    public boolean onWrenchUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        int energyPerSwitchSide = 50;
        if (this.canDischarge(stack, energyPerSwitchSide)) {
            Block block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof IWrenchable) {
                if (tile instanceof TileEntityTerra && ((TileEntityTerra)tile).ejectBlueprint()) {
                    if (IUCore.isSimulating()) {
                        this.dischargeItem(stack, player, energyPerSwitchSide);
                    }
                    return IUCore.isSimulating();
                }
                IWrenchable wrenchable = (IWrenchable)tile;
                if (IC2.keyboard.isAltKeyDown(player)) {
                    side = player.func_70093_af() ? (wrenchable.getFacing() + 5) % 6 : (wrenchable.getFacing() + 1) % 6;
                } else if (player.func_70093_af()) {
                    side += side % 2 * -2 + 1;
                }
                if (wrenchable.wrenchCanSetFacing(player, side)) {
                    if (IUCore.isSimulating()) {
                        wrenchable.setFacing((short)side);
                        this.dischargeItem(stack, player, energyPerSwitchSide);
                    }
                    if (IC2.platform.isRendering()) {
                        IC2.audioManager.playOnce((Object)player, ic2.core.audio.PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.getDefaultVolume());
                    }
                    return IUCore.isSimulating();
                }
                if (this.canDischarge(stack, this.energyPerWrenchStandartOperation) && wrenchable.wrenchCanRemove(player)) {
                    if (IUCore.isSimulating()) {
                        boolean dropOriginalBlock;
                        if (wrenchable.getWrenchDropRate() < 1.0f) {
                            int energyPerWrenchFineOperation = 10000;
                            if (!this.canDischarge(stack, energyPerWrenchFineOperation)) {
                                CommonProxy.sendPlayerMessage(player, Helpers.formatMessage("message.text.noenergy"));
                                return true;
                            }
                            dropOriginalBlock = true;
                            this.dischargeItem(stack, player, energyPerWrenchFineOperation);
                        } else {
                            dropOriginalBlock = world.field_73012_v.nextFloat() <= wrenchable.getWrenchDropRate();
                            this.dischargeItem(stack, player, this.energyPerWrenchStandartOperation);
                        }
                        ArrayList drops = block.getDrops(world, x, y, z, meta, 0);
                        if (dropOriginalBlock) {
                            if (drops.isEmpty()) {
                                drops.add(wrenchable.getWrenchDrop(player));
                            } else {
                                drops.set(0, wrenchable.getWrenchDrop(player));
                            }
                        }
                        for (ItemStack itemStack : drops) {
                            ItemGraviTool.dropAsEntity(world, x, y, z, itemStack);
                        }
                        world.func_147468_f(x, y, z);
                    }
                    if (IC2.platform.isRendering()) {
                        IC2.audioManager.playOnce((Object)player, ic2.core.audio.PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.getDefaultVolume());
                    }
                }
            }
            if (player.func_70093_af() == this.isShiftRotation(block.getClass())) {
                if (this.canDischarge(stack, this.energyPerWrenchStandartOperation)) {
                    if (block.rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
                        if (IUCore.isSimulating()) {
                            player.func_71038_i();
                            this.dischargeItem(stack, player, this.energyPerWrenchStandartOperation);
                        }
                        if (IC2.platform.isRendering()) {
                            IC2.audioManager.playOnce((Object)player, ic2.core.audio.PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.getDefaultVolume());
                        }
                        return true;
                    }
                } else {
                    CommonProxy.sendPlayerMessage(player, Helpers.formatMessage("message.text.noenergy"));
                }
            }
        }
        return false;
    }

    public void ejectHarz(World world, int x, int y, int z, int side, int quantity) {
        double ejectX = (double)x + 0.5;
        double ejectY = (double)y + 0.5;
        double ejectZ = (double)z + 0.5;
        if (side == 2) {
            ejectZ -= 0.3;
        } else if (side == 5) {
            ejectX += 0.3;
        } else if (side == 3) {
            ejectZ += 0.3;
        } else if (side == 4) {
            ejectX -= 0.3;
        }
        for (int i = 0; i < quantity; ++i) {
            EntityItem entityitem = new EntityItem(world, ejectX, ejectY, ejectZ, IC2Items.getItem((String)"resin").func_77946_l());
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public void attemptExtract(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, List<ItemStack> stacks) {
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 2 && meta % 6 == side) {
            int energyPerTreeTap = 50;
            if (meta < 6) {
                if (!this.canDischarge(stack, energyPerTreeTap)) {
                    CommonProxy.sendPlayerMessage(player, Helpers.formatMessage("message.text.noenergy"));
                } else if (IUCore.isSimulating()) {
                    world.func_72921_c(x, y, z, meta + 6, 3);
                    if (stacks != null) {
                        stacks.add(ItemGraviTool.copyWithSize(IC2Items.getItem((String)"resin"), world.field_73012_v.nextInt(3) + 1));
                    } else {
                        this.ejectHarz(world, x, y, z, side, world.field_73012_v.nextInt(3) + 1);
                    }
                    Block woodBlock = ItemGraviTool.getBlock(IC2Items.getItem((String)"rubberWood"));
                    if (woodBlock != null) {
                        world.func_147464_a(x, y, z, woodBlock, woodBlock.func_149738_a(world));
                    }
                    if (IC2.platform.isRendering() && player != null) {
                        IC2.audioManager.playOnce((Object)player, ic2.core.audio.PositionSpec.Hand, "Tools/Treetap.ogg", true, IC2.audioManager.getDefaultVolume());
                    }
                    this.dischargeItem(stack, player, energyPerTreeTap);
                }
            } else {
                if (world.field_73012_v.nextInt(5) == 0 && IUCore.isSimulating()) {
                    world.func_72921_c(x, y, z, 1, 3);
                }
                if (world.field_73012_v.nextInt(5) == 0) {
                    if (!this.canDischarge(stack, energyPerTreeTap)) {
                        CommonProxy.sendPlayerMessage(player, Helpers.formatMessage("message.text.noenergy"));
                    } else if (IUCore.isSimulating()) {
                        this.ejectHarz(world, x, y, z, side, 1);
                        if (stacks != null) {
                            stacks.add(ItemGraviTool.copyWithSize(IC2Items.getItem((String)"resin"), 1));
                        } else {
                            this.ejectHarz(world, x, y, z, side, 1);
                        }
                        if (IC2.platform.isRendering() && player != null) {
                            IC2.audioManager.playOnce((Object)player, ic2.core.audio.PositionSpec.Hand, "Tools/Treetap.ogg", true, IC2.audioManager.getDefaultVolume());
                        }
                        this.dischargeItem(stack, player, energyPerTreeTap);
                    }
                }
            }
        }
    }

    public boolean onScrewdriverUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        boolean isSneaking = player != null && player.func_70093_af();
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block != Blocks.field_150413_aR && block != Blocks.field_150416_aS) {
            if (block == Blocks.field_150367_z) {
                if (!this.canDischarge(stack, this.energyPerWrenchStandartOperation)) {
                    if (IUCore.isSimulating()) {
                        CommonProxy.sendPlayerMessage(player, Helpers.formatMessage("message.text.noenergy"));
                    }
                    return false;
                }
                if (!IUCore.isSimulating()) {
                    // empty if block
                }
                if (IUCore.isSimulating()) {
                    this.dischargeItem(stack, player, this.energyPerWrenchStandartOperation);
                }
                return IUCore.isSimulating();
            }
            if (block != Blocks.field_150331_J && block != Blocks.field_150320_F) {
                TileEntity tile = world.func_147438_o(x, y, z);
                if (tile instanceof IRotatable) {
                    if (!this.canDischarge(stack, this.energyPerWrenchStandartOperation)) {
                        if (IUCore.isSimulating()) {
                            CommonProxy.sendPlayerMessage(player, Helpers.formatMessage("message.text.noenergy"));
                        }
                        return false;
                    }
                    MovingObjectPosition mop = null;
                    if (player != null) {
                        mop = ItemGraviTool.retraceBlock(world, player, x, y, z);
                    }
                    if (mop == null) {
                        return false;
                    }
                    int maxRotation = ((IRotatable)tile).getPartMaxRotation(mop.subHit, isSneaking);
                    if (maxRotation == 0) {
                        return false;
                    }
                    int rotation = ((IRotatable)tile).getPartRotation(mop.subHit, isSneaking) + 1;
                    if (rotation > maxRotation) {
                        rotation = 0;
                    }
                    if (IUCore.isSimulating()) {
                        this.dischargeItem(stack, player, this.energyPerWrenchStandartOperation);
                        ((IRotatable)tile).setPartRotation(mop.subHit, isSneaking, rotation);
                    }
                    return IUCore.isSimulating();
                }
                return false;
            }
            ++meta;
            if (!this.canDischarge(stack, this.energyPerWrenchStandartOperation)) {
                if (IUCore.isSimulating()) {
                    CommonProxy.sendPlayerMessage(player, Helpers.formatMessage("message.text.noenergy"));
                }
                return false;
            }
            if (meta > 5) {
                meta = 0;
            }
            if (IUCore.isSimulating()) {
                this.dischargeItem(stack, player, this.energyPerWrenchStandartOperation);
                world.func_72921_c(x, y, z, meta, 7);
            }
            return IUCore.isSimulating();
        }
        if (!this.canDischarge(stack, this.energyPerWrenchStandartOperation)) {
            if (IUCore.isSimulating()) {
                CommonProxy.sendPlayerMessage(player, Helpers.formatMessage("message.text.noenergy"));
            }
            return false;
        }
        if (IUCore.isSimulating()) {
            this.dischargeItem(stack, player, this.energyPerWrenchStandartOperation);
            world.func_72921_c(x, y, z, meta & 0xC | meta + 1 & 3, 7);
        }
        return IUCore.isSimulating();
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return 300000.0;
    }

    public int getTier(ItemStack stack) {
        return 2;
    }

    public double getTransferLimit(ItemStack stack) {
        return 10000.0;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return false;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        ItemGraviTool.iconsList[0] = iconRegister.func_94245_a("industrialupgrade:" + this.name + "Hoe");
        ItemGraviTool.iconsList[1] = iconRegister.func_94245_a("industrialupgrade:" + this.name + "TreeTap");
        ItemGraviTool.iconsList[2] = iconRegister.func_94245_a("industrialupgrade:" + this.name + "Wrench");
        ItemGraviTool.iconsList[3] = iconRegister.func_94245_a("industrialupgrade:" + this.name + "Screwdriver");
        ItemGraviTool.iconsList[4] = iconRegister.func_94245_a("industrialupgrade:" + this.name + "Purifier");
        this.field_77791_bV = iconsList[0];
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int pass) {
        Integer myIndex = ItemGraviTool.readTextureIndex(itemStack);
        return iconsList[myIndex];
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public boolean canWrench(EntityPlayer paramEntityPlayer, int paramInt1, int paramInt2, int paramInt3) {
        ItemStack itemstack = paramEntityPlayer.field_71071_by.func_70448_g();
        Integer toolMode = ItemGraviTool.readToolMode(itemstack);
        if (toolMode == 3) {
            if (this.canDischarge(itemstack, this.energyPerWrenchStandartOperation)) {
                return true;
            }
            if (IC2.platform.isSimulating()) {
                IC2.platform.messagePlayer(paramEntityPlayer, Helpers.formatMessage("message.text.noenergy"), new Object[0]);
            }
            return false;
        }
        return false;
    }

    @Override
    public void wrenchUsed(EntityPlayer paramEntityPlayer, int paramInt1, int paramInt2, int paramInt3) {
        if (IC2.platform.isSimulating()) {
            ItemStack itemstack = paramEntityPlayer.field_71071_by.func_70448_g();
            this.dischargeItem(itemstack, paramEntityPlayer, this.energyPerWrenchStandartOperation);
        }
    }
}

