/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.item.energy;

import com.denfop.Config;
import com.denfop.IUCore;
import com.denfop.audio.PositionSpec;
import com.denfop.proxy.CommonProxy;
import com.denfop.utils.EnumInfoUpgradeModules;
import com.denfop.utils.Helpers;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import com.denfop.utils.NBTData;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.util.StackUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S18PacketEntityTeleport;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.lwjgl.input.Keyboard;

public class EnergyPickaxe
extends ItemTool
implements IElectricItem {
    public static final Set<Block> mineableBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150347_e, Blocks.field_150334_T, Blocks.field_150333_U, Blocks.field_150348_b, Blocks.field_150322_A, Blocks.field_150341_Y, Blocks.field_150366_p, Blocks.field_150339_S, Blocks.field_150365_q, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150482_ag, Blocks.field_150484_ah, Blocks.field_150432_aD, Blocks.field_150424_aL, Blocks.field_150369_x, Blocks.field_150368_y, Blocks.field_150450_ax, Blocks.field_150439_ay, Blocks.field_150448_aq, Blocks.field_150319_E, Blocks.field_150318_D, Blocks.field_150408_cc});
    private static final Set<Material> materials = Sets.newHashSet((Object[])new Material[]{Material.field_151573_f, Material.field_151574_g, Material.field_151576_e, Material.field_151592_s, Material.field_151588_w, Material.field_151598_x});
    private static final Set<String> toolType = ImmutableSet.of((Object)"pickaxe");
    public final String name;
    public final int efficienty;
    public final int lucky;
    private final float bigHolePower;
    private final float normalPower;
    private final int maxCharge;
    private final int tier;
    private final int energyPerOperation;
    private final int energyPerbigHolePowerOperation;
    private final int transferLimit;
    private IIcon[] textures;

    public EnergyPickaxe(Item.ToolMaterial toolMaterial, String name, int efficienty, int lucky, int transferlimit, int maxCharge, int tier, int normalPower, int bigHolesPower, int energyPerOperation, int energyPerbigHolePowerOperation) {
        super(0.0f, toolMaterial, new HashSet());
        this.func_77656_e(27);
        this.func_77637_a(IUCore.tabssp2);
        this.efficienty = efficienty;
        this.lucky = lucky;
        this.name = name;
        this.transferLimit = transferlimit;
        this.maxCharge = maxCharge;
        this.tier = tier;
        this.field_77864_a = this.normalPower = (float)normalPower;
        this.bigHolePower = bigHolesPower;
        this.energyPerOperation = energyPerOperation;
        this.energyPerbigHolePowerOperation = energyPerbigHolePowerOperation;
        this.func_77655_b(name);
        GameRegistry.registerItem((Item)this, (String)name);
    }

    public static int readToolMode(ItemStack itemstack) {
        NBTTagCompound nbt = NBTData.getOrCreateNbtData(itemstack);
        int toolMode = nbt.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode > 2) {
            toolMode = 0;
        }
        return toolMode;
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        double x = player.field_70165_t;
        double y = player.field_70163_u;
        double z = player.field_70161_v;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            y += 1.0;
        }
        Vec3 vec3 = Vec3.func_72443_a((double)x, (double)y, (double)z);
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        if (player instanceof EntityPlayerMP) {
            range = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c(range * (double)f7, range * (double)f6, range * (double)f8);
        return world.func_147447_a(vec3, vec31, par3, !par3, par3);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int slot, boolean par5) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        for (int i = 0; i < 4; ++i) {
            if (!nbtData.func_74779_i("mode_module" + i).equals("silk")) continue;
            Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
            enchantmentMap.put(Enchantment.field_77348_q.field_77352_x, 1);
            EnchantmentHelper.func_82782_a((Map)enchantmentMap, (ItemStack)itemStack);
            break;
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase damagee, EntityLivingBase damager) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return toolType;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return Items.field_151046_w.canHarvestBlock(block, stack) || Items.field_151046_w.func_150893_a(stack, block) > 1.0f || mineableBlocks.contains(block);
    }

    public float getDigSpeed(ItemStack tool, Block block, int meta) {
        NBTTagCompound nbt = ModUtils.nbt(tool);
        int energy = 0;
        int speed = 0;
        for (int i = 0; i < 4; ++i) {
            if (nbt.func_74779_i("mode_module" + i).equals("speed")) {
                ++speed;
            }
            if (!nbt.func_74779_i("mode_module" + i).equals("energy")) continue;
            ++energy;
        }
        energy = Math.min(energy, EnumInfoUpgradeModules.ENERGY.max);
        speed = Math.min(speed, EnumInfoUpgradeModules.EFFICIENCY.max);
        return !ElectricItem.manager.canUse(tool, (double)(this.energyPerOperation - (int)((double)this.energyPerOperation * 0.25 * (double)energy))) ? 1.0f : (this.canHarvestBlock(block, tool) ? this.field_77864_a + (float)((int)((double)this.field_77864_a * 0.2 * (double)speed)) : 1.0f);
    }

    public int getHarvestLevel(ItemStack stack, String toolType) {
        return !toolType.equals("pickaxe") ? super.getHarvestLevel(stack, toolType) : this.field_77862_b.func_77996_d();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.textures = new IIcon[2];
        this.textures[0] = iconRegister.func_94245_a("industrialupgrade:" + this.name);
        this.textures[1] = iconRegister.func_94245_a("industrialupgrade:" + this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int pass) {
        NBTTagCompound nbtData = NBTData.getOrCreateNbtData(itemStack);
        if (nbtData.func_74762_e("toolMode") >= 1) {
            return this.textures[1];
        }
        return this.textures[0];
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        Block block;
        if (EnergyPickaxe.readToolMode(stack) == 0) {
            World world = player.field_70170_p;
            Block block2 = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (block2 == null) {
                return super.onBlockStartBreak(stack, x, y, z, player);
            }
            MovingObjectPosition mop = EnergyPickaxe.raytraceFromEntity(world, (Entity)player, true, 4.5);
            NBTTagCompound nbt = ModUtils.nbt(stack);
            byte aoe = 0;
            for (int i = 0; i < 4; ++i) {
                if (!nbt.func_74779_i("mode_module" + i).equals("AOE_dig")) continue;
                aoe = (byte)(aoe + 1);
            }
            aoe = (byte)Math.min(aoe, EnumInfoUpgradeModules.AOE_DIG.max);
            return this.break_block(world, block2, meta, mop, aoe, player, x, y, z, stack);
        }
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int aoe = 0;
        for (int i = 0; i < 4; ++i) {
            if (!nbt.func_74779_i("mode_module" + i).equals("AOE_dig")) continue;
            aoe = (byte)(aoe + 1);
        }
        aoe = (byte)Math.min(aoe, EnumInfoUpgradeModules.AOE_DIG.max);
        if (EnergyPickaxe.readToolMode(stack) == 2) {
            World world = player.field_70170_p;
            block = world.func_147439_a(x, y, z);
            if (block == null) {
                return super.onBlockStartBreak(stack, x, y, z, player);
            }
            MovingObjectPosition mop = EnergyPickaxe.raytraceFromEntity(world, (Entity)player, true, 4.5);
            if (mop != null && (materials.contains(block.func_149688_o()) || block == Blocks.field_150418_aU)) {
                boolean silktouch = EnchantmentHelper.func_77502_d((EntityLivingBase)player);
                int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
                NBTTagCompound NBTTagCompound2 = stack.func_77978_p();
                NBTTagCompound2.func_74768_a("ore", 1);
                this.ore_break(world, x, y, z, player, silktouch, fortune, false, stack, block);
            }
        }
        if (EnergyPickaxe.readToolMode(stack) == 1) {
            World world = player.field_70170_p;
            block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (block == null) {
                return super.onBlockStartBreak(stack, x, y, z, player);
            }
            MovingObjectPosition mop = EnergyPickaxe.raytraceFromEntity(world, (Entity)player, true, 4.5);
            if (mop != null && (materials.contains(block.func_149688_o()) || block == Blocks.field_150418_aU)) {
                return this.break_block(world, block, meta, mop, (byte)(1 + aoe), player, x, y, z, stack);
            }
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    boolean break_block(World world, Block block, int meta, MovingObjectPosition mop, byte mode_item, EntityPlayer player, int x, int y, int z, ItemStack stack) {
        int localMeta;
        byte xRange = mode_item;
        byte yRange = mode_item;
        byte zRange = mode_item;
        switch (mop.field_72310_e) {
            case 0: 
            case 1: {
                yRange = 0;
                break;
            }
            case 2: 
            case 3: {
                zRange = 0;
                break;
            }
            case 4: 
            case 5: {
                xRange = 0;
            }
        }
        boolean lowPower = false;
        boolean silktouch = EnchantmentHelper.func_77502_d((EntityLivingBase)player);
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
        int Yy = yRange > 0 ? yRange - 1 : 0;
        NBTTagCompound nbt = ModUtils.nbt(stack);
        float energy = this.energy(stack);
        int dig_depth = 0;
        for (int i = 0; i < 4; ++i) {
            if (!nbt.func_74779_i("mode_module" + i).equals("dig_depth")) continue;
            dig_depth = (byte)(dig_depth + 1);
        }
        dig_depth = (byte)Math.min(dig_depth, EnumInfoUpgradeModules.DIG_DEPTH.max);
        zRange = zRange > 0 ? zRange : (byte)(zRange + dig_depth);
        xRange = xRange > 0 ? xRange : (byte)(xRange + dig_depth);
        nbt.func_74768_a("zRange", (int)zRange);
        nbt.func_74768_a("xRange", (int)xRange);
        nbt.func_74768_a("yRange", (int)yRange);
        boolean save = nbt.func_74767_n("save");
        if (!player.field_71075_bZ.field_75098_d) {
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                block7: for (int yPos = y - yRange + Yy; yPos <= y + yRange + Yy; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                        if (ElectricItem.manager.canUse(stack, (double)energy)) {
                            if (save && world.func_147438_o(xPos, yPos, zPos) != null) continue;
                            Block localBlock = world.func_147439_a(xPos, yPos, zPos);
                            if (localBlock != null && this.canHarvestBlock(localBlock, stack) && localBlock.func_149712_f(world, xPos, yPos, zPos) >= 0.0f && materials.contains(localBlock.func_149688_o())) {
                                int localMeta2 = world.func_72805_g(xPos, yPos, zPos);
                                if (localBlock.func_149712_f(world, xPos, yPos, zPos) > 0.0f) {
                                    this.func_150894_a(stack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                                }
                                if (silktouch) continue;
                                localBlock.func_149657_c(world, xPos, yPos, zPos, localBlock.getExpDrop((IBlockAccess)world, localMeta2, fortune));
                                continue;
                            }
                            if (!(localBlock.func_149712_f(world, xPos, yPos, zPos) > 0.0f) || !materials.contains(localBlock.func_149688_o())) continue;
                            return this.func_150894_a(stack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                        }
                        lowPower = true;
                        continue block7;
                    }
                }
            }
        } else if (ElectricItem.manager.canUse(stack, (double)energy)) {
            Block localBlock = world.func_147439_a(x, y, z);
            if (localBlock != null && this.canHarvestBlock(localBlock, stack) && localBlock.func_149712_f(world, x, y, z) >= 0.0f && (materials.contains(localBlock.func_149688_o()) || block == Blocks.field_150418_aU)) {
                localMeta = world.func_72805_g(x, y, z);
                if (localBlock.func_149712_f(world, x, y, z) > 0.0f) {
                    this.func_150894_a(stack, world, localBlock, x, y, z, (EntityLivingBase)player);
                }
                if (!silktouch) {
                    localBlock.func_149657_c(world, x, y, z, localBlock.getExpDrop((IBlockAccess)world, localMeta, fortune));
                }
            } else if (localBlock.func_149712_f(world, x, y, z) > 0.0f) {
                return this.func_150894_a(stack, world, localBlock, x, y, z, (EntityLivingBase)player);
            }
        }
        if (lowPower) {
            if (ElectricItem.manager.canUse(stack, (double)energy)) {
                Block localBlock = world.func_147439_a(x, y, z);
                if (localBlock != null && this.canHarvestBlock(localBlock, stack) && localBlock.func_149712_f(world, x, y, z) >= 0.0f && (materials.contains(localBlock.func_149688_o()) || block == Blocks.field_150418_aU)) {
                    localMeta = world.func_72805_g(x, y, z);
                    if (localBlock.func_149712_f(world, x, y, z) > 0.0f) {
                        this.func_150894_a(stack, world, localBlock, x, y, z, (EntityLivingBase)player);
                    }
                    if (!silktouch) {
                        localBlock.func_149657_c(world, x, y, z, localBlock.getExpDrop((IBlockAccess)world, localMeta, fortune));
                    }
                } else if (localBlock.func_149712_f(world, x, y, z) > 0.0f) {
                    return this.func_150894_a(stack, world, localBlock, x, y, z, (EntityLivingBase)player);
                }
            }
        } else if (!IUCore.isSimulating()) {
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
        }
        return true;
    }

    private void ore_break(World world, int x, int y, int z, EntityPlayer player, boolean silktouch, int fortune, boolean lowPower, ItemStack stack, Block block1) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int energy = 0;
        for (int i = 0; i < 4; ++i) {
            if (!nbt.func_74779_i("mode_module" + i).equals("energy")) continue;
            ++energy;
        }
        energy = Math.min(energy, EnumInfoUpgradeModules.ENERGY.max);
        for (int Xx = x - 1; Xx <= x + 1; ++Xx) {
            block2: for (int Yy = y - 1; Yy <= y + 1; ++Yy) {
                for (int Zz = z - 1; Zz <= z + 1; ++Zz) {
                    NBTTagCompound NBTTagCompound2 = stack.func_77978_p();
                    int ore = NBTTagCompound2.func_74762_e("ore");
                    if (ore >= 16) continue;
                    if (ElectricItem.manager.canUse(stack, (double)this.energyPerOperation - (double)this.energyPerOperation * 0.25 * (double)energy)) {
                        Block localBlock = world.func_147439_a(Xx, Yy, Zz);
                        if (!ModUtils.getore(localBlock, block1)) continue;
                        if (player.field_71075_bZ.field_75098_d) continue block2;
                        int localMeta = world.func_72805_g(Xx, Yy, Zz);
                        if (localBlock.func_149712_f(world, Xx, Yy, Zz) > 0.0f) {
                            this.func_150894_a(stack, world, localBlock, Xx, Yy, Zz, (EntityLivingBase)player);
                        }
                        if (!silktouch) {
                            localBlock.func_149657_c(world, Xx, Yy, Zz, localBlock.getExpDrop((IBlockAccess)world, localMeta, fortune));
                        }
                        NBTTagCompound2.func_74768_a("ore", ++ore);
                        this.ore_break(world, Xx, Yy, Zz, player, silktouch, fortune, lowPower, stack, block1);
                        world.func_147479_m(Xx, Yy, Zz);
                        continue;
                    }
                    lowPower = true;
                    continue block2;
                }
            }
        }
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int xPos, int yPos, int zPos, EntityLivingBase entity) {
        float energy;
        if (block == null) {
            return false;
        }
        if (world.func_147437_c(xPos, yPos, zPos)) {
            return false;
        }
        if (block.func_149688_o() instanceof MaterialLiquid || block.func_149712_f(world, xPos, yPos, xPos) == -1.0f && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return false;
        }
        int meta = world.func_72805_g(xPos, yPos, zPos);
        if (!world.field_72995_K) {
            block.func_149681_a(world, xPos, yPos, zPos, meta, (EntityPlayer)((EntityPlayerMP)entity));
            if (block.removedByPlayer(world, (EntityPlayer)((EntityPlayerMP)entity), xPos, yPos, zPos, true)) {
                block.func_149636_a(world, (EntityPlayer)((EntityPlayerMP)entity), xPos, yPos, zPos, meta);
                NBTTagCompound nbt = ModUtils.nbt(stack);
                int xMin = nbt.func_74762_e("xRange");
                int xMax = nbt.func_74762_e("xRange");
                int yMin = nbt.func_74762_e("yRange");
                int yMax = nbt.func_74762_e("yRange");
                int zMin = nbt.func_74762_e("zRange");
                int zMax = nbt.func_74762_e("zRange");
                List items = entity.field_70170_p.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(xPos - xMin), (double)(yPos - yMin), (double)(zPos - zMin), (double)(xPos + xMax + 1), (double)(yPos + yMax + 1), (double)(zPos + zMax + 1)));
                if (ModUtils.getore(block) || !Config.blacklist) {
                    for (EntityItem item : items) {
                        if (entity.field_70170_p.field_72995_K) continue;
                        item.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0f, 0.0f);
                        ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new S18PacketEntityTeleport((Entity)item));
                        item.field_145804_b = 0;
                    }
                } else {
                    for (EntityItem item : items) {
                        if (entity.field_70170_p.field_72995_K || !ModUtils.getore(item.func_92059_d().func_77973_b())) continue;
                        item.func_70106_y();
                    }
                }
                block.func_149664_b(world, xPos, yPos, zPos, meta);
                ((EntityPlayerMP)entity).func_71020_j(-0.025f);
            }
            ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)world.func_72912_H().func_76077_q(), (EntityPlayerMP)((EntityPlayerMP)entity), (int)xPos, (int)yPos, (int)zPos);
            EntityPlayerMP mpPlayer = (EntityPlayerMP)entity;
            mpPlayer.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(xPos, yPos, zPos, world));
        } else {
            if (block.removedByPlayer(world, (EntityPlayer)entity, xPos, yPos, zPos, true)) {
                block.func_149664_b(world, xPos, yPos, zPos, meta);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(2, xPos, yPos, zPos, Minecraft.func_71410_x().field_71476_x.field_72310_e));
        }
        if (entity != null && (energy = this.energy(stack)) != 0.0f && block.func_149712_f(world, xPos, yPos, zPos) != 0.0f) {
            ElectricItem.manager.use(stack, (double)energy, entity);
        }
        return true;
    }

    public float energy(ItemStack stack) {
        float energy;
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int energy1 = 0;
        for (int i = 0; i < 4; ++i) {
            if (!nbt.func_74779_i("mode_module" + i).equals("energy")) continue;
            ++energy1;
        }
        energy1 = Math.min(energy1, EnumInfoUpgradeModules.ENERGY.max);
        int toolMode = EnergyPickaxe.readToolMode(stack);
        switch (toolMode) {
            case 1: 
            case 2: {
                energy = (float)((double)this.energyPerbigHolePowerOperation - (double)this.energyPerbigHolePowerOperation * 0.25 * (double)energy1);
                break;
            }
            default: {
                energy = (float)((double)this.energyPerOperation - (double)this.energyPerOperation * 0.25 * (double)energy1);
            }
        }
        return energy;
    }

    public void saveToolMode(ItemStack itemstack, int toolMode) {
        NBTTagCompound nbt = NBTData.getOrCreateNbtData(itemstack);
        nbt.func_74768_a("toolMode", toolMode);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            Item item;
            ItemStack torchStack = player.field_71071_by.field_70462_a[i];
            if (torchStack == null || !torchStack.func_77977_a().toLowerCase().contains("torch") || !((item = torchStack.func_77973_b()) instanceof ItemBlock)) continue;
            int oldMeta = torchStack.func_77960_j();
            int oldSize = torchStack.field_77994_a;
            boolean result = torchStack.func_77943_a(player, world, x, y, z, side, xOffset, yOffset, zOffset);
            if (player.field_71075_bZ.field_75098_d) {
                torchStack.func_77964_b(oldMeta);
                torchStack.field_77994_a = oldSize;
            } else if (torchStack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)torchStack);
                player.field_71071_by.field_70462_a[i] = null;
            }
            if (!result) continue;
            return true;
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, xOffset, yOffset, zOffset);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (IUCore.keyboard.isSaveModeKeyDown(player)) {
            NBTTagCompound nbt = ModUtils.nbt(itemStack);
            boolean save = !nbt.func_74767_n("save");
            CommonProxy.sendPlayerMessage(player, EnumChatFormatting.GREEN + Helpers.formatMessage("message.savemode") + (save ? Helpers.formatMessage("message.allow") : Helpers.formatMessage("message.disallow")));
            nbt.func_74757_a("save", save);
        }
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            int toolMode = EnergyPickaxe.readToolMode(itemStack) + 1;
            if (IC2.platform.isRendering() && IUCore.keyboard.isChangeKeyDown(player)) {
                IUCore.audioManager.playOnce(player, PositionSpec.Hand, "Tools/toolChange.ogg", true, IC2.audioManager.getDefaultVolume());
            }
            if (toolMode > 2) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
            switch (toolMode) {
                case 0: {
                    CommonProxy.sendPlayerMessage(player, EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.ultDDrill.mode.normal"));
                    this.field_77864_a = this.normalPower;
                    enchantmentMap.put(Enchantment.field_77349_p.field_77352_x, this.efficienty);
                    enchantmentMap.put(Enchantment.field_77346_s.field_77352_x, this.lucky);
                    EnchantmentHelper.func_82782_a((Map)enchantmentMap, (ItemStack)itemStack);
                    break;
                }
                case 1: {
                    enchantmentMap.put(Enchantment.field_77349_p.field_77352_x, this.efficienty);
                    enchantmentMap.put(Enchantment.field_77346_s.field_77352_x, this.lucky);
                    EnchantmentHelper.func_82782_a((Map)enchantmentMap, (ItemStack)itemStack);
                    CommonProxy.sendPlayerMessage(player, EnumChatFormatting.DARK_PURPLE + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.ultDDrill.mode.bigHoles"));
                    this.field_77864_a = this.bigHolePower;
                    break;
                }
                case 2: {
                    CommonProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.ultDDrill.mode.pickaxe"));
                    this.field_77864_a = this.normalPower;
                }
            }
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        int toolMode = EnergyPickaxe.readToolMode(par1ItemStack);
        switch (toolMode) {
            case 0: {
                par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.ultDDrill.mode.normal"));
                par3List.add(Helpers.formatMessage("message.description.normal"));
                break;
            }
            case 1: {
                par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.ultDDrill.mode.bigHoles"));
                par3List.add(Helpers.formatMessage("message.description.bigHoles"));
                break;
            }
            case 2: {
                par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.ultDDrill.mode.pickaxe"));
                par3List.add(Helpers.formatMessage("message.description.pickaxe"));
            }
        }
        if (!Keyboard.isKeyDown((int)42)) {
            par3List.add(StatCollector.func_74838_a((String)"press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            par3List.add(StatCollector.func_74838_a((String)"iu.changemode_key") + Keyboard.getKeyName((int)KeyboardClient.changemode.func_151463_i()) + StatCollector.func_74838_a((String)"iu.changemode_rcm"));
            par3List.add(StatCollector.func_74838_a((String)"iu.savemode_key") + Keyboard.getKeyName((int)KeyboardClient.savemode.func_151463_i()) + StatCollector.func_74838_a((String)"iu.changemode_rcm"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subs) {
        ItemStack stack = new ItemStack((Item)this, 1);
        HashMap<Integer, Integer> enchantmentMap = new HashMap<Integer, Integer>();
        enchantmentMap.put(Enchantment.field_77349_p.field_77352_x, this.efficienty);
        enchantmentMap.put(Enchantment.field_77346_s.field_77352_x, this.lucky);
        EnchantmentHelper.func_82782_a(enchantmentMap, (ItemStack)stack);
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        subs.add(stack);
        ItemStack itemstack = new ItemStack((Item)this, 1, this.func_77612_l());
        EnchantmentHelper.func_82782_a(enchantmentMap, (ItemStack)itemstack);
        subs.add(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.uncommon;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }
}

