/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.item.armour;

import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.denfop.Config;
import com.denfop.IUCore;
import com.denfop.utils.EnumInfoUpgradeModules;
import com.denfop.utils.ModUtils;
import com.denfop.utils.NBTData;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.IC2Potion;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemSolarPanelHelmet
extends ItemArmor
implements IElectricItem,
IMetalArmor,
ISpecialArmor {
    protected static final Map<Integer, Integer> potionRemovalCost = new HashMap<Integer, Integer>();
    private final int solarType;
    private double maxCharge;
    private double transferLimit;
    private int tier;
    private double genDay;
    private double genNight;
    private int energyPerDamage;
    private double damageAbsorptionRatio;
    private double baseAbsorptionRatio;
    private boolean sunIsUp;
    private boolean skyIsVisible;
    private boolean ret = false;
    private double storage;
    private double maxstorage;

    public ItemSolarPanelHelmet(ItemArmor.ArmorMaterial par2EnumArmorMaterial, int par3, int par4, int htype, String name) {
        super(par2EnumArmorMaterial, par3, par4);
        this.solarType = htype;
        this.transferLimit = 3000.0;
        this.tier = 1;
        if (this.solarType == 1) {
            this.genDay = Config.advGenDay;
            this.genNight = this.genDay / 2.0;
            this.maxCharge = 1000000.0;
            this.energyPerDamage = 800;
            this.damageAbsorptionRatio = 0.9;
            this.baseAbsorptionRatio = 0.15;
            this.storage = 0.0;
            this.maxstorage = Config.advStorage / 2.0;
        }
        if (this.solarType == 2) {
            this.genDay = Config.hGenDay;
            this.genNight = this.genDay / 2.0;
            this.maxCharge = 1.0E7;
            this.transferLimit = 10000.0;
            this.tier = 2;
            this.energyPerDamage = 2000;
            this.damageAbsorptionRatio = 1.0;
            this.baseAbsorptionRatio = 0.15;
            this.storage = 0.0;
            this.maxstorage = Config.hStorage / 2.0;
        }
        if (this.solarType == 3) {
            this.genDay = Config.uhGenDay;
            this.genNight = this.genDay / 2.0;
            this.maxCharge = 1.0E7;
            this.transferLimit = 10000.0;
            this.tier = 3;
            this.energyPerDamage = 2000;
            this.damageAbsorptionRatio = 1.0;
            this.baseAbsorptionRatio = 0.15;
            this.storage = 0.0;
            this.maxstorage = Config.uhStorage / 2.0;
        }
        if (this.solarType == 4) {
            this.genDay = Config.spectralpanelGenDay;
            this.genNight = this.genDay / 2.0;
            this.transferLimit = 38000.0;
            this.maxCharge = Config.Storagequantumsuit;
            this.tier = 5;
            this.energyPerDamage = 5000;
            this.damageAbsorptionRatio = 0.9;
            this.baseAbsorptionRatio = 0.15;
            this.storage = 0.0;
            this.maxstorage = Config.spectralpanelstorage / 2.0;
        }
        if (this.solarType == 5) {
            this.genDay = Config.singularpanelGenDay;
            this.genNight = this.genDay / 2.0;
            this.transferLimit = 100000.0;
            this.maxCharge = Config.Storagequantumsuit;
            this.tier = 7;
            this.energyPerDamage = 10000;
            this.damageAbsorptionRatio = 1.0;
            this.baseAbsorptionRatio = 0.15;
            this.storage = 0.0;
            this.maxstorage = Config.singularpanelstorage / 2.0;
        }
        this.func_77637_a(IUCore.tabssp2);
        this.func_77656_e(27);
        potionRemovalCost.put(Potion.field_76436_u.field_76415_H, 100);
        potionRemovalCost.put(IC2Potion.radiation.field_76415_H, 20);
        potionRemovalCost.put(Potion.field_82731_v.field_76415_H, 100);
        potionRemovalCost.put(Potion.field_76438_s.field_76415_H, 200);
        this.func_77655_b(name);
        GameRegistry.registerItem((Item)this, (String)name);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        return IConfigurableItem.ProfileHelper.getBoolean((ItemStack)itemstack, (String)"GogglesOfRevealing", (boolean)true);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        return IConfigurableItem.ProfileHelper.getBoolean((ItemStack)itemstack, (String)"GogglesOfRevealing", (boolean)true);
    }

    private double experimental_generating(World world) {
        double k = 0.0;
        float angle = world.func_72826_c(1.0f) - 0.78469056f < 0.0f ? 0.21530944f : -0.78469056f;
        float celestialAngle = (world.func_72826_c(1.0f) + angle) * 360.0f;
        celestialAngle %= 360.0f;
        if ((celestialAngle += 12.0f) <= 90.0f) {
            k = celestialAngle / 90.0f;
        } else if (celestialAngle > 90.0f && celestialAngle < 180.0f) {
            k = 1.0f - (celestialAngle -= 90.0f) / 90.0f;
        } else if (celestialAngle > 180.0f && celestialAngle < 270.0f) {
            k = (celestialAngle -= 180.0f) / 90.0f;
        } else if (celestialAngle > 270.0f && celestialAngle < 360.0f) {
            k = 1.0f - (celestialAngle -= 270.0f) / 90.0f;
        }
        return k;
    }

    public void onArmorTick(World worldObj, EntityPlayer player, ItemStack itemStack) {
        double tempstorage;
        if (worldObj.field_72995_K) {
            return;
        }
        this.gainFuel(player);
        NBTTagCompound nbtData = NBTData.getOrCreateNbtData(itemStack);
        NBTTagCompound nbt = ModUtils.nbt(itemStack);
        int resistance = 0;
        int repaired = 0;
        for (int i = 0; i < 4; ++i) {
            if (nbtData.func_74779_i("mode_module" + i).equals("invisibility")) {
                player.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 300));
            }
            if (nbtData.func_74779_i("mode_module" + i).equals("resistance")) {
                ++resistance;
            }
            if (!nbtData.func_74779_i("mode_module" + i).equals("repaired")) continue;
            ++repaired;
        }
        if (repaired != 0 && worldObj.field_73011_w.getWorldTime() % 80L == 0L) {
            ElectricItem.manager.charge(itemStack, this.getMaxCharge(itemStack) * 1.0E-5 * (double)repaired, Integer.MAX_VALUE, true, false);
        }
        if (resistance != 0) {
            player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 300, resistance));
        }
        int genday = 0;
        int gennight = 0;
        int storage = 0;
        for (int i = 0; i < 4; ++i) {
            if (nbt.func_74779_i("mode_module" + i).equals("genday")) {
                ++genday;
            }
            if (nbt.func_74779_i("mode_module" + i).equals("gennight")) {
                ++gennight;
            }
            if (!nbt.func_74779_i("mode_module" + i).equals("storage")) continue;
            ++storage;
        }
        genday = Math.min(genday, EnumInfoUpgradeModules.GENDAY.max);
        gennight = Math.min(gennight, EnumInfoUpgradeModules.GENNIGHT.max);
        storage = Math.min(storage, EnumInfoUpgradeModules.STORAGE.max);
        double k = this.experimental_generating(worldObj);
        if (this.sunIsUp && this.skyIsVisible) {
            this.storage = nbtData.func_74769_h("storage");
            this.storage += (this.genDay + this.genDay * 0.05 * (double)genday) * k;
            nbtData.func_74780_a("storage", this.storage);
        }
        if (this.skyIsVisible) {
            this.storage = nbtData.func_74769_h("storage");
            this.storage += (this.genNight + this.genNight * 0.05 * (double)gennight) * k;
            nbtData.func_74780_a("storage", this.storage);
        }
        if (nbtData.func_74769_h("storage") >= this.maxstorage + this.maxstorage * 0.05 * (double)storage) {
            nbtData.func_74780_a("storage", this.maxstorage + this.maxstorage * 0.05 * (double)storage);
        }
        if (nbtData.func_74769_h("storage") < 0.0) {
            nbtData.func_74780_a("storage", 0.0);
        }
        for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
            int id = effect.func_76456_a();
            Integer cost = potionRemovalCost.get(id);
            if (cost == null || !ElectricItem.manager.canUse(itemStack, (double)(cost = Integer.valueOf(cost * (effect.func_76458_c() + 1))).intValue())) continue;
            ElectricItem.manager.use(itemStack, (double)cost.intValue(), null);
            IC2.platform.removePotion((EntityLivingBase)player, id);
            this.ret = true;
        }
        if (ElectricItem.manager.canUse(itemStack, 1000.0) && player.func_71024_bL().func_75121_c()) {
            int slot = -1;
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                if (player.field_71071_by.field_70462_a[i] == null || !(player.field_71071_by.field_70462_a[i].func_77973_b() instanceof ItemFood)) continue;
                slot = i;
                break;
            }
            if (slot > -1) {
                ItemStack stack = player.field_71071_by.field_70462_a[slot];
                ItemFood can = (ItemFood)stack.func_77973_b();
                stack = can.func_77654_b(stack, worldObj, player);
                if (stack.field_77994_a <= 0) {
                    player.field_71071_by.field_70462_a[slot] = null;
                }
                ElectricItem.manager.use(itemStack, 1000.0, null);
                this.ret = true;
            }
        } else if (player.func_71024_bL().func_75116_a() <= 0) {
            IC2.achievements.issueAchievement(player, "starveWithQHelmet");
        }
        if (this.solarType == 2 || this.solarType == 3) {
            int airLevel = player.func_70086_ai();
            if (ElectricItem.manager.canUse(itemStack, 1000.0) && airLevel < 100) {
                player.func_70050_g(airLevel + 200);
                ElectricItem.manager.use(itemStack, 1000.0, null);
            }
        }
        if ((tempstorage = nbtData.func_74769_h("storage")) > 0.0) {
            double sentPacket;
            double energyLeft = tempstorage;
            for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                if (energyLeft > 0.0) {
                    if (player.field_71071_by.field_70460_b[i] == null || !(player.field_71071_by.field_70460_b[i].func_77973_b() instanceof IElectricItem) || !((sentPacket = ElectricItem.manager.charge(player.field_71071_by.field_70460_b[i], energyLeft, Integer.MAX_VALUE, true, false)) > 0.0)) continue;
                    nbtData.func_74780_a("storage", energyLeft -= sentPacket);
                    this.ret = true;
                    continue;
                }
                return;
            }
            for (int j = 0; j < player.field_71071_by.field_70462_a.length; ++j) {
                if (energyLeft > 0.0) {
                    if (player.field_71071_by.field_70462_a[j] == null || !(player.field_71071_by.field_70462_a[j].func_77973_b() instanceof IElectricItem) || !((sentPacket = ElectricItem.manager.charge(player.field_71071_by.field_70462_a[j], energyLeft, Integer.MAX_VALUE, true, false)) > 0.0)) continue;
                    nbtData.func_74780_a("storage", energyLeft -= sentPacket);
                    this.ret = true;
                    continue;
                }
                return;
            }
        }
        if (this.ret) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public void gainFuel(EntityPlayer player) {
        if (player.field_70170_p.field_73011_w.getWorldTime() % 128L == 0L) {
            this.updateVisibility(player);
        }
    }

    public void updateVisibility(EntityPlayer player) {
        boolean wetBiome = player.field_70170_p.func_72959_q().func_76935_a((int)player.field_70165_t, (int)player.field_70161_v).func_76744_g() > 0;
        boolean noSunWorld = player.field_70170_p.field_73011_w.field_76576_e;
        boolean rainWeather = wetBiome && (player.field_70170_p.func_72896_J() || player.field_70170_p.func_72911_I());
        this.sunIsUp = player.field_70170_p.func_72935_r() && !rainWeather;
        this.skyIsVisible = player.field_70170_p.func_72937_j((int)player.field_70165_t, (int)player.field_70163_u + 1, (int)player.field_70161_v) && !noSunWorld;
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        NBTTagCompound nbt = ModUtils.nbt(armor);
        int protect = 0;
        for (int i = 0; i < 4; ++i) {
            if (!nbt.func_74779_i("mode_module" + i).equals("protect")) continue;
            ++protect;
        }
        protect = Math.min(protect, EnumInfoUpgradeModules.PROTECTION.max);
        int energyPerDamage = (int)((double)this.getEnergyPerDamage() - (double)this.getEnergyPerDamage() * 0.2 * (double)protect);
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage()) {
            return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int protect = 0;
        for (int i = 0; i < 4; ++i) {
            if (!nbt.func_74779_i("mode_module" + i).equals("protect")) continue;
            ++protect;
        }
        protect = Math.min(protect, EnumInfoUpgradeModules.PROTECTION.max);
        ElectricItem.manager.discharge(stack, (double)damage * ((double)this.getEnergyPerDamage() - (double)this.getEnergyPerDamage() * 0.2 * (double)protect), Integer.MAX_VALUE, true, false, false);
    }

    public int getEnergyPerDamage() {
        return this.energyPerDamage;
    }

    public double getDamageAbsorptionRatio() {
        return this.damageAbsorptionRatio;
    }

    private double getBaseAbsorptionRatio() {
        return this.baseAbsorptionRatio;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister IIconRegister2) {
        if (this.solarType == 1) {
            this.field_77791_bV = IIconRegister2.func_94245_a("industrialupgrade:AdvSolarHelmet");
        }
        if (this.solarType == 2) {
            this.field_77791_bV = IIconRegister2.func_94245_a("industrialupgrade:HybridSolarHelmet");
        }
        if (this.solarType == 3) {
            this.field_77791_bV = IIconRegister2.func_94245_a("industrialupgrade:UltimateSolarHelmet");
        }
        if (this.solarType == 4) {
            this.field_77791_bV = IIconRegister2.func_94245_a("industrialupgrade:spsolarhelmet");
        }
        if (this.solarType == 5) {
            this.field_77791_bV = IIconRegister2.func_94245_a("industrialupgrade:sssolarhelmet");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (this.solarType == 1) {
            return "industrialupgrade:textures/armor/advancedSolarHelmet.png";
        }
        if (this.solarType == 2) {
            return "industrialupgrade:textures/armor/hybridSolarHelmet.png";
        }
        if (this.solarType == 3) {
            return "industrialupgrade:textures/armor/ultimateSolarHelmet.png";
        }
        if (this.solarType == 4) {
            return "industrialupgrade:textures/armor/spectralsolarhelmet.png";
        }
        if (this.solarType == 5) {
            return "industrialupgrade:textures/armor/singularsolarhelmetoverlay.png";
        }
        return "";
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        NBTTagCompound nbtData1 = NBTData.getOrCreateNbtData(itemStack);
        info.add(StatCollector.func_74838_a((String)"iu.storage.helmet") + " " + ModUtils.getString(nbtData1.func_74769_h("storage")) + " EU");
    }
}

