/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.item.armour;

import com.denfop.IUCore;
import com.denfop.IUItem;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemAdvJetpack
extends ItemArmor
implements IElectricItem,
ISpecialArmor,
IMetalArmor {
    protected static AudioSource audioSource;
    private static boolean lastJetpackUsed;
    private final String armorName;
    private final int maxStorage;
    private final int TransferLimit;
    private final int tier;

    public ItemAdvJetpack(String internalName, int maxStorage, int TransferLimit, int tier) {
        super(ItemArmor.ArmorMaterial.DIAMOND, IC2.platform.addArmor(internalName), 1);
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b(internalName);
        this.armorName = internalName;
        this.func_77637_a(IUCore.tabssp2);
        this.func_77625_d(1);
        this.maxStorage = maxStorage;
        this.TransferLimit = TransferLimit;
        this.tier = tier;
        GameRegistry.registerItem((Item)this, (String)internalName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        String name = this.func_77658_a();
        if (name == null || name.length() > 4) {
            // empty if block
        }
        this.field_77791_bV = iconRegister.func_94245_a("industrialupgrade:" + name);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        int suffix = this.field_77881_a == 2 ? 2 : 1;
        return "industrialupgrade:textures/armor/" + this.armorName + "_" + suffix + ".png";
    }

    public String func_77658_a() {
        return super.func_77658_a().substring(5);
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack itemStack) {
        return StatCollector.func_74838_a((String)(this.func_77667_c(itemStack) + ".name"));
    }

    public double getCharge(ItemStack itemStack) {
        return ElectricItem.manager.getCharge(itemStack);
    }

    public void use(ItemStack itemStack, double amount) {
        ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, false);
    }

    public boolean useJetpack(EntityPlayer player, boolean hoverMode) {
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if (this.getCharge(jetpack) <= 0.0) {
            return false;
        }
        boolean electric = jetpack.func_77973_b() != Ic2Items.jetpack.func_77973_b();
        float power = 1.0f;
        float dropPercentage = 0.2f;
        if (electric) {
            power = 0.7f;
            dropPercentage = 0.05f;
        }
        if (this.getCharge(jetpack) / this.getMaxCharge(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (this.getCharge(jetpack) / (this.getMaxCharge(jetpack) * (double)dropPercentage)));
        }
        if (IC2.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster = 0.15f;
            if (hoverMode) {
                retruster = 1.0f;
            }
            if (electric) {
                retruster += 0.15f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
            }
        }
        int worldHeight = IC2.getWorldHeight((World)player.field_70170_p);
        double y = player.field_70163_u;
        int maxFlightHeight = electric ? (int)((float)worldHeight / 1.28f) : worldHeight;
        if (y > (double)(maxFlightHeight - 25)) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power = (float)((double)power * (((double)maxFlightHeight - y) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = 0.0f;
            if (IC2.keyboard.isJumpKeyDown(player)) {
                maxHoverY = electric ? 0.1f : 0.2f;
            }
            if (IC2.keyboard.isSneakKeyDown(player)) {
                maxHoverY = electric ? -0.1f : -0.2f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        int consume = 2;
        if (hoverMode) {
            consume = 1;
        }
        if (electric) {
            consume += 6;
        }
        if (!player.field_70122_E) {
            this.use(jetpack, consume);
        }
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxStorage;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.TransferLimit;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (player.field_71071_by.field_70460_b[2] == itemStack) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
            boolean hoverMode = nbtData.func_74767_n("hoverMode");
            byte toggleTimer = nbtData.func_74771_c("toggleTimer");
            boolean jetpackUsed = false;
            if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
                toggleTimer = 10;
                boolean bl = hoverMode = !hoverMode;
                if (IC2.platform.isSimulating()) {
                    nbtData.func_74757_a("hoverMode", hoverMode);
                    if (hoverMode) {
                        IC2.platform.messagePlayer(player, "Hover Mode enabled.", new Object[0]);
                    } else {
                        IC2.platform.messagePlayer(player, "Hover Mode disabled.", new Object[0]);
                    }
                }
            }
            if (nbtData.func_74767_n("jetpack") && ElectricItem.manager.canUse(itemStack, 10.0) && !player.field_70122_E) {
                ElectricItem.manager.use(itemStack, 10.0, null);
            }
            boolean jetpack = nbtData.func_74767_n("jetpack");
            if ((IC2.keyboard.isJumpKeyDown(player) || hoverMode) && !jetpack) {
                jetpackUsed = this.useJetpack(player, hoverMode);
            }
            if (IUCore.keyboard.isFlyModeKeyDown(player) && toggleTimer == 0 && itemStack.func_77973_b().equals(IUItem.perjetpack)) {
                toggleTimer = 10;
                boolean bl = jetpack = !jetpack;
                if (IC2.platform.isSimulating()) {
                    nbtData.func_74757_a("jetpack", jetpack);
                    if (jetpack) {
                        IC2.platform.messagePlayer(player, "Creative jetpack enabled.", new Object[0]);
                        player.field_71075_bZ.field_75100_b = true;
                        player.field_71075_bZ.field_75101_c = true;
                        player.field_70143_R = 0.0f;
                        player.field_70140_Q = 0.0f;
                    } else {
                        IC2.platform.messagePlayer(player, "Creative jetpack disabled.", new Object[0]);
                    }
                }
            }
            if (IC2.platform.isSimulating() && toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
                nbtData.func_74774_a("toggleTimer", toggleTimer);
            }
            if (IC2.platform.isRendering() && player == IC2.platform.getPlayerInstance()) {
                if (lastJetpackUsed != jetpackUsed) {
                    if (jetpackUsed) {
                        if (audioSource == null) {
                            audioSource = IC2.audioManager.createSource((Object)player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                        }
                        if (audioSource != null) {
                            audioSource.play();
                        }
                    } else if (audioSource != null) {
                        audioSource.remove();
                        audioSource = null;
                    }
                    lastJetpackUsed = jetpackUsed;
                }
                if (audioSource != null) {
                    audioSource.updatePosition();
                }
            }
            if (jetpackUsed) {
                player.field_71069_bz.func_75142_b();
            }
        }
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    static {
        lastJetpackUsed = false;
    }
}

