/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.IUItem;
import com.denfop.item.modules.ItemWirelessModule;
import com.denfop.item.modules.QuarryModule;
import com.denfop.tiles.mechanism.TileEntityBaseQuantumQuarry;
import com.denfop.utils.ModUtils;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class InvSlotAnalyzer
extends InvSlot {
    private final int type;
    private int stackSizeLimit;

    public InvSlotAnalyzer(TileEntityInventory base1, int oldStartIndex1, String name, int count, int type) {
        super(base1, name, oldStartIndex1, InvSlot.Access.IO, count, InvSlot.InvSide.TOP);
        this.type = type;
        this.stackSizeLimit = 1;
    }

    public boolean accepts(ItemStack itemStack) {
        if (this.type == 0) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == null || this.get(i).func_77960_j() != itemStack.func_77960_j() || this.get(i).func_77973_b() != itemStack.func_77973_b() || !(itemStack.func_77973_b() instanceof QuarryModule)) continue;
                return false;
            }
            return itemStack.func_77973_b() instanceof QuarryModule || itemStack.func_77973_b().equals(IUItem.quarrymodule) || itemStack.func_77973_b() instanceof ItemWirelessModule;
        }
        if (this.type == 1) {
            int id = OreDictionary.getOreID((ItemStack)itemStack);
            String name = OreDictionary.getOreName((int)id);
            return name.startsWith("ore");
        }
        return false;
    }

    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    public boolean quarry() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == null || !this.get(i).func_77973_b().equals(IUItem.quarrymodule)) continue;
            return true;
        }
        return false;
    }

    public int lucky() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == null || !(this.get(i).func_77973_b() instanceof QuarryModule) || this.get(i).func_77960_j() < 6 || this.get(i).func_77960_j() >= 9) continue;
            return this.get(i).func_77960_j() - 5;
        }
        return 0;
    }

    public boolean getFurnaceModule() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == null || !(this.get(i).func_77973_b() instanceof QuarryModule) || this.get(i).func_77960_j() != 0) continue;
            return true;
        }
        return false;
    }

    public List<String> getblacklist() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == null || this.get(i).func_77960_j() != 12) continue;
            for (int j = 0; j < 9; ++j) {
                String l = "number_" + j;
                String temp = ModUtils.NBTGetString(this.get(i), l);
                if (!temp.startsWith("ore") && !temp.startsWith("gem") && !temp.startsWith("dust") && !temp.startsWith("shard")) continue;
                list.add(temp);
            }
        }
        return list;
    }

    public List<String> getwhitelist() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == null || this.get(i).func_77960_j() != 13) continue;
            for (int j = 0; j < 9; ++j) {
                String l = "number_" + j;
                String temp = ModUtils.NBTGetString(this.get(i), l);
                if (!temp.startsWith("ore") && !temp.startsWith("gem") && !temp.startsWith("dust") && !temp.startsWith("shard")) continue;
                list.add(temp);
            }
            break;
        }
        return list;
    }

    public boolean CheckBlackList(List<String> list, String name) {
        if (list.isEmpty()) {
            return false;
        }
        return !list.contains(name);
    }

    public boolean CheckWhiteList(List<String> list, String name) {
        if (list.isEmpty()) {
            return true;
        }
        return list.contains(name);
    }

    public int getChunksize() {
        int size = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == null || !(this.get(i).func_77973_b() instanceof QuarryModule) || this.get(i).func_77960_j() <= 8 || this.get(i).func_77960_j() > 11) continue;
            size = this.get(i).func_77960_j() - 8;
            return size;
        }
        return size;
    }

    public boolean getwirelessmodule() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == null || !(this.get(i).func_77973_b() instanceof ItemWirelessModule)) continue;
            return true;
        }
        return false;
    }

    public List wirelessmodule() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == null || !(this.get(i).func_77973_b() instanceof ItemWirelessModule)) continue;
            NBTTagCompound nbttagcompound = ModUtils.nbt(this.get(i));
            int x = nbttagcompound.func_74762_e("Xcoord");
            int y = nbttagcompound.func_74762_e("Ycoord");
            int z = nbttagcompound.func_74762_e("Zcoord");
            if (x == 0 || y == 0 || z == 0) break;
            list.add(x);
            list.add(y);
            list.add(z);
            break;
        }
        return list;
    }

    public double getenergycost(TileEntityBaseQuantumQuarry target1) {
        double energy = target1.energyconsume;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == null || !(this.get(i).func_77973_b() instanceof QuarryModule) || this.get(i).func_77960_j() <= 0 || this.get(i).func_77960_j() >= 6) continue;
            double proccent = this.get(i).func_77960_j();
            proccent *= 0.05;
            proccent *= energy;
            proccent = energy - proccent;
            return proccent;
        }
        return energy;
    }

    public double getenergycost() {
        double energy = 25000.0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == null || !(this.get(i).func_77973_b() instanceof QuarryModule) || this.get(i).func_77960_j() <= 0 || this.get(i).func_77960_j() >= 6) continue;
            double proccent = this.get(i).func_77960_j();
            proccent *= 0.05;
            proccent *= energy;
            proccent = energy - proccent;
            return proccent;
        }
        return energy;
    }
}

