/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.thaumcraft;

import com.denfop.Config;
import com.denfop.container.ContainerAspectGenerator;
import com.denfop.gui.GUIAspectGenerator;
import com.denfop.integration.thaumcraft.ThaumSlot;
import com.denfop.tiles.base.TileEntityElectricMachine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.aspects.IEssentiaTransport;

public class TileEntityAspectGenerator
extends TileEntityElectricMachine
implements IAspectSource,
IEssentiaTransport,
IHasGui {
    public final ThaumSlot inputSlot = new ThaumSlot(this);
    public final int cost = Config.cost_aspect;
    public final int maxAmount = 640;
    public int amount = 0;
    public Aspect aspect = null;
    public Aspect aspectFilter = null;

    public TileEntityAspectGenerator() {
        super(100000.0, 14, -1);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.aspect = Aspect.getAspect((String)nbttagcompound.func_74779_i("Aspect"));
        this.aspectFilter = Aspect.getAspect((String)nbttagcompound.func_74779_i("AspectFilter"));
        this.amount = nbttagcompound.func_74765_d("Amount");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        if (this.aspect != null) {
            nbttagcompound.func_74778_a("Aspect", this.aspect.getTag());
        }
        if (this.aspectFilter != null) {
            nbttagcompound.func_74778_a("AspectFilter", this.aspectFilter.getTag());
        }
        nbttagcompound.func_74777_a("Amount", (short)this.amount);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.aspect == null) {
            this.amount = 0;
        }
        if (!this.inputSlot.isEmpty()) {
            IEssentiaContainerItem item = (IEssentiaContainerItem)this.inputSlot.get().func_77973_b();
            this.aspect = item.getAspects(this.inputSlot.get()).getAspects()[0];
        } else {
            this.aspect = null;
        }
        if (this.amount < this.maxAmount) {
            this.fillJar();
        }
        if (this.energy >= (double)this.cost && this.amount < 640) {
            ++this.amount;
            this.energy -= (double)this.cost;
        }
    }

    void fillJar() {
        TileEntity te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ForgeDirection)ForgeDirection.UP);
        if (te != null) {
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (!ic.canOutputTo(ForgeDirection.DOWN)) {
                return;
            }
            Aspect ta = null;
            if (this.aspectFilter != null) {
                ta = this.aspectFilter;
            } else if (this.aspect != null && this.amount > 0) {
                ta = this.aspect;
            } else if (ic.getEssentiaAmount(ForgeDirection.DOWN) > 0 && ic.getSuctionAmount(ForgeDirection.DOWN) < this.getSuctionAmount(ForgeDirection.UP) && this.getSuctionAmount(ForgeDirection.UP) >= ic.getMinimumSuction()) {
                ta = ic.getEssentiaType(ForgeDirection.DOWN);
            }
            if (ta != null && ic.getSuctionAmount(ForgeDirection.DOWN) < this.getSuctionAmount(ForgeDirection.UP)) {
                this.addToContainer(ta, ic.takeEssentia(ta, 1, ForgeDirection.DOWN));
            }
        }
    }

    public String func_145825_b() {
        return null;
    }

    public AspectList getAspects() {
        AspectList al = new AspectList();
        if (this.aspect != null && this.amount > 0) {
            al.add(this.aspect, this.amount);
        }
        return al;
    }

    public void setAspects(AspectList aspectList) {
    }

    public Aspect getEssentiaType(ForgeDirection loc) {
        return this.aspect;
    }

    public int getEssentiaAmount(ForgeDirection loc) {
        return this.amount;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amt) {
        return this.amount >= amt && tag == this.aspect;
    }

    public boolean doesContainerContain(AspectList ot) {
        Aspect[] arr$;
        for (Aspect tt : arr$ = ot.getAspects()) {
            if (this.amount <= 0 || tt != this.aspect) continue;
            return true;
        }
        return false;
    }

    public int containerContains(Aspect tag) {
        return 0;
    }

    public boolean doesContainerAccept(Aspect tag) {
        return this.aspectFilter == null || tag.equals(this.aspectFilter);
    }

    public boolean isConnectable(ForgeDirection face) {
        return face == ForgeDirection.UP;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return face == ForgeDirection.UP;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return face == ForgeDirection.UP;
    }

    public int addToContainer(Aspect aspect, int i) {
        return i;
    }

    public Aspect getSuctionType(ForgeDirection loc) {
        return this.aspectFilter != null ? this.aspectFilter : this.aspect;
    }

    public int getSuctionAmount(ForgeDirection loc) {
        if (this.amount < this.maxAmount) {
            return this.aspectFilter != null ? 64 : 32;
        }
        return 0;
    }

    public boolean takeFromContainer(Aspect tt, int am) {
        if (this.amount >= am && tt == this.aspect) {
            this.amount -= am;
            if (this.amount <= 0) {
                this.aspect = null;
                this.amount = 0;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.canOutputTo(face) && this.takeFromContainer(aspect, amount) ? amount : 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.canInputFrom(face) ? amount - this.addToContainer(aspect, amount) : 0;
    }

    public void setSuction(Aspect aspect, int i) {
    }

    public int getMinimumSuction() {
        return this.aspectFilter != null ? 64 : 32;
    }

    public boolean renderExtendedTube() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUIAspectGenerator(new ContainerAspectGenerator<TileEntityAspectGenerator>(entityPlayer, this));
    }

    public ContainerBase<? extends TileEntityAspectGenerator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerAspectGenerator<TileEntityAspectGenerator>(entityPlayer, this);
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }
}

