/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.denfop.api.Recipes;
import com.denfop.block.base.BlocksItems;
import com.denfop.gui.GUINeutronGenerator;
import com.denfop.item.ItemCell;
import com.denfop.utils.ModUtils;
import ic2.core.util.DrawUtil;
import ic2.core.util.GuiTooltipHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.opengl.GL11;

public class NEINeutronGenerator
extends TemplateRecipeHandler {
    int ticks;

    public Class<? extends GuiContainer> getGuiClass() {
        return GUINeutronGenerator.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"iu.blockMatter.name");
    }

    public String getRecipeId() {
        return "iu.genneutron";
    }

    public String getGuiTexture() {
        return "industrialupgrade:textures/gui/NeutronGeneratorGUI.png";
    }

    public String getOverlayIdentifier() {
        return "genlava";
    }

    public Map<NBTTagCompound, FluidStack> getRecipeList() {
        return Recipes.neutroniumgenrator.getRecipes();
    }

    private void drawLiquid(FluidStack stack) {
        IIcon fluidIcon = new ItemStack(stack.getFluid().getBlock()).func_77954_c();
        GuiDraw.renderEngine.func_110577_a(TextureMap.field_110575_b);
        int liquidHeight = (int)((float)stack.amount / 8000.0f * 47.0f);
        DrawUtil.drawRepeated((IIcon)fluidIcon, (double)95.0, (double)(68 - liquidHeight), (double)12.0, (double)liquidHeight, (double)GuiDraw.gui.getZLevel());
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)95, (int)23, (int)176, (int)57, (int)12, (int)46);
    }

    private void drawLiquidTooltip(FluidStack stack, int recipe) {
        GuiRecipe gui = (GuiRecipe)Minecraft.func_71410_x().field_71462_r;
        Point mouse = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        String tooltip = stack.getLocalizedName() + " (" + stack.amount + "mb)";
        GuiTooltipHelper.drawAreaTooltip((int)(mouse.x - (gui.field_146294_l - 176) / 2 - offset.x), (int)(mouse.y - (gui.field_146295_m - 176) / 2 - offset.y), (String)tooltip, (int)95, (int)21, (int)107, (int)68);
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)5, (int)140, (int)75);
        GeneratorRecipe recipe = (GeneratorRecipe)((Object)this.arecipes.get(i));
        this.drawLiquid(recipe.output);
        GuiDraw.drawString((String)(StatCollector.func_74838_a((String)"cost.name") + " " + ModUtils.getString(recipe.tag.func_74769_h("amount")) + "EU"), (int)10, (int)30, (int)0x404040);
    }

    public void drawExtras(int i) {
        float f = this.ticks <= 20 ? (float)this.ticks / 20.0f : 1.0f;
        this.drawProgressBar(34, 64, 177, 104, 29, 9, f, 0);
        GeneratorRecipe recipe = (GeneratorRecipe)((Object)this.arecipes.get(i));
        this.drawLiquidTooltip(recipe.output, i);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<NBTTagCompound, FluidStack> entry : this.getRecipeList().entrySet()) {
                this.arecipes.add(new GeneratorRecipe(entry.getKey(), entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack stack = null;
        if (result.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)result.func_77973_b();
            stack = container.getFluid(result);
        } else if (result.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)result.func_77973_b()) instanceof BlockFluidBase) {
            stack = new FluidStack(((BlockFluidBase)Block.func_149634_a((Item)result.func_77973_b())).getFluid(), 1000);
        } else if (result.func_77973_b() instanceof ItemCell && result.func_77960_j() == 1) {
            stack = new FluidStack(BlocksItems.getFluid("fluidNeutron"), 1000);
        }
        if (stack != null && stack.getFluid() != null) {
            stack = new FluidStack(BlocksItems.getFluid("fluidNeutron"), 1000);
            for (Map.Entry<NBTTagCompound, FluidStack> inputEntry : this.getRecipeList().entrySet()) {
                if (!stack.isFluidEqual(inputEntry.getValue())) continue;
                this.arecipes.add(new GeneratorRecipe(inputEntry.getKey(), inputEntry.getValue()));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
    }

    public class GeneratorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final FluidStack output;
        public final List<PositionedStack> ingredients;
        public final NBTTagCompound tag;

        public GeneratorRecipe(NBTTagCompound tag, FluidStack output1) {
            super((TemplateRecipeHandler)NEINeutronGenerator.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.output = output1;
            this.tag = tag;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEINeutronGenerator.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

