/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.denfop.utils.ModUtils;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.util.StackUtil;
import ic2.neiIntegration.core.PositionedStackIc2;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public abstract class MolecularRecipeHandler
extends TemplateRecipeHandler {
    protected int ticks;

    public abstract String getRecipeName();

    public abstract String getRecipeId();

    public abstract String getGuiTexture();

    public abstract String getOverlayIdentifier();

    public abstract Map<IRecipeInput, RecipeOutput> getRecipeList();

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)140, (int)65);
    }

    public void drawExtras(int i) {
        float f = this.ticks >= 20 ? (float)((this.ticks - 20) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(23, 26, 221, 7, 25, 20, f, 1);
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(i));
        String energyPerTick = I18n.func_135052_a((String)"gui.MolecularTransformer.energyPerOperation", (Object[])new Object[0]) + ": ";
        String input2 = I18n.func_135052_a((String)"gui.MolecularTransformer.input", (Object[])new Object[0]) + ": ";
        String output2 = I18n.func_135052_a((String)"gui.MolecularTransformer.output", (Object[])new Object[0]) + ": ";
        GuiDraw.drawString((String)(energyPerTick + ModUtils.getString(recipe.meta.func_74769_h("energy")) + " EU"), (int)55, (int)36, (int)0xCDCDCD);
        GuiDraw.drawString((String)(input2 + recipe.getIngredients().get((int)0).item.func_82833_r()), (int)55, (int)14, (int)0xCDCDCD);
        GuiDraw.drawString((String)(output2 + recipe.getResult().item.func_82833_r()), (int)55, (int)25, (int)0xCDCDCD);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.getRecipeList().entrySet()) {
                this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            for (ItemStack output : entry.getValue().items) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output, (ItemStack)result)) continue;
                this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            if (!entry.getKey().matches(ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
        }
    }

    protected int getInputPosX() {
        return 20;
    }

    protected int getInputPosY() {
        return 5;
    }

    protected int getOutputPosX() {
        return 20;
    }

    protected int getOutputPosY() {
        return 46;
    }

    protected boolean isOutputsVertical() {
        return true;
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        final NBTTagCompound meta;
        private final List<PositionedStack> ingredients;
        private final PositionedStack output;
        private final List<PositionedStack> otherStacks;

        public CachedIORecipe(IRecipeInput input, RecipeOutput output1) {
            super((TemplateRecipeHandler)MolecularRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.otherStacks = new ArrayList<PositionedStack>();
            if (input == null) {
                throw new NullPointerException("Input must not be null (recipe " + input + " -> " + output1 + ").");
            }
            if (output1.items.isEmpty()) {
                throw new IllegalArgumentException("Output must not be empty (recipe " + input + " -> " + output1 + ").");
            }
            if (output1.items.contains(null)) {
                throw new IllegalArgumentException("Output must not contain null (recipe " + input + " -> " + output1 + ").");
            }
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (ItemStack item : input.getInputs()) {
                items.add(StackUtil.copyWithSize((ItemStack)item, (int)input.getAmount()));
            }
            this.ingredients.add((PositionedStack)new PositionedStackIc2(items, MolecularRecipeHandler.this.getInputPosX(), MolecularRecipeHandler.this.getInputPosY()));
            this.output = new PositionedStackIc2(output1.items.get(0), MolecularRecipeHandler.this.getOutputPosX(), MolecularRecipeHandler.this.getOutputPosY());
            for (int i = 1; i < output1.items.size(); ++i) {
                if (MolecularRecipeHandler.this.isOutputsVertical()) {
                    this.otherStacks.add(new PositionedStack(output1.items.get(i), MolecularRecipeHandler.this.getOutputPosX(), MolecularRecipeHandler.this.getOutputPosY() + i * 18));
                    continue;
                }
                this.otherStacks.add(new PositionedStack(output1.items.get(i), MolecularRecipeHandler.this.getOutputPosX() + i * 18, MolecularRecipeHandler.this.getOutputPosY()));
            }
            this.meta = output1.metadata;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(MolecularRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.otherStacks;
        }
    }
}

