/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.de;

import com.brandon3055.draconicevolution.client.render.IRenderTweak;
import com.brandon3055.draconicevolution.common.handler.BalanceConfigHandler;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.IUpgradableItem;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import com.denfop.IUCore;
import com.denfop.integration.de.DraconicIntegration;
import com.denfop.integration.de.MiningTool;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ChaosShovel
extends MiningTool
implements IInventoryTool,
IRenderTweak {
    public ChaosShovel() {
        super(DraconicIntegration.CHAOS);
        this.setHarvestLevel("shovel", 15);
        this.func_77655_b("ChaosShovel");
        this.setCapacity((int)((double)BalanceConfigHandler.draconicToolsBaseStorage * 1.5));
        this.setMaxExtract(BalanceConfigHandler.draconicToolsMaxTransfer);
        this.setMaxReceive(BalanceConfigHandler.draconicToolsMaxTransfer);
        this.energyPerOperation = BalanceConfigHandler.draconicToolsEnergyPerAction;
        DraconicIntegration.register(this);
        this.func_77637_a(IUCore.tabssp2);
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        List<ItemConfigField> list = super.getFields(stack, slot);
        list.add(new ItemConfigField(2, slot, "ToolDigAOE").setMinMaxAndIncromente((Object)0, (Object)IUpgradableItem.EnumUpgrade.DIG_AOE.getUpgradePoints(stack), (Object)1).readFromItem(stack, (Object)0).setModifier("AOE"));
        list.add(new ItemConfigField(2, slot, "ToolDigDepth").setMinMaxAndIncromente((Object)1, (Object)IUpgradableItem.EnumUpgrade.DIG_DEPTH.getUpgradePoints(stack), (Object)1).readFromItem(stack, (Object)1));
        list.add(new ItemConfigField(6, slot, "ToolVoidJunk").readFromItem(stack, (Object)Boolean.FALSE));
        return list;
    }

    @Override
    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return true;
    }

    public String getInventoryName() {
        return StatCollector.func_74838_a((String)"info.de.toolInventoryOblit.txt");
    }

    public int getInventorySlots() {
        return 9;
    }

    public boolean isEnchantValid(Enchantment enchant) {
        return enchant.field_77351_y == EnumEnchantmentType.digger;
    }

    public void tweakRender(IItemRenderer.ItemRenderType type) {
        GL11.glTranslated((double)0.15, (double)0.9, (double)-0.12);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)140.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glScaled((double)0.7, (double)0.7, (double)0.7);
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)0.0, (double)-0.4, (double)0.0);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-1.45, (double)0.0, (double)-0.15);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glRotatef((float)-90.5f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-0.38, (double)0.0, (double)-0.6);
        }
    }

    public int getUpgradeCap(ItemStack itemstack) {
        return BalanceConfigHandler.draconicToolsMaxUpgrades;
    }

    public int getMaxTier(ItemStack itemstack) {
        return 3;
    }

    @Override
    public List<String> getUpgradeStats(ItemStack stack) {
        return super.getUpgradeStats(stack);
    }

    @Override
    public int getCapacity(ItemStack stack) {
        int points = IUpgradableItem.EnumUpgrade.RF_CAPACITY.getUpgradePoints(stack);
        return (int)((double)BalanceConfigHandler.draconicToolsBaseStorage * 1.5 + (double)(points * BalanceConfigHandler.draconicToolsStoragePerUpgrade));
    }

    public int getMaxUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.RF_CAPACITY.index) {
            return BalanceConfigHandler.draconicToolsMaxCapacityUpgradePoints;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_AOE.index) {
            return 11;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_DEPTH.index) {
            return 9;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_SPEED.index) {
            return 64;
        }
        return BalanceConfigHandler.draconicToolsMaxUpgradePoints;
    }

    @Override
    public List<IUpgradableItem.EnumUpgrade> getUpgrades(ItemStack itemstack) {
        List<IUpgradableItem.EnumUpgrade> list = super.getUpgrades(itemstack);
        list.add(IUpgradableItem.EnumUpgrade.DIG_SPEED);
        list.add(IUpgradableItem.EnumUpgrade.DIG_DEPTH);
        list.add(IUpgradableItem.EnumUpgrade.DIG_AOE);
        list.add(IUpgradableItem.EnumUpgrade.RF_CAPACITY);
        return list;
    }

    public int getBaseUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_AOE.index) {
            return 7;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_DEPTH.index) {
            return 5;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_SPEED.index) {
            return 32;
        }
        return 0;
    }
}

