/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.crafttweaker;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IMachineRecipeManagerExt;
import ic2.api.recipe.IRecipeInput;
import java.util.Arrays;
import java.util.Objects;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MachineAddRecipeAction
extends OneWayAction {
    private final String name;
    private final IMachineRecipeManager machine;
    private final ItemStack[] output;
    private final IRecipeInput input;
    private final NBTTagCompound tag;

    public MachineAddRecipeAction(String name, IMachineRecipeManager machine, ItemStack[] output, NBTTagCompound tag, IRecipeInput input) {
        this.name = name;
        this.machine = machine;
        this.output = output;
        this.input = input;
        this.tag = tag;
    }

    public void apply() {
        try {
            if (this.machine instanceof IMachineRecipeManagerExt) {
                ((IMachineRecipeManagerExt)this.machine).addRecipe(this.input, this.tag, true, this.output);
            } else {
                this.machine.addRecipe(this.input, this.tag, this.output);
            }
        }
        catch (RuntimeException var2) {
            MineTweakerAPI.logError((String)var2.getMessage());
        }
    }

    public String describe() {
        if (this.output.length == 1) {
            return "Adding " + this.name + " recipe for " + this.output[0].func_82833_r();
        }
        StringBuilder result = new StringBuilder();
        result.append("Adding ").append(this.name).append(" recipe for ");
        result.append("[");
        for (int i = 0; i < this.output.length; ++i) {
            if (i == 0) {
                result.append(", ");
                continue;
            }
            result.append(this.output[i].func_82833_r());
        }
        result.append("]");
        return result.toString();
    }

    public Object getOverrideKey() {
        return null;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 47 * hash + (this.machine != null ? this.machine.hashCode() : 0);
        hash = 47 * hash + Arrays.deepHashCode(this.output);
        hash = 47 * hash + (this.input != null ? this.input.hashCode() : 0);
        hash = 47 * hash + (this.tag != null ? this.tag.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MachineAddRecipeAction other = (MachineAddRecipeAction)((Object)obj);
        if (!(this.name == null ? other.name == null : this.name.equals(other.name))) {
            return false;
        }
        if (Objects.equals(this.machine, other.machine)) {
            if (!Arrays.deepEquals(this.output, other.output)) {
                return false;
            }
            if (Objects.equals(this.input, other.input)) {
                return Objects.equals(this.tag, other.tag);
            }
            return false;
        }
        return false;
    }
}

