/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.crafttweaker;

import com.denfop.api.Recipes;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mods.ic2.IC2RecipeInput;
import modtweaker2.helpers.InputHelper;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.industrialupgrade.MolecularTransformer")
public class CTMolecularTransformer {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient ingredient, double energy) {
        if (ingredient.getAmount() < 0) {
            MineTweakerAPI.logWarning((String)("invalid ingredient: " + ingredient + " - stack size not known"));
        } else {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("energy", energy);
            MineTweakerAPI.apply((IUndoableAction)new AddMolecularAction(ingredient, new ItemStack[]{CTMolecularTransformer.getItemStack(output)}, tag, false));
        }
    }

    @ZenMethod
    public static void addOreRecipe(IItemStack output, IIngredient ingredient, double energy) {
        if (ingredient.getAmount() < 0) {
            MineTweakerAPI.logWarning((String)("invalid ingredient: " + ingredient + " - stack size not known"));
        } else {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("energy", energy);
            MineTweakerAPI.apply((IUndoableAction)new AddMolecularAction(ingredient, new ItemStack[]{CTMolecularTransformer.getItemStack(output)}, tag, true));
        }
    }

    public static ItemStack getItemStack(IItemStack item) {
        if (item == null) {
            return null;
        }
        Object internal = item.getInternal();
        if (!(internal instanceof ItemStack)) {
            MineTweakerAPI.logError((String)("Not a valid item stack: " + item));
        }
        return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        LinkedHashMap<IRecipeInput, RecipeOutput> recipes = new LinkedHashMap<IRecipeInput, RecipeOutput>();
        for (Map.Entry iRecipeInputRecipeOutputEntry : Recipes.molecular.getRecipes().entrySet()) {
            for (ItemStack stack : ((RecipeOutput)iRecipeInputRecipeOutputEntry.getValue()).items) {
                if (!stack.func_77969_a(InputHelper.toStack((IItemStack)output))) continue;
                recipes.put((IRecipeInput)iRecipeInputRecipeOutputEntry.getKey(), (RecipeOutput)iRecipeInputRecipeOutputEntry.getValue());
            }
        }
        MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
    }

    @ZenMethod
    public static IItemStack[] getOutput(IItemStack input) {
        RecipeOutput output = Recipes.molecular.getOutputFor(MineTweakerMC.getItemStack((IItemStack)input), false);
        if (output == null || output.items.isEmpty()) {
            return null;
        }
        return MineTweakerMC.getIItemStacks((List)output.items);
    }

    private static class Remove
    extends BaseMapRemoval<IRecipeInput, RecipeOutput> {
        protected Remove(Map<IRecipeInput, RecipeOutput> recipes) {
            super("MolecularTransformer", Recipes.molecular.getRecipes(), recipes);
        }

        protected String getRecipeInfo(Map.Entry<IRecipeInput, RecipeOutput> recipe) {
            return recipe.toString();
        }
    }

    private static class AddMolecularAction
    extends OneWayAction {
        private final IIngredient ingredient;
        private final NBTTagCompound tag;
        private final ItemStack[] output;
        private final boolean oreDictionary;

        public AddMolecularAction(IIngredient ingredient, ItemStack[] output, NBTTagCompound tag, boolean oreDictionary) {
            this.ingredient = ingredient;
            this.tag = tag;
            this.output = output;
            this.oreDictionary = oreDictionary;
        }

        public static ItemStack getItemStack(IItemStack item) {
            if (item == null) {
                return null;
            }
            Object internal = item.getInternal();
            if (!(internal instanceof ItemStack)) {
                MineTweakerAPI.logError((String)("Not a valid item stack: " + item));
            }
            return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
        }

        public void apply() {
            ItemStack stack = (ItemStack)new IC2RecipeInput(this.ingredient).getInputs().get(0);
            String ore = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)stack));
            if (this.oreDictionary) {
                Recipes.molecular.addRecipe((IRecipeInput)(OreDictionary.getOres((String)ore).isEmpty() ? new IC2RecipeInput(this.ingredient) : new RecipeInputOreDict(ore)), this.tag, true, this.output);
            } else {
                Recipes.molecular.addRecipe((IRecipeInput)new IC2RecipeInput(this.ingredient), this.tag, true, this.output);
            }
        }

        public String describe() {
            return "Adding moleculaqr recipe " + this.ingredient + " + " + this.tag + " => " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.ingredient != null ? this.ingredient.hashCode() : 0);
            hash = 67 * hash + (this.tag != null ? this.tag.hashCode() : 0);
            hash = 67 * hash + (this.output != null ? Arrays.hashCode(this.output) : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddMolecularAction other = (AddMolecularAction)((Object)obj);
            if (!Objects.equals(this.ingredient, other.ingredient)) {
                return false;
            }
            if (!Objects.equals(this.tag, other.tag)) {
                return false;
            }
            return Arrays.equals(this.output, other.output);
        }
    }
}

