/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUCore;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.WorldData;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.world.World;

public class TickHandlerIU {
    private static final boolean debugTickCallback = System.getProperty("ic2.debugtickcallback") != null;
    private static final Map<ITickCallback, Throwable> debugTraces = debugTickCallback ? new WeakHashMap() : null;

    private static void processTickCallbacks(World world) {
        WorldData worldData = WorldData.get((World)world);
        IC2.platform.profilerStartSection("SingleTickCallback");
        ITickCallback tickCallback = (ITickCallback)worldData.singleTickCallbacks.poll();
        while (tickCallback != null) {
            if (debugTickCallback) {
                debugTraces.remove(tickCallback);
            }
            IC2.platform.profilerStartSection(tickCallback.getClass().getName());
            tickCallback.tickCallback(world);
            IC2.platform.profilerEndSection();
            tickCallback = (ITickCallback)worldData.singleTickCallbacks.poll();
        }
        IC2.platform.profilerEndStartSection("ContTickCallback");
        worldData.continuousTickCallbacksInUse = true;
        for (ITickCallback tickCallback2 : worldData.continuousTickCallbacks) {
            if (debugTickCallback) {
                debugTraces.remove(tickCallback2);
            }
            IC2.platform.profilerStartSection(tickCallback2.getClass().getName());
            tickCallback2.tickCallback(world);
            IC2.platform.profilerEndSection();
        }
        worldData.continuousTickCallbacksInUse = false;
        if (debugTickCallback) {
            // empty if block
        }
        worldData.continuousTickCallbacks.addAll(worldData.continuousTickCallbacksToAdd);
        worldData.continuousTickCallbacksToAdd.clear();
        worldData.continuousTickCallbacksToRemove.forEach(worldData.continuousTickCallbacks::remove);
        worldData.continuousTickCallbacksToRemove.clear();
        IC2.platform.profilerEndSection();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            IUCore.proxy.profilerStartSection("Keyboard");
            IUCore.keyboard.sendKeyUpdate();
            IUCore.proxy.profilerEndStartSection("AudioManager");
            IUCore.audioManager.onTick();
            IUCore.proxy.profilerEndStartSection("TickCallbacks");
            if (IC2.platform.getPlayerInstance() != null && IC2.platform.getPlayerInstance().field_70170_p != null) {
                TickHandlerIU.processTickCallbacks(IC2.platform.getPlayerInstance().field_70170_p);
            }
            IUCore.proxy.profilerEndSection();
        }
    }
}

