/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.entity.EntityStreak;
import com.denfop.utils.StreakLocation;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class EventDarkQuantumSuitEffect {
    private static final Map<String, ArrayList<StreakLocation>> playerLoc = new HashMap<String, ArrayList<StreakLocation>>();
    private static final HashMap<String, EntityStreak> streaks = new HashMap();
    private WorldClient worldInstance;

    public static ArrayList<StreakLocation> getPlayerStreakLocationInfo(EntityPlayer player) {
        ArrayList loc = playerLoc.computeIfAbsent(player.func_70005_c_(), k -> new ArrayList());
        if (loc.size() < 20) {
            for (int i = 0; i < 20 - loc.size(); ++i) {
                loc.add(0, new StreakLocation(player));
            }
        } else if (loc.size() > 20) {
            loc.remove(0);
        }
        return loc;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Iterator<Map.Entry<String, EntityStreak>> iterator = streaks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, EntityStreak> e = iterator.next();
                EntityStreak streak = e.getValue();
                if (streak.parent == null) continue;
                if (streak.parent.field_70128_L) {
                    streak.func_70106_y();
                    iterator.remove();
                    continue;
                }
                this.updatePos(streak);
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.ClientTickEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (event.phase == TickEvent.Phase.END && world != null) {
            if (this.worldInstance != world) {
                this.worldInstance = world;
                streaks.clear();
            }
            Iterator<Map.Entry<String, EntityStreak>> ite = streaks.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, EntityStreak> e = ite.next();
                EntityStreak streak = e.getValue();
                if (streak.field_70170_p.field_73011_w.field_76574_g == world.field_73011_w.field_76574_g && world.func_72820_D() - streak.lastUpdate <= 10L) continue;
                streak.func_70106_y();
                ite.remove();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END) {
            EntityPlayer player = event.player;
            Minecraft mc = Minecraft.func_71410_x();
            if (player.field_70170_p.func_72924_a(player.func_70005_c_()) != player) {
                return;
            }
            WorldClient world = mc.field_71441_e;
            EntityStreak hat = streaks.get(player.func_70005_c_());
            if (hat == null || hat.field_70128_L) {
                if (player.func_70005_c_().equalsIgnoreCase(mc.field_71439_g.func_70005_c_())) {
                    for (Map.Entry<String, EntityStreak> e : streaks.entrySet()) {
                        e.getValue().func_70106_y();
                    }
                }
                hat = new EntityStreak((World)world, (EntityLivingBase)player);
                streaks.put(player.func_70005_c_(), hat);
                world.func_72838_d((Entity)hat);
            }
            ArrayList<StreakLocation> loc = EventDarkQuantumSuitEffect.getPlayerStreakLocationInfo(player);
            StreakLocation oldest = loc.get(0);
            loc.remove(0);
            loc.add(oldest);
            oldest.update(player);
            StreakLocation newest = loc.get(loc.size() - 2);
            double distX = newest.posX - oldest.posX;
            double distZ = newest.posZ - oldest.posZ;
            newest.startU += Math.sqrt(distX * distX + distZ * distZ) / (double)newest.height;
            while (oldest.startU > 1.0) {
                oldest.startU -= 1.0;
            }
        }
    }

    private void updatePos(EntityStreak streak) {
        streak.field_70142_S = streak.parent.field_70142_S;
        streak.field_70137_T = streak.parent.field_70137_T;
        streak.field_70136_U = streak.parent.field_70136_U;
        streak.field_70169_q = streak.parent.field_70169_q;
        streak.field_70167_r = streak.parent.field_70167_r;
        streak.field_70166_s = streak.parent.field_70166_s;
        streak.field_70165_t = streak.parent.field_70165_t;
        streak.field_70163_u = streak.parent.field_70163_u;
        streak.field_70161_v = streak.parent.field_70161_v;
    }
}

