/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.block.cable;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.tiles.base.TileEntityCable;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.event.RetextureEvent;
import ic2.api.tile.IWrenchable;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.BlockTextureStitched;
import ic2.core.block.TileEntityBlock;
import ic2.core.item.tool.ItemToolCutter;
import ic2.core.util.AabbUtil;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockCable
extends Block {
    private static final int[][] facingAndSideToSpriteOffset = new int[][]{{3, 5, 1, 0, 4, 2}, {5, 3, 1, 0, 2, 4}, {0, 1, 3, 5, 4, 2}, {0, 1, 5, 3, 2, 4}, {0, 1, 2, 4, 3, 5}, {0, 1, 4, 2, 5, 3}};
    private static final Class<?>[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjArray = new Object[0];
    private static final ArrayDeque<TileEntity> tesBeforeBreak = new ArrayDeque(8);
    public int colorMultiplier = -1;
    public int renderMask;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[][] textures;

    public BlockCable() {
        super(Material.field_151573_f);
        this.func_149711_c(0.2f);
        this.renderMask = 63;
        this.func_149672_a(field_149775_l);
        MinecraftForge.EVENT_BUS.register((Object)this);
        GameRegistry.registerBlock((Block)this, (String)"blockCable");
        GameRegistry.registerItem((Item)IUItem.cable, (String)"cable");
    }

    public static int getTextureSubIndex(int facing, int side) {
        return facingAndSideToSpriteOffset[facing][side];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        int metaCount = this.getMetaCount();
        this.textures = new IIcon[metaCount][12];
        for (int index = 0; index < metaCount; ++index) {
            String name = "industrialupgrade:" + this.getTextureName(index);
            for (int active = 0; active < 2; ++active) {
                for (int side = 0; side < 6; ++side) {
                    int subIndex = active * 6 + side;
                    String subName = name + ":" + subIndex;
                    BlockTextureStitched texture = new BlockTextureStitched(subName, subIndex);
                    this.textures[index][subIndex] = texture;
                    ((TextureMap)iconRegister).setTextureEntry(subName, (TextureAtlasSprite)texture);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int facing = this.getFacing();
        int index = this.getTextureIndex(meta);
        int subIndex = BlockCable.getTextureSubIndex(facing, side);
        if (index >= this.textures.length) {
            return null;
        }
        try {
            return this.textures[index][subIndex];
        }
        catch (Exception e) {
            IC2.platform.displayError(e, "Side: " + side + "\nBlock: " + (Object)((Object)this) + "\nMeta: " + meta + "\nFacing: " + facing + "\nIndex: " + index + "\nSubIndex: " + subIndex, new Object[0]);
            return null;
        }
    }

    public String func_149739_a() {
        return super.func_149739_a().substring(5);
    }

    protected int getFacing() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public void onRender(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity te = this.getOwnTe(blockAccess, x, y, z);
        if (te instanceof TileEntityBlock) {
            ((TileEntityBlock)te).onRender();
        }
    }

    public int getFacing(IBlockAccess iBlockAccess, int x, int y, int z) {
        TileEntity te = this.getOwnTe(iBlockAccess, x, y, z);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getFacing();
        }
        return this.getFacing();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if ((this.renderMask & 1 << side) != 0) {
            return super.func_149646_a(blockAccess, x, y, z, side);
        }
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    protected int getTextureIndex(int meta) {
        return meta;
    }

    protected int getMetaCount() {
        int metaCount = 0;
        while (this.getTextureName(metaCount) != null) {
            ++metaCount;
        }
        return metaCount;
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        TileEntity te = this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te instanceof TileEntityBlock) {
            TileEntityBlock teb = (TileEntityBlock)te;
            teb.onBlockBreak((Block)this, meta);
            teb.onUnloaded();
        }
        if (te != null) {
            if (te instanceof IHasGui) {
                for (Object obj : world.field_73010_i) {
                    if (!(obj instanceof EntityPlayerMP)) continue;
                    EntityPlayerMP player = (EntityPlayerMP)obj;
                    if (!(player.field_71070_bA instanceof ContainerBase)) continue;
                    ContainerBase container = (ContainerBase)player.field_71070_bA;
                    if (container.base != te) continue;
                    player.func_71053_j();
                }
            }
            if (tesBeforeBreak.size() >= 8) {
                tesBeforeBreak.pop();
            }
            tesBeforeBreak.push(te);
        }
    }

    public final boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public TileEntity getOwnTe(IBlockAccess blockAccess, int x, int y, int z) {
        Class<?> actualClass;
        int meta;
        Block block;
        if (blockAccess instanceof World) {
            Chunk chunk = Util.getLoadedChunk((World)((World)blockAccess), (int)(x >> 4), (int)(z >> 4));
            if (chunk == null) {
                return null;
            }
            block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
            meta = chunk.func_76628_c(x & 0xF, y, z & 0xF);
        } else {
            block = blockAccess.func_147439_a(x, y, z);
            meta = blockAccess.func_72805_g(x, y, z);
        }
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        Class<? extends TileEntity> expectedClass = this.getTeClass(meta, null, null);
        Class<?> clazz = actualClass = te != null ? te.getClass() : null;
        if (actualClass != expectedClass) {
            if (block != this) {
                if (Util.inDev()) {
                    StackTraceElement[] st = new Throwable().getStackTrace();
                    IC2.log.warn(LogCategory.Block, "Own tile entity query from %s to foreign block %s instead of %s at %s.", new Object[]{st.length > 1 ? st[1] : "?", block != null ? block.getClass() : null, ((Object)((Object)this)).getClass(), Util.formatPosition((IBlockAccess)blockAccess, (int)x, (int)y, (int)z)});
                }
                return null;
            }
            IC2.log.warn(LogCategory.Block, "Mismatched tile entity at %s, got %s, expected %s.", new Object[]{Util.formatPosition((IBlockAccess)blockAccess, (int)x, (int)y, (int)z), actualClass, expectedClass});
            if (blockAccess instanceof World) {
                World world = (World)blockAccess;
                te = this.createTileEntity(world, meta);
                world.func_147455_a(x, y, z, te);
            } else {
                return null;
            }
        }
        return te;
    }

    public final TileEntity createTileEntity(World world, int metadata) {
        MutableObject ctorArgTypes = new MutableObject(emptyClassArray);
        MutableObject ctorArgs = new MutableObject((Object)emptyObjArray);
        Class<? extends TileEntity> teClass = this.getTeClass(metadata, (MutableObject<Class<?>[]>)ctorArgTypes, (MutableObject<Object[]>)ctorArgs);
        if (teClass == null) {
            return null;
        }
        try {
            Constructor<? extends TileEntity> ctor = teClass.getConstructor((Class[])ctorArgTypes.getValue());
            return ctor.newInstance((Object[])ctorArgs.getValue());
        }
        catch (Throwable t) {
            throw new RuntimeException("Error constructing " + teClass + " with " + Arrays.asList((Object[])ctorArgTypes.getValue()) + ", " + Arrays.asList((Object[])ctorArgs.getValue()) + ".", t);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemStack) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        TileEntity tileEntity = this.getOwnTe((IBlockAccess)world, x, y, z);
        if (tileEntity instanceof IWrenchable) {
            IWrenchable te = (IWrenchable)tileEntity;
            if (entityliving == null) {
                te.setFacing((short)2);
            } else {
                int l = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                switch (l) {
                    case 0: {
                        te.setFacing((short)2);
                        break;
                    }
                    case 1: {
                        te.setFacing((short)5);
                        break;
                    }
                    case 2: {
                        te.setFacing((short)3);
                        break;
                    }
                    case 3: {
                        te.setFacing((short)4);
                    }
                }
            }
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        Iterator<TileEntity> it = tesBeforeBreak.descendingIterator();
        while (it.hasNext()) {
            TileEntity te = it.next();
            if (te.func_145831_w() != world || te.field_145851_c != x || te.field_145848_d != y || te.field_145849_e != z) continue;
            it.remove();
            break;
        }
    }

    public String getTextureName(int index) {
        switch (index) {
            case 0: {
                String ret = "blockCable";
                return ret;
            }
            case 1: {
                String ret = "blockCableO";
                return ret;
            }
            case 2: {
                String ret = "blockGoldCable";
                return ret;
            }
            case 3: {
                String ret = "blockGoldCableI";
                return ret;
            }
            case 4: {
                String ret = "blockGoldCableII";
                return ret;
            }
            case 5: {
                String ret = "blockIronCable";
                return ret;
            }
            case 6: {
                String ret = "blockIronCableI";
                return ret;
            }
            case 7: {
                String ret = "blockIronCableII";
                return ret;
            }
            case 8: {
                String ret = "blockIronCableIIII";
                return ret;
            }
            case 9: {
                String ret = "blockGlassCable";
                return ret;
            }
            case 10: {
                String ret = "blockGlassCableI";
                return ret;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityCable te = (TileEntityCable)this.getOwnTe(blockAccess, x, y, z);
        if (te == null) {
            return null;
        }
        if (te.foamed == 0) {
            return super.func_149673_e(blockAccess, x, y, z, side);
        }
        if (te.foamed == 1) {
            return StackUtil.getBlock((ItemStack)IUItem.constructionFoam).func_149691_a(side, 0);
        }
        Block referencedBlock = te.getReferencedBlock(side);
        if (referencedBlock != null) {
            try {
                return referencedBlock.func_149691_a(te.retextureRefSide[side], te.retextureRefMeta[side]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return StackUtil.getBlock((ItemStack)IUItem.constructionFoamWall).func_149691_a(side, (int)te.foamColor);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 origin, Vec3 absDirection) {
        TileEntityCable te = (TileEntityCable)this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te == null) {
            return null;
        }
        Vec3 direction = Vec3.func_72443_a((double)(absDirection.field_72450_a - origin.field_72450_a), (double)(absDirection.field_72448_b - origin.field_72448_b), (double)(absDirection.field_72449_c - origin.field_72449_c));
        double maxLength = direction.func_72433_c();
        double halfThickness = te.foamed > 0 ? 0.5 : (double)te.getCableThickness() / 2.0;
        boolean hit = false;
        Vec3 intersection = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection((Vec3)origin, (Vec3)direction, (AxisAlignedBB)AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness)), (Vec3)intersection);
        if (intersectingDirection != null && intersection.func_72438_d(origin) <= maxLength) {
            hit = true;
        } else if (halfThickness < 0.5) {
            int mask = 1;
            for (Direction dir : Direction.directions) {
                if ((te.connectivity & mask) == 0) {
                    mask *= 2;
                    continue;
                }
                mask *= 2;
                AxisAlignedBB bbox = null;
                switch (dir) {
                    case XN: {
                        bbox = AxisAlignedBB.func_72330_a((double)x, (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                        break;
                    }
                    case XP: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 1.0), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                        break;
                    }
                    case YN: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)y, (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 + halfThickness));
                        break;
                    }
                    case YP: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 1.0), (double)((double)z + 0.5 + halfThickness));
                        break;
                    }
                    case ZN: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)z, (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5));
                        break;
                    }
                    case ZP: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 1.0));
                    }
                }
                intersectingDirection = AabbUtil.getIntersection((Vec3)origin, (Vec3)direction, bbox, (Vec3)intersection);
                if (intersectingDirection == null || !(intersection.func_72438_d(origin) <= maxLength)) continue;
                hit = true;
                break;
            }
        }
        if (hit) {
            return new MovingObjectPosition(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(int x, int y, int z, int meta) {
        double halfThickness = 0.25;
        if (meta == 13) {
            halfThickness = 0.25;
        }
        return AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, true);
    }

    public AxisAlignedBB getCommonBoundingBoxFromPool(World world, int x, int y, int z, boolean selectionBoundingBox) {
        TileEntityCable te = (TileEntityCable)this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te == null) {
            return this.getCollisionBoundingBoxFromPool(x, y, z, 3);
        }
        double halfThickness = te.foamed == 1 && selectionBoundingBox ? 0.5 : (double)te.getCableThickness() / 2.0;
        double minX1 = (double)x + 0.5 - halfThickness;
        double minY1 = (double)y + 0.5 - halfThickness;
        double minZ1 = (double)z + 0.5 - halfThickness;
        double maxX1 = (double)x + 0.5 + halfThickness;
        double maxY1 = (double)y + 0.5 + halfThickness;
        double maxZ1 = (double)z + 0.5 + halfThickness;
        if ((te.connectivity & 1) != 0) {
            minX1 = x;
        }
        if ((te.connectivity & 4) != 0) {
            minY1 = y;
        }
        if ((te.connectivity & 0x10) != 0) {
            minZ1 = z;
        }
        if ((te.connectivity & 2) != 0) {
            maxX1 = x + 1;
        }
        if ((te.connectivity & 8) != 0) {
            maxY1 = y + 1;
        }
        if ((te.connectivity & 0x20) != 0) {
            maxZ1 = z + 1;
        }
        return AxisAlignedBB.func_72330_a((double)minX1, (double)minY1, (double)minZ1, (double)maxX1, (double)maxY1, (double)maxZ1);
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        TileEntityCable te = (TileEntityCable)this.getOwnTe(world, x, y, z);
        if (te == null) {
            return false;
        }
        return te.foamed > 0;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float xOffset, float yOffset, float zOffset) {
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        super.func_149695_a(world, x, y, z, neighbor);
        if (IUCore.proxy.isSimulating()) {
            TileEntityCable te = (TileEntityCable)this.getOwnTe((IBlockAccess)world, x, y, z);
            if (te == null) {
                return;
            }
            te.onNeighborBlockChange();
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer entityPlayer, int x, int y, int z) {
        TileEntityCable te = (TileEntityCable)this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te == null) {
            world.func_147468_f(x, y, z);
        }
        if (Objects.requireNonNull(te).foamed > 0) {
            te.changeFoam((byte)0);
            world.func_147459_d(x, y, z, (Block)this);
            return false;
        }
        return world.func_147468_f(x, y, z);
    }

    public boolean canHarvestBlock(EntityPlayer player, int md) {
        return true;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityCable te = (TileEntityCable)this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te != null) {
            if (te.cableType == 14) {
                ret.add(new ItemStack((Item)IUItem.cable, 1, 13));
                return ret;
            }
            ret.add(new ItemStack((Item)IUItem.cable, 1, (int)te.cableType));
        } else {
            ret.add(new ItemStack((Item)IUItem.cable, 1, metadata));
        }
        return ret;
    }

    public Class<? extends TileEntity> getTeClass(int meta, MutableObject<Class<?>[]> ctorArgTypes, MutableObject<Object[]> ctorArgs) {
        if (meta >= 13) {
            ++meta;
        }
        if (ctorArgTypes != null) {
            ctorArgTypes.setValue((Object)new Class[]{Short.TYPE});
        }
        if (ctorArgs != null) {
            ctorArgs.setValue((Object)new Object[]{(short)meta});
        }
        return TileEntityCable.class;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return IUCore.proxy.getRenderId("cable");
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149699_a(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b() instanceof ItemToolCutter) {
            ItemToolCutter.cutInsulationFrom((ItemStack)entityplayer.func_71045_bC(), (World)world, (int)i, (int)j, (int)k);
        }
    }

    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return 0;
    }

    public void func_149666_a(Item j, CreativeTabs tabs, List itemList) {
        Item item = Item.func_150898_a((Block)this);
        if (!item.func_77614_k()) {
            itemList.add(new ItemStack((Block)this));
        } else {
            ItemStack is;
            for (int i = 0; i < 16 && (is = new ItemStack((Block)this, 1, i)).func_77973_b().func_77667_c(is) != null; ++i) {
                itemList.add(is);
            }
        }
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntityCable te = (TileEntityCable)this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te == null) {
            return 0.0f;
        }
        if (te.foamed == 1) {
            return 0.01f;
        }
        if (te.foamed == 2) {
            return 3.0f;
        }
        return 0.2f;
    }

    public float getExplosionResistance(Entity exploder, World world, int x, int y, int z, double src_x, double src_y, double src_z) {
        return 0.0f;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        TileEntityCable te = (TileEntityCable)this.getOwnTe(world, x, y, z);
        if (te == null) {
            return 0;
        }
        if (te.foamed == 2) {
            return 255;
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int direction) {
        int meta = world.func_72805_g(x, y, z);
        return meta == 11 || meta == 12;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ArrayList<ItemStack> ret = this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
        if (ret.isEmpty()) {
            return null;
        }
        return (ItemStack)ret.get(0);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntityCable te;
        if (IUCore.proxy.isSimulating() && (te = (TileEntityCable)this.getOwnTe((IBlockAccess)world, x, y, z)) == null) {
            return 0;
        }
        return 0;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        int newFacing;
        IWrenchable te;
        if (axis == ForgeDirection.UNKNOWN) {
            return false;
        }
        TileEntity tileEntity = this.getOwnTe((IBlockAccess)worldObj, x, y, z);
        if (tileEntity instanceof IWrenchable && (te = (IWrenchable)tileEntity).wrenchCanSetFacing(null, newFacing = ForgeDirection.getOrientation((int)te.getFacing()).getRotation(axis).ordinal())) {
            te.setFacing((short)newFacing);
        }
        return false;
    }

    @SubscribeEvent
    public void onRetexture(RetextureEvent event) {
        if (event.world.func_147439_a(event.x, event.y, event.z) != this) {
            return;
        }
        TileEntityCable te = (TileEntityCable)this.getOwnTe((IBlockAccess)event.world, event.x, event.y, event.z);
        if (te == null) {
            return;
        }
        if (te.retexture(event.side, event.referencedBlock, event.referencedMeta, event.referencedSide)) {
            event.applied = true;
        }
    }

    public int func_149720_d(IBlockAccess par1iBlockAccess, int x, int y, int z) {
        if (this.colorMultiplier != -1) {
            return this.colorMultiplier;
        }
        return super.func_149720_d(par1iBlockAccess, x, y, z);
    }
}

