/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.yumalib.event_handlers;

import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.oredict.OreDictionary;
import yuma140902.yumalib.config.YLConfigCore;

public class TooltipHandler {
    static void onTooltipShown(ItemTooltipEvent event) {
        Block block;
        boolean isInAdvancedMode = event.showAdvancedItemTooltips;
        ItemStack itemstack = event.itemStack;
        if (YLConfigCore.Tooltip.showOreDic.toBoolean(isInAdvancedMode)) {
            int[] oreIDs = OreDictionary.getOreIDs((ItemStack)itemstack);
            for (int i = 0; i < oreIDs.length; ++i) {
                event.toolTip.add(OreDictionary.getOreName((int)oreIDs[i]));
            }
        }
        if (YLConfigCore.Tooltip.showBlockMaterialInfo.toBoolean(isInAdvancedMode) && (block = Block.func_149634_a((Item)itemstack.func_77973_b())) != null && block != Blocks.field_150350_a) {
            Material material = block.func_149688_o();
            event.toolTip.add("Material: " + TooltipHandler.getMaterialName(material));
            String harvestToolInfo = TooltipHandler.getHarvestTool(block, 0);
            if (harvestToolInfo != null) {
                event.toolTip.add("HarvestTool: " + harvestToolInfo);
            }
            event.toolTip.add("SoundType: " + TooltipHandler.getStepSoundName(block.field_149762_H));
        }
        if (YLConfigCore.Tooltip.showRegistryName.toBoolean(isInAdvancedMode)) {
            String registyName = GameData.getItemRegistry().func_148750_c((Object)itemstack.func_77973_b());
            event.toolTip.add(registyName);
        }
    }

    private static String getMaterialName(Material material) {
        if (material == Material.field_151579_a) {
            return "air";
        }
        if (material == Material.field_151577_b) {
            return "grass";
        }
        if (material == Material.field_151578_c) {
            return "ground";
        }
        if (material == Material.field_151575_d) {
            return "wood";
        }
        if (material == Material.field_151576_e) {
            return "rock";
        }
        if (material == Material.field_151573_f) {
            return "iron";
        }
        if (material == Material.field_151574_g) {
            return "anvil";
        }
        if (material == Material.field_151586_h) {
            return "water";
        }
        if (material == Material.field_151587_i) {
            return "lava";
        }
        if (material == Material.field_151584_j) {
            return "leaves";
        }
        if (material == Material.field_151585_k) {
            return "plants";
        }
        if (material == Material.field_151582_l) {
            return "vine";
        }
        if (material == Material.field_151583_m) {
            return "sponge";
        }
        if (material == Material.field_151580_n) {
            return "cloth";
        }
        if (material == Material.field_151581_o) {
            return "fire";
        }
        if (material == Material.field_151595_p) {
            return "sand";
        }
        if (material == Material.field_151594_q) {
            return "circuits";
        }
        if (material == Material.field_151593_r) {
            return "carpet";
        }
        if (material == Material.field_151592_s) {
            return "glass";
        }
        if (material == Material.field_151591_t) {
            return "redstoneLight";
        }
        if (material == Material.field_151590_u) {
            return "tnt";
        }
        if (material == Material.field_151589_v) {
            return "coral";
        }
        if (material == Material.field_151588_w) {
            return "ice";
        }
        if (material == Material.field_151598_x) {
            return "packedIce";
        }
        if (material == Material.field_151597_y) {
            return "snow";
        }
        if (material == Material.field_151596_z) {
            return "craftedSnow";
        }
        if (material == Material.field_151570_A) {
            return "cactus";
        }
        if (material == Material.field_151571_B) {
            return "clay";
        }
        if (material == Material.field_151572_C) {
            return "gourd";
        }
        if (material == Material.field_151566_D) {
            return "dragonEgg";
        }
        if (material == Material.field_151567_E) {
            return "portal";
        }
        if (material == Material.field_151568_F) {
            return "cake";
        }
        if (material == Material.field_151569_G) {
            return "web";
        }
        if (material == Material.field_76233_E) {
            return "piston";
        }
        return "custom";
    }

    private static String getStepSoundName(Block.SoundType stepSoundType) {
        if (stepSoundType == Block.field_149769_e) {
            return "soundTypeStone";
        }
        if (stepSoundType == Block.field_149766_f) {
            return "soundTypeWood";
        }
        if (stepSoundType == Block.field_149767_g) {
            return "soundTypeGravel";
        }
        if (stepSoundType == Block.field_149779_h) {
            return "soundTypeGrass";
        }
        if (stepSoundType == Block.field_149780_i) {
            return "soundTypePiston";
        }
        if (stepSoundType == Block.field_149777_j) {
            return "soundTypeMetal";
        }
        if (stepSoundType == Block.field_149778_k) {
            return "soundTypeGlass";
        }
        if (stepSoundType == Block.field_149775_l) {
            return "soundTypeCloth";
        }
        if (stepSoundType == Block.field_149776_m) {
            return "soundTypeSand";
        }
        if (stepSoundType == Block.field_149773_n) {
            return "soundTypeSnow";
        }
        if (stepSoundType == Block.field_149774_o) {
            return "soundTypeLadder";
        }
        if (stepSoundType == Block.field_149788_p) {
            return "soundTypeAnvil";
        }
        return "custom";
    }

    private static String getHarvestTool(Block block, int meta) {
        String tool = block.getHarvestTool(meta);
        int level = block.getHarvestLevel(meta);
        if (tool == null) {
            return null;
        }
        return tool + ", level: " + level;
    }
}

