/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.yumalib.api.world.gen.biome;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import yuma140902.yumalib.api.world.gen.biome.IBiomeDecorator;

public class BiomeDecorators {
    @Nonnull
    private static final List<IBiomeDecorator> decorators = new LinkedList<IBiomeDecorator>();

    public static void register(@Nonnull IBiomeDecorator decorator) {
        decorators.add(decorator);
    }

    public static void decorate(@Nonnull World world, int chunkX, int chunkZ, @Nonnull Random random) {
        BiomeGenBase biome = world.func_72807_a(chunkX + 8, chunkZ + 8);
        if (biome == null) {
            return;
        }
        for (IBiomeDecorator decorator : decorators) {
            decorator.tryDecorate(world, biome, chunkX, chunkZ, random);
        }
    }
}

