/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.yumalib.api.util;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import yuma140902.yumalib.api.util.BlockPos;

public class WorldUtils {
    public static Block getBlock(World world, BlockPos pos) {
        return world.func_147439_a(pos.x(), pos.y(), pos.z());
    }

    public static boolean isAir(World world, BlockPos pos) {
        return world.func_147437_c(pos.x(), pos.y(), pos.z());
    }

    public static int getMeta(World world, BlockPos pos) {
        return world.func_72805_g(pos.x(), pos.y(), pos.z());
    }

    public static void setMeta(World world, int x, int y, int z, int meta, SetBlockFlag flag) {
        world.func_72921_c(x, y, z, meta, flag.toInt());
    }

    public static void setMeta(World world, int x, int y, int z, int meta) {
        WorldUtils.setMeta(world, x, y, z, meta, SetBlockFlag.NORMAL);
    }

    public static boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection direction, boolean dflt) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (direction == ForgeDirection.DOWN && block instanceof BlockSlab) {
            return (8 & meta) != 8;
        }
        if (direction == ForgeDirection.DOWN && block instanceof BlockStairs) {
            return (4 & meta) != 4;
        }
        return world.isSideSolid(x, y, z, direction, dflt);
    }

    public static boolean noCollisionBox(World world, BlockPos pos) {
        Block block = WorldUtils.getBlock(world, pos);
        return block.func_149668_a(world, pos.x(), pos.y(), pos.z()) == null;
    }

    public static class SetBlockFlag {
        public static final SetBlockFlag NORMAL = new SetBlockFlag(true, true, false);
        private final boolean blockUpdate;
        private final boolean clientUpdate;
        private final boolean preventReRendering;

        public SetBlockFlag(boolean blockUpdate, boolean clientUpdate, boolean preventReRendering) {
            this.blockUpdate = blockUpdate;
            this.clientUpdate = clientUpdate;
            this.preventReRendering = preventReRendering;
        }

        public int toInt() {
            return (this.blockUpdate ? 1 : 0) | (this.clientUpdate ? 2 : 0) | (this.preventReRendering ? 4 : 0);
        }
    }
}

