/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.yumalib.api.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import yuma140902.yumalib.api.util.BlockPos;
import yuma140902.yumalib.api.util.WorldUtils;

public class BlockWithMetadata {
    @Nonnull
    public final Block block;
    public final int meta;

    public BlockWithMetadata(@Nonnull Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    @Nullable
    public static BlockWithMetadata fromCoord(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return null;
        }
        int meta = world.func_72805_g(x, y, z);
        return new BlockWithMetadata(block, meta);
    }

    @Nullable
    public static BlockWithMetadata fromPos(World world, @Nonnull BlockPos pos) {
        Block block = WorldUtils.getBlock(world, pos);
        if (block == null) {
            return null;
        }
        int meta = WorldUtils.getMeta(world, pos);
        return new BlockWithMetadata(block, meta);
    }
}

