/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.yumalib.api.util;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPos {
    private final int x;
    private final int y;
    private final int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public BlockPos offset(ForgeDirection direction) {
        return this.offset(direction, 1);
    }

    public BlockPos offset(ForgeDirection direction, int distance) {
        int x = this.x + direction.offsetX * distance;
        int y = this.y + direction.offsetY * distance;
        int z = this.z + direction.offsetZ * distance;
        return new BlockPos(x, y, z);
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("X", this.x);
        tag.func_74768_a("Y", this.y);
        tag.func_74768_a("Z", this.z);
    }

    public static BlockPos readFromNBT(NBTTagCompound tag) {
        int x = tag.func_74762_e("X");
        int y = tag.func_74762_e("Y");
        int z = tag.func_74762_e("Z");
        return new BlockPos(x, y, z);
    }
}

