/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.yumalib.api.update;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import yuma140902.uptodatemod.ModUpToDateMod;
import yuma140902.uptodatemod.config.ModConfigCore;
import yuma140902.yumalib.api.update.IUpdateChecker;
import yuma140902.yumalib.api.update.Version3;

public class TsvUpdateChecker
implements IUpdateChecker {
    public static final String LATEST_STR = "latest";
    public static final String RECOMMENDED_STR = "recommended";
    public String modName;
    public String homePageUrl;
    public String versionsTsvUrl;
    public String updateChannel;
    public String currentVersion;
    public String availableNewVersion;
    public HashMap<String, String> versions = null;

    public TsvUpdateChecker(String modName, String homePageUrl, String versionsTsvUrl, String currentVersion, String updateChannel) {
        this.modName = modName;
        this.homePageUrl = homePageUrl;
        this.versionsTsvUrl = versionsTsvUrl;
        this.currentVersion = currentVersion;
        this.availableNewVersion = currentVersion;
        this.updateChannel = updateChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFromUrl(String urlStr) {
        boolean hasError = false;
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setInstanceFollowRedirects(true);
            conn.setRequestMethod("GET");
            conn.connect();
            is = conn.getInputStream();
            isr = new InputStreamReader(is, "UTF8");
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            hasError = true;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                hasError = true;
            }
            try {
                isr.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                hasError = true;
            }
            try {
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                hasError = true;
            }
        }
        return hasError ? null : sb.toString();
    }

    private static HashMap<String, String> getVersionsTable(String tsv) {
        String[] lines;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (tsv == null || tsv.isEmpty()) {
            return hashMap;
        }
        for (String line : lines = tsv.split("[\\n\\r]")) {
            String[] tmp = line.split("\\t");
            if (tmp.length < 2) continue;
            hashMap.put(tmp[0], tmp[1]);
        }
        return hashMap;
    }

    @Override
    public void checkForUpdates() {
        String newestVersion;
        String newestVersionStr;
        String versionsTsv = TsvUpdateChecker.getFromUrl(this.versionsTsvUrl);
        if (versionsTsv == null || versionsTsv.isEmpty()) {
            return;
        }
        if (ModConfigCore.General.debugMode()) {
            ModUpToDateMod.LOGGER.info("versionsTsv:");
            ModUpToDateMod.LOGGER.info(versionsTsv);
        }
        this.versions = TsvUpdateChecker.getVersionsTable(versionsTsv);
        String string = newestVersionStr = LATEST_STR.equals(this.updateChannel) ? LATEST_STR : RECOMMENDED_STR;
        if (this.versions.keySet().contains(newestVersionStr) && Version3.isLaterThan(newestVersion = this.versions.get(newestVersionStr), this.currentVersion)) {
            this.availableNewVersion = newestVersion;
            return;
        }
    }

    @Override
    public boolean hasNewVersionAvailable() {
        return Version3.isLaterThan(this.availableNewVersion, this.currentVersion);
    }

    @Override
    public String getNewVersionUrl() {
        if (this.versions == null) {
            return this.homePageUrl;
        }
        if (this.versions.keySet().contains(this.availableNewVersion)) {
            return this.versions.get(this.availableNewVersion);
        }
        return this.homePageUrl;
    }

    @Override
    public String getAvailableNewVersion() {
        return this.availableNewVersion;
    }

    @Override
    public String getModName() {
        return this.modName;
    }
}

