/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.yumalib.api.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import yuma140902.yumalib.api.config.LangKey;
import yuma140902.yumalib.api.config.MultiLingualString;
import yuma140902.yumalib.api.config.PropertyBuilder;

public class CategoryBuilder {
    private final List<PropertyBuilder> properties = new ArrayList<PropertyBuilder>();
    private final List<String> order = new ArrayList<String>();
    private final String name;
    private boolean requireMcRestart = false;
    private boolean requireWorldRestart = false;
    private LangKey langKey;
    private MultiLingualString comment;

    public CategoryBuilder(String name) {
        this.name = name;
    }

    String name() {
        return this.name;
    }

    List<PropertyBuilder> properties() {
        return this.properties;
    }

    public CategoryBuilder add(PropertyBuilder property) {
        property.category(this.name());
        this.properties.add(property);
        this.order.add(property.name());
        return this;
    }

    public CategoryBuilder requireMcRestart() {
        this.requireMcRestart = true;
        return this;
    }

    public CategoryBuilder requireWorldRestart() {
        this.requireWorldRestart = true;
        return this;
    }

    public CategoryBuilder langKey(LangKey langKey) {
        this.langKey = langKey;
        return this;
    }

    public CategoryBuilder comment(MultiLingualString comment) {
        this.comment = comment;
        return this;
    }

    public CategoryBuilder comment(String enMessage, String jaMessage) {
        this.comment = MultiLingualString.en_ja(enMessage, jaMessage);
        return this;
    }

    public CategoryBuilder comment(String comment) {
        this.comment = MultiLingualString.single(comment);
        return this;
    }

    public void registerToForge(Configuration cfg) {
        if (this.comment != null) {
            cfg.setCategoryComment(this.name, this.comment.toString());
        }
        cfg.setCategoryRequiresMcRestart(this.name, this.requireMcRestart);
        cfg.setCategoryRequiresWorldRestart(this.name, this.requireWorldRestart);
        if (this.langKey != null) {
            cfg.setCategoryLanguageKey(this.name, this.langKey.toString());
        }
    }

    public void registerPropertiesToForge(Configuration cfg) {
        for (PropertyBuilder property : this.properties) {
            property.registerToForge(cfg);
        }
        cfg.setCategoryPropertyOrder(this.name, this.order);
    }

    public Property get(String propertyName, Configuration cfg) {
        return cfg.getCategory(this.name).get(propertyName);
    }
}

