/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.yumalib.api.blockstate;

import yuma140902.yumalib.api.blockstate.IBlockState;

public class VanillaRotatedPillarState<T extends Enum<T>>
implements IBlockState {
    protected final T blockType;
    protected final Axis axis;
    protected final BlockTypeProvider<T> provider;

    public VanillaRotatedPillarState(T blockType, Axis axis, Class<T> cls) {
        this(blockType, axis, new BlockTypeProvider<T>(cls));
    }

    protected VanillaRotatedPillarState(T blockType, Axis axis, BlockTypeProvider<T> blockTypeProvider) {
        this.blockType = blockType;
        this.axis = axis;
        this.provider = blockTypeProvider;
    }

    public static <T extends Enum<T>> VanillaRotatedPillarState<T> fromHitSide(int hitSide, T blockType, Class<T> cls) {
        return VanillaRotatedPillarState.fromHitSide(hitSide, blockType, new BlockTypeProvider<T>(cls));
    }

    protected static <T extends Enum<T>> VanillaRotatedPillarState<T> fromHitSide(int hitSide, T blockType, BlockTypeProvider<T> blockTypeProvider) {
        Axis axis;
        switch (hitSide) {
            case 0: 
            case 1: {
                axis = Axis.UP_DOWN;
                break;
            }
            case 2: 
            case 3: {
                axis = Axis.NORTH_SOUTH;
                break;
            }
            case 4: 
            case 5: {
                axis = Axis.EAST_WEST;
                break;
            }
            default: {
                axis = Axis.UP_DOWN;
            }
        }
        return new VanillaRotatedPillarState<T>(blockType, axis, blockTypeProvider);
    }

    public static <T extends Enum<T>> VanillaRotatedPillarState<T> fromMetadata(int meta, Class<T> cls) {
        return VanillaRotatedPillarState.fromMetadata(meta, new BlockTypeProvider<T>(cls));
    }

    protected static <T extends Enum<T>> VanillaRotatedPillarState<T> fromMetadata(int meta, BlockTypeProvider<T> blockTypeProvider) {
        T blockType = blockTypeProvider.getBlockType(meta & 3);
        Axis axis = Axis.fromMetadata(meta);
        return new VanillaRotatedPillarState<T>(blockType, axis, blockTypeProvider);
    }

    public VanillaRotatedPillarState<T> blockTypeChanged(T blockType) {
        return new VanillaRotatedPillarState<T>(blockType, this.axis, this.provider);
    }

    public T blockType() {
        return this.blockType;
    }

    public Axis axis() {
        return this.axis;
    }

    @Override
    public int metadata() {
        return this.provider.getBit(this.blockType) | this.axis.bit;
    }

    private static class BlockTypeProvider<T extends Enum<T>> {
        private final T[] values;

        public BlockTypeProvider(Class<T> cls) {
            this.values = (Enum[])cls.getEnumConstants();
            if (this.values.length == 0) {
                throw new IllegalArgumentException("No block types. Try using NoBlockType.NONE");
            }
            if (this.values.length >= 5) {
                throw new IllegalArgumentException("Too many block types");
            }
        }

        public T getBlockType(int bit) {
            return this.values[bit % this.values.length];
        }

        public int getBit(T blockType) {
            return ((Enum)blockType).ordinal();
        }
    }

    public static enum Axis {
        UP_DOWN(0),
        EAST_WEST(4),
        NORTH_SOUTH(8),
        NO_AXIS(12);

        private final byte bit;

        private Axis(byte bit) {
            this.bit = bit;
        }

        public static Axis fromMetadata(int meta) {
            int axisBit = meta & 0xC;
            for (Axis axis : Axis.values()) {
                if (axis.bit != axisBit) continue;
                return axis;
            }
            return UP_DOWN;
        }
    }

    public static enum GenericBlockType {
        T1,
        T2,
        T3,
        T4;

    }

    public static enum NoBlockType {
        NONE;

    }
}

