/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.yumalib.api.blockstate;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import yuma140902.yumalib.api.blockstate.IBlockState;

public class GenericTrapdoorState
implements IBlockState {
    protected final Orientation orientation;
    protected final boolean isOpen;
    protected final boolean isUpper;

    private GenericTrapdoorState(Orientation orientation, boolean isOpen, boolean isUpper) {
        this.orientation = orientation;
        this.isOpen = isOpen;
        this.isUpper = isUpper;
    }

    public static GenericTrapdoorState fromMetadata(int metadata) {
        Orientation orientation = Orientation.values()[metadata & 3];
        boolean isOpen = (metadata & 4) != 0;
        boolean isUpper = (metadata & 8) != 0;
        return new GenericTrapdoorState(orientation, isOpen, isUpper);
    }

    public GenericTrapdoorState(int hitSide, float hitY) {
        this.orientation = Orientation.fromSide(hitSide);
        this.isOpen = false;
        this.isUpper = hitSide != 1 && hitSide != 0 && hitY > 0.5f ? true : (hitSide == 1 ? false : hitSide == 0);
    }

    public GenericTrapdoorState rotate(EntityLivingBase placer) {
        int l = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        Orientation orientation = l == 0 ? Orientation.SOUTH : (l == 1 ? Orientation.WEST : (l == 2 ? Orientation.NORTH : Orientation.EAST));
        return new GenericTrapdoorState(orientation, this.isOpen, this.isUpper);
    }

    public Orientation orientation() {
        return this.orientation;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isUpper() {
        return this.isUpper;
    }

    @Override
    public int metadata() {
        return this.orientation.ordinal() & 3 | (this.isOpen ? 4 : 0) | (this.isUpper ? 8 : 0);
    }

    public static enum Orientation {
        SOUTH,
        NORTH,
        EAST,
        WEST;


        public static boolean isSameSide(int side, Orientation orientation) {
            return side == 3 && orientation == SOUTH || side == 2 && orientation == NORTH || side == 5 && orientation == EAST || side == 4 && orientation == WEST;
        }

        public static boolean isOppositeSide(int side, Orientation orientation) {
            return side == 2 && orientation == SOUTH || side == 3 && orientation == NORTH || side == 4 && orientation == EAST || side == 5 && orientation == WEST;
        }

        public static Orientation fromSide(int side) {
            return side == 3 ? NORTH : (side == 2 ? SOUTH : (side == 5 ? WEST : (side == 4 ? EAST : SOUTH)));
        }
    }
}

