/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.yumalib.api.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import yuma140902.yumalib.api.blocks.BlockGenericTrapDoor;
import yuma140902.yumalib.api.util.BlockWithMetadata;
import yuma140902.yumalib.api.util.ItemWithMetadata;

public class TrapdoorBuilder {
    private Material material;
    private String name;
    private ItemWithMetadata ingredient;
    private float hardness;
    private Block.SoundType stepSound;
    private boolean rotateTex = true;
    private BlockWithMetadata blockForSideTex;

    private TrapdoorBuilder() {
    }

    public static TrapdoorBuilder ofWooden(String name) {
        TrapdoorBuilder builder = new TrapdoorBuilder();
        builder.name = name;
        builder.material = Material.field_151575_d;
        builder.hardness = 3.0f;
        builder.stepSound = Block.field_149766_f;
        return builder;
    }

    public static TrapdoorBuilder ofWooden(String name, int plankMeta) {
        return TrapdoorBuilder.ofWooden(name).ingredient(plankMeta).sideTex(plankMeta);
    }

    public static TrapdoorBuilder ofMetal(String name) {
        TrapdoorBuilder builder = new TrapdoorBuilder();
        builder.name = name;
        builder.material = Material.field_151573_f;
        builder.hardness = 5.0f;
        builder.stepSound = Block.field_149777_j;
        return builder;
    }

    public TrapdoorBuilder ingredient(ItemWithMetadata ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    protected TrapdoorBuilder ingredient(int plankMeta) {
        return this.ingredient(new ItemWithMetadata(Blocks.field_150344_f, plankMeta));
    }

    public TrapdoorBuilder sideTex(Block block, int metadata) {
        this.blockForSideTex = new BlockWithMetadata(block, metadata);
        return this;
    }

    protected TrapdoorBuilder sideTex(int plankMeta) {
        return this.sideTex(Blocks.field_150344_f, plankMeta);
    }

    public TrapdoorBuilder noRotateTex() {
        this.rotateTex = false;
        return this;
    }

    public BlockGenericTrapDoor build() {
        return new BlockGenericTrapDoor(this.material, this.name, this.hardness, this.stepSound, this.ingredient, this.rotateTex, this.blockForSideTex != null, this.blockForSideTex);
    }
}

