/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.yumalib.api.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import yuma140902.yumalib.api.blocks.BlockGenericSlab;

public class SlabBuilder {
    private final Block baseBlock;
    private int meta = 0;
    private final String name;
    private String specialSideTextureName = null;
    private boolean ignoreMetaInRecipe = false;

    private SlabBuilder(@Nullable Block baseBlock, String name) {
        this.baseBlock = baseBlock;
        this.name = name;
    }

    public static SlabBuilder of(@Nullable Block baseBlock, String name) {
        return new SlabBuilder(baseBlock, name);
    }

    public SlabBuilder meta(int meta) {
        this.meta = meta;
        return this;
    }

    public SlabBuilder specialSideTexture(String name) {
        this.specialSideTextureName = name;
        return this;
    }

    public SlabBuilder setIgnoreMetaInRecipe() {
        this.ignoreMetaInRecipe = true;
        return this;
    }

    @Nullable
    public BlockGenericSlab build() {
        if (this.baseBlock == null) {
            return null;
        }
        return new BlockGenericSlab(false, this.baseBlock, this.meta, this.name, this.specialSideTextureName, this.ignoreMetaInRecipe);
    }
}

