/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.yumalib.api.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import yuma140902.uptodatemod.registry.RecipeRegister;
import yuma140902.yumalib.api.IHasRecipes;
import yuma140902.yumalib.api.IRegisterable;
import yuma140902.yumalib.api.blockstate.GenericTrapdoorState;
import yuma140902.yumalib.api.items.ItemBlockGenericTrapdoor;
import yuma140902.yumalib.api.registry.Contexts;
import yuma140902.yumalib.api.util.BlockWithMetadata;
import yuma140902.yumalib.api.util.ItemWithMetadata;
import yuma140902.yumalib.api.util.WorldUtils;

public class BlockGenericTrapDoor
extends BlockTrapDoor
implements IRegisterable,
IHasRecipes {
    private final String name;
    private final ItemWithMetadata ingredient;
    private final boolean rotateTex;
    private final boolean sideTex;
    private final BlockWithMetadata blockForSideTex;
    private IIcon icon0;
    private IIcon icon90;
    private IIcon icon180;
    private IIcon icon270;

    protected BlockGenericTrapDoor(Material material, String name, float hardness, Block.SoundType stepSound, ItemWithMetadata ingredient, boolean rotateTex, boolean sideTex, BlockWithMetadata blockForSideTex) {
        super(material);
        this.name = name;
        this.ingredient = ingredient;
        this.rotateTex = rotateTex;
        this.sideTex = sideTex;
        this.blockForSideTex = blockForSideTex;
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149711_c(hardness);
        this.func_149672_a(stepSound);
    }

    public void func_149651_a(IIconRegister register) {
        super.func_149651_a(register);
        this.icon0 = register.func_94245_a(this.func_149641_N());
        if (this.rotateTex) {
            this.icon90 = register.func_94245_a(this.func_149641_N() + "_90");
            this.icon180 = register.func_94245_a(this.func_149641_N() + "_180");
            this.icon270 = register.func_94245_a(this.func_149641_N() + "_270");
        } else {
            this.icon180 = this.icon270 = this.icon0;
            this.icon90 = this.icon270;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private IIcon getSideIcon() {
        return this.sideTex ? this.blockForSideTex.block.func_149691_a(1, this.blockForSideTex.meta) : this.icon0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        GenericTrapdoorState state = GenericTrapdoorState.fromMetadata(meta);
        GenericTrapdoorState.Orientation orientation = state.orientation();
        boolean isOpen = state.isOpen();
        boolean isTop = state.isUpper();
        if (!isOpen) {
            if (side == 1 || side == 0) {
                switch (orientation) {
                    case SOUTH: {
                        return this.icon0;
                    }
                    case NORTH: {
                        return this.icon180;
                    }
                    case EAST: {
                        return this.icon270;
                    }
                    case WEST: {
                        return this.icon90;
                    }
                }
            }
            return this.getSideIcon();
        }
        if (isTop) {
            if (GenericTrapdoorState.Orientation.isSameSide(side, orientation) || GenericTrapdoorState.Orientation.isOppositeSide(side, orientation)) {
                return this.icon180;
            }
            return this.getSideIcon();
        }
        if (GenericTrapdoorState.Orientation.isSameSide(side, orientation) || GenericTrapdoorState.Orientation.isOppositeSide(side, orientation)) {
            return this.icon0;
        }
        return this.getSideIcon();
    }

    @Override
    public void register() {
        this.func_149663_c(Contexts.current().nameProvider().domainedUnlocalized(this.name));
        this.func_149658_d(Contexts.current().nameProvider().domainedTexture(this.name));
        GameRegistry.registerBlock((Block)this, ItemBlockGenericTrapdoor.class, (String)this.name);
    }

    @Override
    public void registerRecipes() {
        if (this.ingredient == null) {
            return;
        }
        RecipeRegister.addShaped(new ItemStack((Block)this, 2, 0), "###", "###", Character.valueOf('#'), this.ingredient.newItemStack());
    }

    public static void onBlockPlaced(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        GenericTrapdoorState state = side == 0 || side == 1 ? new GenericTrapdoorState(side, hitY).rotate((EntityLivingBase)player) : new GenericTrapdoorState(side, hitY);
        WorldUtils.setMeta(world, x, y, z, state.metadata());
    }
}

