/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.yumalib.api.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import yuma140902.uptodatemod.registry.RecipeRegister;
import yuma140902.yumalib.api.IHasRecipes;
import yuma140902.yumalib.api.IRegisterable;
import yuma140902.yumalib.api.items.ItemBlockGenericSlab;
import yuma140902.yumalib.api.registry.Contexts;

public class BlockGenericSlab
extends BlockSlab
implements IRegisterable,
IHasRecipes {
    private final Block baseBlock;
    private final int meta;
    private final String name;
    private final boolean useSpecialSideTexture;
    private final String specialSideTextureName;
    private final boolean ignoreMetaInRecipe;
    private IIcon specialSideTexture = null;
    private BlockGenericSlab slab;
    private BlockGenericSlab slabDouble;

    protected BlockGenericSlab(boolean isDouble, Block baseBlock, int meta, String name, String specialSideTextureName, boolean ignoreMetaInRecipe) {
        super(isDouble, baseBlock.func_149688_o());
        this.baseBlock = baseBlock;
        this.meta = meta;
        this.name = name;
        this.useSpecialSideTexture = specialSideTextureName != null;
        this.specialSideTextureName = specialSideTextureName;
        this.ignoreMetaInRecipe = ignoreMetaInRecipe;
        this.func_149672_a(baseBlock.field_149762_H);
        this.setHarvestLevel(baseBlock.getHarvestTool(0), baseBlock.getHarvestLevel(0));
        this.func_149713_g(0);
        this.func_149647_a(CreativeTabs.field_78030_b);
    }

    private void setSlabs(BlockGenericSlab slab, BlockGenericSlab slabDouble) {
        this.slab = slab;
        this.slabDouble = slabDouble;
    }

    @Override
    public void register() {
        if (this.isDouble()) {
            return;
        }
        BlockGenericSlab slabDouble = new BlockGenericSlab(true, this.baseBlock, this.meta, this.name, this.specialSideTextureName, this.ignoreMetaInRecipe);
        this.setSlabs(this, slabDouble);
        slabDouble.setSlabs(this, slabDouble);
        this.func_149663_c(Contexts.current().nameProvider().domainedUnlocalized(this.name));
        GameRegistry.registerBlock((Block)this, ItemBlockGenericSlab.class, (String)this.name);
        slabDouble.func_149663_c(Contexts.current().nameProvider().domainedUnlocalized(this.name));
        GameRegistry.registerBlock((Block)slabDouble, ItemBlockGenericSlab.class, (String)("double_" + this.name));
    }

    public BlockGenericSlab getSlab() {
        return this.slab;
    }

    public BlockGenericSlab getSlabDouble() {
        return this.slabDouble;
    }

    public boolean isDouble() {
        return this.field_150004_a;
    }

    @Override
    public void registerRecipes() {
        if (this.isDouble()) {
            return;
        }
        int meta = this.ignoreMetaInRecipe ? Short.MAX_VALUE : this.meta;
        RecipeRegister.addShaped(new ItemStack((Block)this.getSlab(), 6), "###", Character.valueOf('#'), new ItemStack(this.baseBlock, 1, meta));
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return this.baseBlock.func_149712_f(world, x, y, z);
    }

    public float func_149638_a(Entity entity) {
        return this.baseBlock.func_149638_a(entity);
    }

    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)this.slab);
    }

    public int func_149692_a(int p_149692_1_) {
        return 0;
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.func_150898_a((Block)this.slab);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return this.isDouble() ? 2 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this.useSpecialSideTexture) {
            switch (side) {
                case 0: 
                case 1: {
                    return this.baseBlock.func_149691_a(side, this.meta);
                }
            }
            return this.specialSideTexture;
        }
        return this.baseBlock.func_149691_a((meta & 1) == 0 ? side : 1, this.meta);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTab, List list) {
        if (!this.isDouble()) {
            super.func_149666_a(item, creativeTab, list);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        if (this.useSpecialSideTexture) {
            this.specialSideTexture = reg.func_94245_a(this.specialSideTextureName);
        }
    }

    public String func_150002_b(int p_150002_1_) {
        return Contexts.current().nameProvider().domainedUnlocalized(this.name);
    }
}

