/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.world.generation;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraft.world.biome.BiomeGenSwamp;
import net.minecraft.world.chunk.IChunkProvider;
import yuma140902.uptodatemod.MyBlocks;
import yuma140902.uptodatemod.config.ModConfigCore;
import yuma140902.uptodatemod.registry.EnumDisableableFeatures;
import yuma140902.uptodatemod.util.ListUtils;
import yuma140902.uptodatemod.world.generation.Fossiles;

public class UpToDateWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!ListUtils.contains(ModConfigCore.WorldGen.coarseDirtBlackList(), world.field_73011_w.field_76574_g) && ModConfigCore.WorldGen.genCoarseDirt() && EnumDisableableFeatures.coarseDirt.featureEnabled()) {
            this.generateCoarseDirt(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
        if (!ListUtils.contains(ModConfigCore.WorldGen.deepslateBlackList(), world.field_73011_w.field_76574_g) && ModConfigCore.WorldGen.genDeepslate() && EnumDisableableFeatures.deepslateStone.featureEnabled()) {
            this.generateDeepslateOres(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
        if (!ListUtils.contains(ModConfigCore.WorldGen.fossilesBlackList(), world.field_73011_w.field_76574_g) && ModConfigCore.WorldGen.genFossiles() && EnumDisableableFeatures.boneBlockAndFossile.featureEnabled()) {
            this.generateFossile(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    private void generateCoarseDirt(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int heightMax = world.func_72940_L();
        for (int x = chunkX * 16; x < chunkX * 16 + 16; ++x) {
            for (int z = chunkZ * 16; z < chunkZ * 16 + 16; ++z) {
                for (int y = 0; y < heightMax; ++y) {
                    if (world.func_147439_a(x, y, z) != Blocks.field_150346_d || world.func_72805_g(x, y, z) != 1) continue;
                    world.func_147465_d(x, y, z, (Block)MyBlocks.coarseDirt, 0, 2);
                }
            }
        }
    }

    private void generateDeepslateOres(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        for (int x = chunkX * 16; x < chunkX * 16 + 16; ++x) {
            for (int z = chunkZ * 16; z < chunkZ * 16 + 16; ++z) {
                for (int y = 0; y <= 16; ++y) {
                    Block block = world.func_147439_a(x, y, z);
                    if (block == Blocks.field_150365_q) {
                        world.func_147465_d(x, y, z, (Block)MyBlocks.deepslateCoalOre, 0, 2);
                        continue;
                    }
                    if (block == Blocks.field_150482_ag) {
                        world.func_147465_d(x, y, z, (Block)MyBlocks.deepslateDiamondOre, 0, 2);
                        continue;
                    }
                    if (block == Blocks.field_150412_bA) {
                        world.func_147465_d(x, y, z, (Block)MyBlocks.deepslateEmeraldOre, 0, 2);
                        continue;
                    }
                    if (block == Blocks.field_150352_o) {
                        world.func_147465_d(x, y, z, (Block)MyBlocks.deepslateGoldOre, 0, 2);
                        continue;
                    }
                    if (block == Blocks.field_150366_p) {
                        world.func_147465_d(x, y, z, (Block)MyBlocks.deepslateIronOre, 0, 2);
                        continue;
                    }
                    if (block == Blocks.field_150369_x) {
                        world.func_147465_d(x, y, z, (Block)MyBlocks.deepslateLapisOre, 0, 2);
                        continue;
                    }
                    if (block != Blocks.field_150450_ax && block != Blocks.field_150439_ay) continue;
                    world.func_147465_d(x, y, z, (Block)MyBlocks.deepslateRedstoneOre, 0, 2);
                }
            }
        }
    }

    private void generateFossile(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (random.nextInt(64) != 0) {
            return;
        }
        BiomeGenBase biome = world.field_73011_w.getBiomeGenForCoords(chunkX * 16, chunkZ * 16);
        if (biome instanceof BiomeGenDesert || biome instanceof BiomeGenSwamp) {
            int y;
            int x = chunkX * 16 + random.nextInt(16);
            int z = chunkZ * 16 + random.nextInt(16);
            for (y = 255; y >= 0 && world.func_147437_c(x, y, z); --y) {
            }
            int fossileType = random.nextInt(8);
            Fossiles fossile = Fossiles.getFossileByType(fossileType);
            fossile.spawnAt(world, x, y - random.nextInt(20), z, random);
        }
    }
}

