/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.world.generation;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Facing;
import net.minecraft.world.World;
import yuma140902.uptodatemod.MyBlocks;
import yuma140902.uptodatemod.util.DirectionUtil;

public abstract class Fossiles {
    private static final int[] facingToMeta = new int[]{0, 0, 8, 8, 4, 4};
    private static final Fossiles fossileRibExtraBig = new Fossiles(){

        @Override
        public void spawnAt(World world, int x, int y, int z, Random random) {
            int facing = random.nextInt(4) + 2;
            int right = DirectionUtil.rightSides[facing];
            int left = DirectionUtil.leftSides[facing];
            Fossiles.generatePillar(world, x, y, z, 13, facing, random);
            int ribX = x;
            int ribZ = z;
            ribX += Facing.field_71586_b[facing];
            ribZ += Facing.field_71585_d[facing];
            for (int rib = 0; rib < 6; ++rib) {
                int ribXRight = ribX;
                int ribZRight = ribZ;
                Fossiles.generatePillar(world, ribX + Facing.field_71586_b[right], y, ribZ + Facing.field_71585_d[right], 4, right, random);
                Fossiles.generatePillar(world, ribXRight += Facing.field_71586_b[right] * 4, y - 1, ribZRight += Facing.field_71585_d[right] * 4, 3, 0, random);
                Fossiles.generatePillar(world, ribXRight += Facing.field_71586_b[left], y - 3 - 1, ribZRight += Facing.field_71585_d[left], 2, left, random);
                int ribXLeft = ribX;
                int ribZLeft = ribZ;
                Fossiles.generatePillar(world, ribX + Facing.field_71586_b[left], y, ribZ + Facing.field_71585_d[left], 4, left, random);
                Fossiles.generatePillar(world, ribXLeft += Facing.field_71586_b[left] * 4, y - 1, ribZLeft += Facing.field_71585_d[left] * 4, 3, 0, random);
                Fossiles.generatePillar(world, ribXLeft += Facing.field_71586_b[right], y - 3 - 1, ribZLeft += Facing.field_71585_d[right], 2, right, random);
                ribX += Facing.field_71586_b[facing] * 2;
                ribZ += Facing.field_71585_d[facing] * 2;
            }
        }
    };
    private static final Fossiles fossileRibBig = new Fossiles(){

        @Override
        public void spawnAt(World world, int x, int y, int z, Random random) {
            int facing = random.nextInt(4) + 2;
            int right = DirectionUtil.rightSides[facing];
            int left = DirectionUtil.leftSides[facing];
            Fossiles.generatePillar(world, x, y, z, 13, facing, random);
            int ribX = x;
            int ribZ = z;
            ribX += Facing.field_71586_b[facing];
            ribZ += Facing.field_71585_d[facing];
            for (int rib = 0; rib < 6; ++rib) {
                int ribXRight = ribX;
                int ribZRight = ribZ;
                Fossiles.generatePillar(world, ribX + Facing.field_71586_b[right], y, ribZ + Facing.field_71585_d[right], 3, right, random);
                Fossiles.generatePillar(world, ribXRight += Facing.field_71586_b[right] * 3, y - 1, ribZRight += Facing.field_71585_d[right] * 3, 3, 0, random);
                Fossiles.generatePillar(world, ribXRight += Facing.field_71586_b[left], y - 3, ribZRight += Facing.field_71585_d[left], 1, left, random);
                int ribXLeft = ribX;
                int ribZLeft = ribZ;
                Fossiles.generatePillar(world, ribX + Facing.field_71586_b[left], y, ribZ + Facing.field_71585_d[left], 3, left, random);
                Fossiles.generatePillar(world, ribXLeft += Facing.field_71586_b[left] * 3, y - 1, ribZLeft += Facing.field_71585_d[left] * 3, 3, 0, random);
                Fossiles.generatePillar(world, ribXLeft += Facing.field_71586_b[right], y - 3, ribZLeft += Facing.field_71585_d[right], 1, right, random);
                ribX += Facing.field_71586_b[facing] * 2;
                ribZ += Facing.field_71585_d[facing] * 2;
            }
        }
    };
    private static final Fossiles fossileRibMedium = new Fossiles(){

        @Override
        public void spawnAt(World world, int x, int y, int z, Random random) {
            int facing = random.nextInt(4) + 2;
            int right = DirectionUtil.rightSides[facing];
            int left = DirectionUtil.leftSides[facing];
            Fossiles.generatePillar(world, x, y, z, 13, facing, random);
            int ribX = x;
            int ribZ = z;
            ribX += Facing.field_71586_b[facing];
            ribZ += Facing.field_71585_d[facing];
            for (int rib = 0; rib < 6; ++rib) {
                int ribXRight = ribX;
                int ribZRight = ribZ;
                Fossiles.generatePillar(world, ribX + Facing.field_71586_b[right], y, ribZ + Facing.field_71585_d[right], 1, right, random);
                Fossiles.generatePillar(world, ribXRight += Facing.field_71586_b[right] * 2, y - 1, ribZRight += Facing.field_71585_d[right] * 2, 2, 0, random);
                Fossiles.generatePillar(world, ribXRight += Facing.field_71586_b[left], y - 2 - 1, ribZRight += Facing.field_71585_d[left], 1, left, random);
                int ribXLeft = ribX;
                int ribZLeft = ribZ;
                Fossiles.generatePillar(world, ribX + Facing.field_71586_b[left], y, ribZ + Facing.field_71585_d[left], 1, left, random);
                Fossiles.generatePillar(world, ribXLeft += Facing.field_71586_b[left] * 2, y - 1, ribZLeft += Facing.field_71585_d[left] * 2, 2, 0, random);
                Fossiles.generatePillar(world, ribXLeft += Facing.field_71586_b[right], y - 2 - 1, ribZLeft += Facing.field_71585_d[right], 1, right, random);
                ribX += Facing.field_71586_b[facing] * 2;
                ribZ += Facing.field_71585_d[facing] * 2;
            }
        }
    };
    private static final Fossiles fossileRibSmall = new Fossiles(){

        @Override
        public void spawnAt(World world, int x, int y, int z, Random random) {
            int facing = random.nextInt(4) + 2;
            int right = DirectionUtil.rightSides[facing];
            Fossiles.generatePillar(world, x, y, z, 13, facing, random);
            int ribX = x;
            int ribZ = z;
            ribX += Facing.field_71586_b[facing];
            ribZ += Facing.field_71585_d[facing];
            for (int rib = 0; rib < 6; ++rib) {
                int ribXRight = ribX;
                int ribZRight = ribZ;
                Fossiles.generatePillar(world, ribXRight += Facing.field_71586_b[right], y - 1, ribZRight += Facing.field_71585_d[right], 2, 0, random);
                ribX += Facing.field_71586_b[facing] * 2;
                ribZ += Facing.field_71585_d[facing] * 2;
            }
        }
    };
    private static final Fossiles fossileHeadSmall = new Fossiles(){
        private final int[][][] structure = new int[][][]{new int[][]{{4, 4, 4, 4}, {-1, 4, 4, -1}, {-1, 4, 4, -1}, {-1, -1, -1, -1}}, new int[][]{{0, -1, -1, 0}, {0, -1, -1, 0}, {0, -1, -1, 0}, {-1, 0, 0, -1}}, new int[][]{{0, 4, 4, 0}, {0, -1, -1, 0}, {0, -1, -1, 0}, {-1, 0, 0, -1}}, new int[][]{{0, -1, -1, 0}, {-1, 4, 4, -1}, {-1, 4, 4, -1}, {-1, -1, -1, -1}}};

        @Override
        public void spawnAt(World world, int x, int y, int z, Random random) {
            Fossiles.generateStructure(world, x, y, z, this.structure, random);
        }
    };
    private static final Fossiles fossileHeadMedium = new Fossiles(){
        private final int[][][] structure = new int[][][]{new int[][]{{4, 4, 4, 4, 4}, {-1, 4, 4, 4, -1}, {-1, 4, 4, 4, -1}, {-1, 4, 4, 4, -1}, {-1, -1, -1, -1, -1}}, new int[][]{{0, -1, 0, -1, 0}, {8, -1, -1, -1, 8}, {8, -1, -1, -1, 8}, {8, -1, -1, -1, 8}, {0, 4, 4, 4, 0}}, new int[][]{{0, 4, 4, 4, 0}, {8, -1, -1, -1, 8}, {8, -1, -1, -1, 8}, {8, -1, -1, -1, 8}, {0, 4, 4, 4, 0}}, new int[][]{{0, -1, -1, -1, 0}, {-1, 4, 4, 4, -1}, {-1, 4, 4, 4, -1}, {-1, 4, 4, 4, -1}, {-1, 4, 4, 4, -1}}};

        @Override
        public void spawnAt(World world, int x, int y, int z, Random random) {
            Fossiles.generateStructure(world, x, y, z, this.structure, random);
        }
    };
    private static final Fossiles fossileHeadBig = new Fossiles(){
        private final int[][][] structure = new int[][][]{new int[][]{{-1, -1, 4, -1, 4, -1, -1}, {-1, 4, 4, 4, 4, 4, -1}, {-1, 4, 4, 4, 4, 4, -1}, {-1, 4, 4, 4, 4, 4, -1}, {-1, -1, -1, -1, -1, -1, -1}}, new int[][]{{-1, 0, -1, 0, -1, 0, -1}, {0, -1, -1, -1, -1, -1, 0}, {8, -1, -1, -1, -1, -1, 8}, {0, -1, -1, -1, -1, -1, 0}, {-1, 0, 4, 4, 4, 0, -1}}, new int[][]{{-1, 4, 4, 4, 4, 4, -1}, {0, -1, -1, -1, -1, -1, 0}, {8, -1, -1, -1, -1, -1, 8}, {0, -1, -1, -1, -1, -1, 0}, {-1, 0, 4, 4, 4, 0, -1}}, new int[][]{{-1, 0, -1, -1, -1, 0, -1}, {0, -1, -1, -1, -1, -1, 0}, {8, -1, -1, -1, -1, -1, 8}, {0, -1, -1, -1, -1, -1, 0}, {-1, 0, 4, 4, 4, 0, -1}}, new int[][]{{-1, -1, -1, -1, -1, -1, -1}, {-1, 4, 4, 4, 4, 4, -1}, {-1, 4, 4, 4, 4, 4, -1}, {-1, 4, 4, 4, 4, 4, -1}, {-1, -1, -1, -1, -1, -1, -1}}};

        @Override
        public void spawnAt(World world, int x, int y, int z, Random random) {
            Fossiles.generateStructure(world, x, y, z, this.structure, random);
        }
    };
    private static final Fossiles fossileHeadExtraBig = new Fossiles(){
        private final int[][][] structure = new int[][][]{new int[][]{{-1, -1, -1, -1, -1, -1}, {-1, 4, 4, 4, 4, -1}, {-1, 4, 4, 4, 4, -1}, {-1, 4, 4, 4, 4, -1}, {-1, 4, 4, 4, 4, -1}, {-1, 4, 4, 4, 4, -1}, {-1, -1, -1, -1, -1, -1}}, new int[][]{{-1, -1, 4, 4, -1, -1}, {0, -1, -1, -1, -1, 0}, {8, -1, -1, -1, -1, 8}, {8, -1, -1, -1, -1, 8}, {8, -1, -1, -1, -1, 8}, {0, -1, -1, -1, -1, 0}, {-1, 0, 4, 4, 0, -1}}, new int[][]{{-1, 0, 0, 0, 0, -1}, {0, -1, -1, -1, -1, 0}, {8, -1, -1, -1, -1, 8}, {8, -1, -1, -1, -1, 8}, {8, -1, -1, -1, -1, 8}, {0, -1, -1, -1, -1, 0}, {-1, 0, 4, 4, 0, -1}}, new int[][]{{-1, 0, -1, -1, 0, -1}, {0, -1, -1, -1, -1, 0}, {8, -1, -1, -1, -1, 8}, {8, -1, -1, -1, -1, 8}, {8, -1, -1, -1, -1, 8}, {0, -1, -1, -1, -1, 0}, {-1, 0, 4, 4, 0, -1}}, new int[][]{{-1, -1, -1, -1, -1, -1}, {-1, 4, 4, 4, 4, -1}, {-1, 4, 4, 4, 4, -1}, {-1, 4, 4, 4, 4, -1}, {-1, 4, 4, 4, 4, -1}, {-1, 4, 4, 4, 4, -1}, {-1, -1, -1, -1, -1, -1}}};

        @Override
        public void spawnAt(World world, int x, int y, int z, Random random) {
            Fossiles.generateStructure(world, x, y, z, this.structure, random);
        }
    };

    public static Fossiles getFossileByType(int type) {
        switch (type) {
            case 0: {
                return fossileRibExtraBig;
            }
            case 1: {
                return fossileRibBig;
            }
            case 2: {
                return fossileRibMedium;
            }
            case 3: {
                return fossileRibSmall;
            }
            case 4: {
                return fossileHeadSmall;
            }
            case 5: {
                return fossileHeadMedium;
            }
            case 6: {
                return fossileHeadBig;
            }
            case 7: {
                return fossileHeadExtraBig;
            }
        }
        return fossileRibExtraBig;
    }

    private static void setBlock(World world, int x, int y, int z, int meta, Random random) {
        if (y == 0) {
            return;
        }
        int rand = random.nextInt(32);
        if (rand == 0) {
            return;
        }
        if (rand == 1) {
            world.func_147465_d(x, y, z, Blocks.field_150365_q, 0, 2);
        } else {
            world.func_147465_d(x, y, z, (Block)MyBlocks.boneBlock, meta, 2);
        }
    }

    private static void generatePillar(World world, int startX, int startY, int startZ, int length, int facing, Random random) {
        int meta = facingToMeta[facing];
        int offsetX = Facing.field_71586_b[facing];
        int offsetY = Facing.field_71587_c[facing];
        int offsetZ = Facing.field_71585_d[facing];
        while (length > 0) {
            Fossiles.setBlock(world, startX, startY, startZ, meta, random);
            startX += offsetX;
            startY += offsetY;
            startZ += offsetZ;
            --length;
        }
    }

    private static void generateStructure(World world, int startX, int startY, int startZ, int[][][] structure, Random random) {
        for (int offsetY = 0; offsetY < structure.length; ++offsetY) {
            for (int i = 0; i < structure[0].length; ++i) {
                for (int j = 0; j < structure[0][0].length; ++j) {
                    int meta = structure[offsetY][i][j];
                    if (meta < 0) continue;
                    Fossiles.setBlock(world, startX + j, startY - offsetY, startZ + i, meta, random);
                }
            }
        }
    }

    public abstract void spawnAt(World var1, int var2, int var3, int var4, Random var5);
}

